/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.events;

import com.legacy.dungeons_plus.DPConfig;
import com.legacy.dungeons_plus.DungeonsPlus;
import com.legacy.dungeons_plus.data.advancement.ThrownItemHitBlockTrigger;
import com.legacy.dungeons_plus.data.providers.DPAdvancementProv;
import com.legacy.dungeons_plus.data.providers.DPLangProvider;
import com.legacy.dungeons_plus.data.providers.DPLootProv;
import com.legacy.dungeons_plus.data.providers.DPTagProv;
import com.legacy.dungeons_plus.registry.DPItems;
import com.legacy.dungeons_plus.registry.DPLoot;
import com.legacy.dungeons_plus.registry.DPStructures;
import com.legacy.structure_gel.api.entity.EntityAccessHelper;
import com.legacy.structure_gel.api.events.RegisterLootTableAliasEvent;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class DPCommonEvents {

    @Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        protected static void commonInit(FMLCommonSetupEvent event) {
            ModList modList = ModList.get();
            DungeonsPlus.isWaystonesLoaded = modList.isLoaded("waystones");
            event.enqueueWork(() -> CriteriaTriggers.m_10595_((CriterionTrigger)ThrownItemHitBlockTrigger.TRIGGER));
        }

        @SubscribeEvent
        protected static void registerLootTableAlias(RegisterLootTableAliasEvent event) {
            event.register(DungeonsPlus.locate("tower/common"), DPLoot.Tower.CHEST_COMMON);
            event.register(DungeonsPlus.locate("tower/barrel"), DPLoot.Tower.CHEST_BARREL);
            event.register(DungeonsPlus.locate("tower/vex"), DPLoot.Tower.CHEST_VEX);
            event.register(DungeonsPlus.locate("tower/vex_map"), DPLoot.Tower.CHEST_VEX_MAP);
            event.register(DungeonsPlus.locate("tower/skeleton"), DPLoot.Tower.ENTITY_SKELETON);
            event.register(DungeonsPlus.locate("tower/spider"), DPLoot.Tower.ENTITY_SPIDER);
            event.register(DungeonsPlus.locate("tower/zombie"), DPLoot.Tower.ENTITY_ZOMBIE);
            event.register(DungeonsPlus.locate("reanimated_ruins/common"), DPLoot.ReanimatedRuins.CHEST_COMMON);
            event.register(DungeonsPlus.locate("reanimated_ruins/desert"), DPLoot.ReanimatedRuins.CHEST_DESERT);
            event.register(DungeonsPlus.locate("reanimated_ruins/desert_map"), DPLoot.ReanimatedRuins.CHEST_DESERT_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/frozen"), DPLoot.ReanimatedRuins.CHEST_FROZEN);
            event.register(DungeonsPlus.locate("reanimated_ruins/frozen_map"), DPLoot.ReanimatedRuins.CHEST_FROZEN_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/mossy"), DPLoot.ReanimatedRuins.CHEST_MOSSY);
            event.register(DungeonsPlus.locate("reanimated_ruins/mossy_map"), DPLoot.ReanimatedRuins.CHEST_MOSSY_MAP);
            event.register(DungeonsPlus.locate("reanimated_ruins/skeleton"), DPLoot.ReanimatedRuins.ENTITY_SKELETON);
            event.register(DungeonsPlus.locate("reanimated_ruins/zombie"), DPLoot.ReanimatedRuins.ENTITY_ZOMBIE);
            event.register(DungeonsPlus.locate("leviathan/common"), DPLoot.Leviathan.CHEST_COMMON);
            event.register(DungeonsPlus.locate("leviathan/rare"), DPLoot.Leviathan.CHEST_RARE);
            event.register(DungeonsPlus.locate("leviathan/husk"), DPLoot.Leviathan.ENTITY_HUSK);
            event.register(DungeonsPlus.locate("snowy_temple/common"), DPLoot.SnowyTemple.CHEST_COMMON);
            event.register(DungeonsPlus.locate("snowy_temple/rare"), DPLoot.SnowyTemple.CHEST_RARE);
            event.register(DungeonsPlus.locate("snowy_temple/stray"), DPLoot.SnowyTemple.ENTITY_STRAY);
            event.register(DungeonsPlus.locate("warped_garden/common"), DPLoot.WarpedGarden.CHEST_COMMON);
            event.register(DungeonsPlus.locate("warped_garden/rare"), DPLoot.WarpedGarden.CHEST_RARE);
            event.register(DungeonsPlus.locate("soul_prison/common"), DPLoot.SoulPrison.CHEST_COMMON);
            event.register(DungeonsPlus.locate("soul_prison/rare"), DPLoot.SoulPrison.CHEST_RARE);
            event.register(DungeonsPlus.locate("soul_prison/golden_armor"), DPLoot.SoulPrison.CHEST_GOLDEN_ARMOR);
        }

        @SubscribeEvent
        protected static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            boolean server = event.includeServer();
            boolean client = event.includeClient();
            DPTagProv.BlockProv blockTagProv = new DPTagProv.BlockProv(gen, event.getExistingFileHelper());
            gen.m_236039_(server, (DataProvider)blockTagProv);
            gen.m_236039_(server, (DataProvider)new DPTagProv.ItemProv(gen, blockTagProv, existingFileHelper));
            gen.m_236039_(server, (DataProvider)new DPTagProv.EntityTypeProv(gen, existingFileHelper));
            gen.m_236039_(server, (DataProvider)new DPTagProv.StructureProv(gen, existingFileHelper));
            gen.m_236039_(server, (DataProvider)new DPTagProv.BiomeProv(gen, existingFileHelper));
            gen.m_236039_(server, (DataProvider)new DPTagProv.EnchantmentProv(gen, existingFileHelper));
            gen.m_236039_(server, (DataProvider)new DPAdvancementProv(gen));
            gen.m_236039_(server, (DataProvider)new DPLootProv(gen));
            gen.m_236039_(client, (DataProvider)new DPLangProvider(gen));
        }
    }

    @Mod.EventBusSubscriber(modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBus {
        public static void onEntitySpawn(ServerLevelAccessor levelAccessor, Mob entity) {
            Level level = entity.m_9236_();
            if (!level.f_46443_) {
                ForgeBus.ifInStructure(levelAccessor, (Entity)entity, EntityType.f_20458_, DPStructures.LEVIATHAN, e -> {
                    RandomSource rand;
                    if (((Boolean)DPConfig.COMMON.husksDropSand.get()).booleanValue()) {
                        EntityAccessHelper.setDeathLootTable((Mob)e, (ResourceLocation)DPLoot.Leviathan.ENTITY_HUSK);
                    }
                    if ((double)(rand = e.m_217043_()).m_188501_() < (Double)DPConfig.COMMON.huskLeviathanBladeChance.get()) {
                        ItemStack stack = ((Item)DPItems.LEVIATHAN_BLADE.get()).m_7968_();
                        stack.m_41721_(rand.m_188503_(stack.m_41720_().getMaxDamage(stack)));
                        e.m_8061_(EquipmentSlot.MAINHAND, stack);
                        e.m_21409_(EquipmentSlot.MAINHAND, 0.12f);
                    }
                });
                ForgeBus.ifInStructure(levelAccessor, (Entity)entity, EntityType.f_20481_, DPStructures.SNOWY_TEMPLE, e -> {
                    RandomSource rand;
                    if (((Boolean)DPConfig.COMMON.straysDropIce.get()).booleanValue()) {
                        EntityAccessHelper.setDeathLootTable((Mob)e, (ResourceLocation)DPLoot.SnowyTemple.ENTITY_STRAY);
                    }
                    if ((double)(rand = e.m_217043_()).m_188501_() < (Double)DPConfig.COMMON.strayFrostedCowlChance.get()) {
                        ItemStack stack = ((Item)DPItems.FROSTED_COWL.get()).m_7968_();
                        stack.m_41721_(rand.m_188503_(stack.m_41720_().getMaxDamage(stack)));
                        e.m_8061_(EquipmentSlot.HEAD, stack);
                        e.m_21409_(EquipmentSlot.HEAD, 0.12f);
                    }
                });
                ForgeBus.ifInStructure(levelAccessor, (Entity)entity, EntityType.f_20562_, DPStructures.WARPED_GARDEN, e -> {
                    Optional opTag;
                    RandomSource rand = e.m_217043_();
                    if ((double)rand.m_188501_() < (Double)DPConfig.COMMON.drownedWarpedAxeChance.get()) {
                        ItemStack stack = ((Item)DPItems.WARPED_AXE.get()).m_7968_();
                        stack.m_41721_(rand.m_188503_(stack.m_41720_().getMaxDamage(stack)));
                        e.m_8061_(EquipmentSlot.MAINHAND, stack);
                        e.m_21409_(EquipmentSlot.MAINHAND, 0.12f);
                    }
                    if ((double)rand.m_188501_() < (Double)DPConfig.COMMON.drownedCoralChance.get() && (opTag = level.m_5962_().m_175515_(Registry.f_122901_).m_203431_(BlockTags.f_13051_)).isPresent() && ((HolderSet.Named)opTag.get()).m_203632_() > 0) {
                        e.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)((Holder)((HolderSet.Named)opTag.get()).m_213653_(rand).get()).m_203334_()));
                        e.m_21409_(EquipmentSlot.OFFHAND, 1.0f);
                    }
                });
                ForgeBus.ifInStructure(levelAccessor, (Entity)entity, EntityType.f_20524_, DPStructures.SOUL_PRISON, e -> {
                    RandomSource rand = e.m_217043_();
                    if ((double)rand.m_188501_() < (Double)DPConfig.COMMON.skeletonSoulCannonChance.get()) {
                        ItemStack stack = ((Item)DPItems.SOUL_CANNON.get()).m_7968_();
                        stack.m_41721_(rand.m_188503_(stack.m_41720_().getMaxDamage(stack)));
                        e.m_8061_(EquipmentSlot.OFFHAND, stack);
                        e.m_21409_(EquipmentSlot.OFFHAND, 0.3f);
                    }
                });
                ForgeBus.ifInStructure(levelAccessor, (Entity)entity, EntityType.f_20453_, DPStructures.SOUL_PRISON, e -> e.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)e, Player.class, true, false)));
                ForgeBus.ifInStructure(levelAccessor, (Entity)entity, EntityType.f_20566_, DPStructures.END_RUINS, e -> e.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)e, Player.class, true, false)));
            }
        }

        private static <T extends Entity> void ifInStructure(ServerLevelAccessor levelAccessor, Entity entity, EntityType<T> entityTest, StructureRegistrar<?> structure, Consumer<T> consumer) {
            if (entity.m_6095_().equals(entityTest) && StructureAccessHelper.isInStructurePiece((ServerLevelAccessor)levelAccessor, (StructureType)structure.getType(), (BlockPos)entity.m_20183_())) {
                consumer.accept(entity);
            }
        }

        @SubscribeEvent
        protected static void onEffectApply(MobEffectEvent.Applicable event) {
            if (event.getEffectInstance().m_19544_() == MobEffects.f_19597_) {
                ArrayList<ItemStack> strayArmors = new ArrayList<ItemStack>(1);
                LivingEntity entity = event.getEntity();
                for (ItemStack stack : entity.m_6168_()) {
                    ArmorItem armor;
                    Item item = stack.m_41720_();
                    if (!(item instanceof ArmorItem) || (armor = (ArmorItem)item).m_40401_() != DPItems.DPArmors.STRAY) continue;
                    strayArmors.add(stack);
                }
                int size = strayArmors.size();
                if (size > 0) {
                    event.setResult(Event.Result.DENY);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        RandomSource rand = serverPlayer.m_217043_();
                        ((ItemStack)strayArmors.get(rand.m_188503_(size))).m_220157_(2, rand, serverPlayer);
                    }
                }
            }
        }
    }
}

