/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.dungeons_plus.events;

import com.legacy.dungeons_plus.client.DPBlockLayers;
import com.legacy.dungeons_plus.client.renderers.SoulFireballRenderer;
import com.legacy.dungeons_plus.client.renderers.WarpedAxeRenderer;
import com.legacy.dungeons_plus.items.CustomHandRendererSupplier;
import com.legacy.dungeons_plus.registry.DPEntityTypes;
import com.legacy.dungeons_plus.registry.DPItems;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class DPClientEvents {

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        protected static void clientInit(FMLClientSetupEvent event) {
            DPBlockLayers.init();
        }

        @SubscribeEvent
        protected static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)DPEntityTypes.SOUL_FIREBALL.get(), SoulFireballRenderer::new);
            event.registerEntityRenderer((EntityType)DPEntityTypes.WARPED_AXE.get(), WarpedAxeRenderer::new);
        }

        @SubscribeEvent
        protected static void initColors(RegisterColorHandlersEvent.Item event) {
            event.register((stack, layer) -> layer > 0 ? -1 : ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack), new ItemLike[]{(ItemLike)DPItems.FROSTED_COWL.get()});
        }
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="dungeons_plus", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBus {
        @SubscribeEvent
        protected static void renderHand(RenderHandEvent event) {
            ItemStack stack = event.getItemStack();
            Item item = stack.m_41720_();
            if (item instanceof CustomHandRendererSupplier) {
                CustomHandRendererSupplier handRenderer = (CustomHandRendererSupplier)item;
                PoseStack poseStack = event.getPoseStack();
                poseStack.m_85836_();
                if (handRenderer.getHandRenderer().renderItem(event, stack, event.getHand())) {
                    event.setCanceled(true);
                }
                poseStack.m_85849_();
            }
        }

        @SubscribeEvent
        protected static void modifyFov(ComputeFovModifierEvent event) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            ItemStack useStack = player.m_21211_();
            if (player.m_6117_() && useStack.m_150930_((Item)DPItems.SOUL_CANNON.get())) {
                float f = event.getNewFovModifier();
                float progress = (float)player.m_21252_() / 20.0f;
                progress = progress > 1.0f ? 1.0f : (progress *= progress);
                event.setNewFovModifier(f *= 1.0f - progress * 0.15f);
            }
        }
    }
}

