/*
 * Decompiled with CFR 0.152.
 */
package dev.limonblaze.oriacs.client.render;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.limonblaze.oriacs.common.Oriacs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;

public class WaterRenderHelper
extends RenderStateShard {
    private static final ResourceLocation WATER_STILL = new ResourceLocation("block/water_still");
    private static final RenderType FLUID = RenderType.m_173215_((String)Oriacs.asResource("fluid").toString(), (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173065_).m_173290_((RenderStateShard.EmptyTextureStateShard)f_110145_).m_110685_(f_110139_).m_110671_(f_110152_).m_110677_(f_110154_).m_110691_(true));

    private WaterRenderHelper() {
        super(null, null, null);
    }

    public static void renderBox(float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, PoseStack ms, MultiBufferSource buffer, int light, int color) {
        TextureAtlasSprite texture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(WATER_STILL);
        color = 0xFF000000 | color;
        VertexConsumer builder = buffer.m_6299_(FLUID);
        ms.m_85836_();
        for (Direction side : Direction.values()) {
            boolean positive;
            boolean bl = positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (side.m_122434_().m_122479_()) {
                if (side.m_122434_() == Direction.Axis.X) {
                    WaterRenderHelper.renderFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, texture);
                    continue;
                }
                WaterRenderHelper.renderFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, texture);
                continue;
            }
            WaterRenderHelper.renderFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, texture);
        }
        ms.m_85849_();
    }

    public static void renderFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        boolean positive = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.m_122434_().m_122479_();
        boolean x = dir.m_122434_() == Direction.Axis.X;
        float shrink = texture.m_118417_() * 0.25f;
        float centerU = texture.m_118409_() + (texture.m_118410_() - texture.m_118409_()) * 0.5f;
        float centerV = texture.m_118411_() + (texture.m_118412_() - texture.m_118411_()) * 0.5f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.m_14143_((float)x1);
            float x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.m_14167_((float)x2);
                u1 = texture.m_118367_((double)((f - x2) * 16.0f));
                u2 = texture.m_118367_((double)((f - x1) * 16.0f));
            } else {
                u1 = texture.m_118367_((double)((x1 - f) * 16.0f));
                u2 = texture.m_118367_((double)((x2 - f) * 16.0f));
            }
            u1 = Mth.m_14179_((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.m_14179_((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.m_14143_((float)y1);
                float y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.m_118393_((double)((y1 - f) * 16.0f));
                    v2 = texture.m_118393_((double)((y2 - f) * 16.0f));
                } else {
                    f = Mth.m_14167_((float)y2);
                    v1 = texture.m_118393_((double)((f - y2) * 16.0f));
                    v2 = texture.m_118393_((double)((f - y1) * 16.0f));
                }
                v1 = Mth.m_14179_((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.m_14179_((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        WaterRenderHelper.vertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        WaterRenderHelper.vertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        WaterRenderHelper.vertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        WaterRenderHelper.vertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        WaterRenderHelper.vertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        WaterRenderHelper.vertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        WaterRenderHelper.vertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        WaterRenderHelper.vertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    WaterRenderHelper.vertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    WaterRenderHelper.vertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    WaterRenderHelper.vertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    WaterRenderHelper.vertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    private static void vertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.m_122436_();
        PoseStack.Pose peek = ms.m_85850_();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_85982_(peek.m_85861_(), x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_85977_(peek.m_85864_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }
}

