/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item.rings;

import com.focamacho.ringsofascension.config.ConfigHolder;
import com.focamacho.ringsofascension.item.ItemRingBase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemRingSponge
extends ItemRingBase {
    public ItemRingSponge(Item.Properties properties, String tooltip) {
        super(properties, tooltip);
    }

    @Override
    public void tickCurio(String identifier, int index, LivingEntity livingEntity) {
        if (!this.isEnabled()) {
            return;
        }
        if (livingEntity.f_19853_.f_46443_ || livingEntity.m_6047_()) {
            return;
        }
        Level world = livingEntity.f_19853_;
        BlockPos entityPos = new BlockPos(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
        int range = 3;
        for (BlockPos pos : BlockPos.m_121976_((int)(entityPos.m_123341_() - range), (int)(entityPos.m_123342_() - range), (int)(entityPos.m_123343_() - range), (int)(entityPos.m_123341_() + range), (int)(entityPos.m_123342_() + range), (int)(entityPos.m_123343_() + range))) {
            BlockState state = livingEntity.f_19853_.m_8055_(pos);
            FluidState fluid = livingEntity.f_19853_.m_6425_(pos);
            Material material = state.m_60767_();
            if (!fluid.m_192917_((Fluid)Fluids.f_76193_) || state.m_60734_() instanceof IFluidBlock && ((IFluidBlock)state.m_60734_()).drain(world, pos, IFluidHandler.FluidAction.EXECUTE) != FluidStack.EMPTY) continue;
            if (state.m_60734_() instanceof LiquidBlock) {
                world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                continue;
            }
            if (material != Material.f_76301_ && material != Material.f_76304_) continue;
            BlockEntity tileentity = state.m_155947_() ? world.m_7702_(pos) : null;
            Block.m_49892_((BlockState)state, (LevelAccessor)world, (BlockPos)pos, (BlockEntity)tileentity);
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    @Override
    public List<ResourceLocation> getLocations() {
        return super.getLocations(ConfigHolder.ringLocationSponge);
    }

    @Override
    public boolean isEnabled() {
        return ConfigHolder.ringSponge;
    }

    @Override
    public int getTier() {
        return ConfigHolder.ringTierSponge;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!this.isEnabled()) {
            return;
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

