/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.ringsofascension.item.rings;

import com.focamacho.ringsofascension.config.ConfigHolder;
import com.focamacho.ringsofascension.item.ItemRingBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;

public class ItemRingGrowth
extends ItemRingBase {
    private int timer = 200;

    public ItemRingGrowth(Item.Properties properties, String tooltip) {
        super(properties, tooltip);
    }

    @Override
    public void tickCurio(String identifier, int index, LivingEntity livingEntity) {
        if (!this.isEnabled()) {
            return;
        }
        if (!(livingEntity instanceof Player)) {
            return;
        }
        if (this.timer <= 0) {
            this.timer = 200;
            BlockPos entityPos = new BlockPos(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            int range = 5;
            int limit = 0;
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.m_121976_((int)(entityPos.m_123341_() - range), (int)(entityPos.m_123342_() - range), (int)(entityPos.m_123343_() - range), (int)(entityPos.m_123341_() + range), (int)(entityPos.m_123342_() + range), (int)(entityPos.m_123343_() + range))) {
                Block block = livingEntity.f_19853_.m_8055_(pos).m_60734_();
                if (!(block instanceof CropBlock) && !(block instanceof StemBlock) && !(block instanceof KelpBlock) && !(block instanceof SeagrassBlock)) continue;
                blocks.add(new BlockPos((Vec3i)pos));
            }
            if (blocks.size() >= 1) {
                Random random = new Random();
                while (blocks.size() >= 1 && limit < 3) {
                    BlockPos pos;
                    pos = (BlockPos)blocks.remove(random.nextInt(blocks.size()));
                    BlockState state = livingEntity.f_19853_.m_8055_(pos);
                    if (!BoneMealItem.applyBonemeal((ItemStack)new ItemStack((ItemLike)Items.f_42499_), (Level)livingEntity.f_19853_, (BlockPos)pos, (Player)((Player)livingEntity)) || state == livingEntity.f_19853_.m_8055_(pos)) continue;
                    ++limit;
                    livingEntity.f_19853_.m_46796_(2005, pos, 0);
                }
            }
        } else {
            --this.timer;
        }
    }

    @Override
    public List<ResourceLocation> getLocations() {
        return super.getLocations(ConfigHolder.ringLocationGrowth);
    }

    @Override
    public boolean isEnabled() {
        return ConfigHolder.ringGrowth;
    }

    @Override
    public int getTier() {
        return ConfigHolder.ringTierGrowth;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!this.isEnabled()) {
            return;
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }
}

