/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.util;

import com.github.dragoni7.dreamland.common.blocks.StrippablePillarBlock;
import com.github.dragoni7.dreamland.util.BlockItemSet;
import com.github.dragoni7.dreamland.util.TagCreator;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class WoodSet {
    private String setName;
    private final TagKey<Item> logItemTag;
    private final TagKey<Block> logBlockTag;
    private MaterialColor color;
    private BlockItemSet log;
    private BlockItemSet stripped_log;
    private BlockItemSet wood;
    private BlockItemSet stripped_wood;
    private BlockItemSet plank;
    private BlockItemSet slab;
    private BlockItemSet stairs;
    private BlockItemSet fence;
    private BlockItemSet fence_gate;
    private BlockItemSet door;
    private BlockItemSet trapdoor;
    private BlockItemSet button;
    private BlockItemSet pressure_plate;
    private BlockItemSet ladder;

    public WoodSet(String name, MaterialColor color) {
        this.setName = name;
        this.color = color;
        this.logItemTag = TagCreator.dreamlandItemTag(this.setName + "_logs");
        this.logBlockTag = TagCreator.dreamlandBlockTag(this.setName + "_logs");
        this.register();
    }

    private void register() {
        this.stripped_log = new BlockItemSet(this.setName + "_stripped_log", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60918_(SoundType.f_56736_).m_60978_(2.0f)));
        this.log = new BlockItemSet(this.setName + "_log", () -> new StrippablePillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60978_(2.0f), () -> (Block)this.stripped_log.block().get()));
        this.wood = new BlockItemSet(this.setName + "_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)this.color).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
        this.stripped_wood = new BlockItemSet(this.setName + "_stripped_wood", () -> new RotatedPillarBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)this.color).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
        this.plank = new BlockItemSet(this.setName + "_planks", () -> new Block(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)this.color).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
        this.slab = new BlockItemSet(this.setName + "_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
        this.stairs = new BlockItemSet(this.setName + "_stairs", () -> new StairBlock(() -> ((Block)this.plank.block().get()).m_49966_(), BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_()));
        this.fence = new BlockItemSet(this.setName + "_fence", () -> new FenceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
        this.fence_gate = new BlockItemSet(this.setName + "_fence_gate", () -> new FenceGateBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f)));
        this.door = new BlockItemSet(this.setName + "_door", () -> new DoorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_()));
        this.trapdoor = new BlockItemSet(this.setName + "_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_()));
        this.button = new BlockItemSet(this.setName + "_button", () -> new WoodButtonBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_)));
        this.pressure_plate = new BlockItemSet(this.setName + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)this.color).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56736_)));
        this.ladder = new BlockItemSet(this.setName + "_ladder", () -> new LadderBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60918_(SoundType.f_56736_).m_60913_(2.0f, 3.0f).m_60955_()));
    }

    public String getSetName() {
        return this.setName;
    }

    public TagKey<Item> getlogItemTag() {
        return this.logItemTag;
    }

    public TagKey<Block> getlogBlockTag() {
        return this.logBlockTag;
    }

    public BlockItemSet log() {
        return this.log;
    }

    public BlockItemSet strippedLog() {
        return this.stripped_log;
    }

    public BlockItemSet plank() {
        return this.plank;
    }

    public BlockItemSet slab() {
        return this.slab;
    }

    public BlockItemSet stair() {
        return this.stairs;
    }

    public BlockItemSet fence() {
        return this.fence;
    }

    public BlockItemSet fenceGate() {
        return this.fence_gate;
    }

    public BlockItemSet door() {
        return this.door;
    }

    public BlockItemSet trapDoor() {
        return this.trapdoor;
    }

    public BlockItemSet button() {
        return this.button;
    }

    public BlockItemSet pressurePlate() {
        return this.pressure_plate;
    }

    public BlockItemSet ladder() {
        return this.ladder;
    }

    public BlockItemSet wood() {
        return this.wood;
    }

    public BlockItemSet strippedWood() {
        return this.stripped_wood;
    }
}

