/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.data;

import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandItems;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.github.dragoni7.dreamland.data.BaseLootTableProvider;
import com.github.dragoni7.dreamland.util.WoodSet;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;

public class DreamlandLootTables
extends BaseLootTableProvider {
    public DreamlandLootTables(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    @Override
    protected void addTables() {
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_STONE.block().get(), (Item)DreamlandBlocks.COBBLED_KUNZITE_STONE.item().get(), "kunzite");
        this.basicBlockTable((Block)DreamlandBlocks.COBBLED_KUNZITE_STONE.block().get(), "cobbled_kunzite");
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_BRICKS.block().get(), "kunzite_bricks");
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_BRICK_SLAB.block().get(), "kunzite_brick_slab");
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_BRICK_STAIRS.block().get(), "kunzite_brick_stairs");
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_BRICK_WALL.block().get(), "kunzite_brick_wall");
        this.basicBlockTable((Block)DreamlandBlocks.COBBLED_KUNZITE_SLAB.block().get(), "cobbled_kunzite_slab");
        this.basicBlockTable((Block)DreamlandBlocks.COBBLED_KUNZITE_STAIRS.block().get(), "cobbled_kunzite_stairs");
        this.basicBlockTable((Block)DreamlandBlocks.COBBLED_KUNZITE_WALL.block().get(), "cobbled_kunzite_wall");
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_TILE.block().get(), "kunzite_tile");
        this.basicBlockTable((Block)DreamlandBlocks.CHISELED_KUNZITE.block().get(), "chiseled_kunzite");
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_POINT.block().get(), "kunzite_point");
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_POINT_BLOCK.block().get(), "kunzite_point_block");
        this.basicBlockTable((Block)DreamlandBlocks.KUNZITE_BARS.block().get(), "kunzite_bars");
        this.basicBlockTable((Block)DreamlandBlocks.SMALL_GOLDEN_CAP.block().get(), "small_golden_cap");
        this.basicBlockTable((Block)DreamlandBlocks.GOLDEN_MOSS_BLOCK.block().get(), "golden_moss_block");
        this.basicBlockTable((Block)DreamlandBlocks.GOLDEN_MOSS_CARPET.block().get(), "golden_moss_carpet");
        this.basicBlockTable((Block)DreamlandBlocks.MIDASHROOM.block().get(), "midashroom");
        this.basicBlockTable((Block)DreamlandBlocks.GOLDEN_CAP.block().get(), (Item)DreamlandBlocks.SMALL_GOLDEN_CAP.item().get(), "golden_cap");
        this.shearableVegetationTable((Block)DreamlandBlocks.GOLD_FRONDS.block().get(), "gold_fronds");
        this.silkTouchTable((Block)DreamlandBlocks.GOLD_BEARING_QUARTZITE.block().get(), Items.f_42587_, "gold_bearing_quartzite", 2, 6);
        this.oreTable((Block)DreamlandBlocks.GOLD_CLUSTER.block().get(), Items.f_151053_, "gold_cluster");
        this.delicateBlockTable((Block)DreamlandBlocks.SMALL_GOLD_CLUSTER.block().get(), "small_gold_cluster");
        this.delicateBlockTable((Block)DreamlandBlocks.MEDIUM_GOLD_CLUSTER.block().get(), "medium_gold_cluster");
        this.delicateBlockTable((Block)DreamlandBlocks.LARGE_GOLD_CLUSTER.block().get(), "large_gold_cluster");
        this.oreTable((Block)DreamlandBlocks.KUNZITE_COPPER_ORE.block().get(), Items.f_151051_, "kunzite_copper");
        this.oreTable((Block)DreamlandBlocks.KUNZITE_EMERALD_ORE.block().get(), Items.f_42616_, "kunzite_emerald");
        this.oreTable((Block)DreamlandBlocks.KUNZITE_DIAMOND_ORE.block().get(), Items.f_42415_, "kunzite_diamond");
        this.oreTable((Block)DreamlandBlocks.KUNZITE_IRON_ORE.block().get(), Items.f_151050_, "kunzite_iron");
        this.gemTable((Block)DreamlandBlocks.KUNZITE_LAPIS_ORE.block().get(), Items.f_42534_, "kunzite_lapis");
        this.gemTable((Block)DreamlandBlocks.KUNZITE_REDSTONE_ORE.block().get(), Items.f_42451_, "kunzite_redstone");
        this.basicBlockTable((Block)DreamlandBlocks.BUMBLE_BLOCK.block().get(), "bumble_block");
        this.basicBlockTable((Block)DreamlandBlocks.HIVE_BLOCK.block().get(), "hive_block");
        this.basicBlockTable((Block)DreamlandBlocks.HIVE_GROWTH.block().get(), "hive_growth");
        this.basicBlockTable((Block)DreamlandBlocks.CAVE_SLIME.block().get(), "cave_slime");
        this.basicBlockTable((Block)DreamlandBlocks.HIVE_WEAVER.block().get(), "hive_weaver");
        this.silkTouchTable((Block)DreamlandBlocks.HIVE_JELLY_CLUSTER.block().get(), (Item)DreamlandItems.HIVE_JELLY_ITEM.get(), "hive_jelly_cluster", 2, 3);
        this.silkTouchTable((Block)DreamlandBlocks.HIVE_BLOCK_WITH_JELLY.block().get(), (Item)DreamlandItems.HIVE_JELLY_ITEM.get(), "hive_block_with_jelly", 1, 1);
        this.oreTable((Block)DreamlandBlocks.HIVE_COPPER.block().get(), Items.f_151051_, "hive_copper");
        this.oreTable((Block)DreamlandBlocks.HIVE_DIAMOND.block().get(), Items.f_42415_, "hive_diamond");
        this.oreTable((Block)DreamlandBlocks.HIVE_GOLD.block().get(), Items.f_151053_, "hive_gold");
        this.oreTable((Block)DreamlandBlocks.HIVE_IRON.block().get(), Items.f_151050_, "hive_iron");
        this.gemTable((Block)DreamlandBlocks.HIVE_LAPIS.block().get(), Items.f_42534_, "hive_lapis");
        this.gemTable((Block)DreamlandBlocks.HIVE_REDSTONE.block().get(), Items.f_42451_, "hive_redstone");
        this.basicBlockTable((Block)DreamlandBlocks.DRIED_TAR.block().get(), "dry_tar");
        this.basicBlockTable((Block)DreamlandBlocks.TAR_MUD.block().get(), "tar_mud");
        this.basicBlockTable((Block)DreamlandBlocks.PACKED_TAR_MUD.block().get(), "packed_tar_mud");
        this.basicBlockTable((Block)DreamlandBlocks.TAR_MUD_BRICKS.block().get(), "tar_mud_bricks");
        this.basicBlockTable((Block)DreamlandBlocks.TAR_MUD_BRICK_SLAB.block().get(), "tar_mud_brick_slab");
        this.basicBlockTable((Block)DreamlandBlocks.TAR_MUD_BRICK_STAIRS.block().get(), "tar_mud_brick_stairs");
        this.basicBlockTable((Block)DreamlandBlocks.TAR_MUD_BRICK_WALL.block().get(), "tar_mud_brick_wall");
        this.shearableVegetationTable((Block)DreamlandBlocks.TAR_BARK_LEAVES.block().get(), "tar_bark_leaves");
        this.basicBlockTable((Block)DreamlandBlocks.DROUGHT_SOIL.block().get(), "drought_soil");
        this.basicBlockTable((Block)DreamlandBlocks.TAR_BARK_SAPLING.block().get(), "tar_bark_sapling");
        this.shearableVegetationTable((Block)DreamlandBlocks.TAR_SPROUTS.block().get(), "tar_sprouts");
        this.silkTouchTable((Block)DreamlandBlocks.FOSSILIZED_EGG.block().get(), (Item)DreamlandBlocks.ANCIENT_EGG.item().get(), "fossilized_egg", 1, 1);
        this.basicBlockTable((Block)DreamlandBlocks.OOZE_BLOCK.block().get(), "ooze_block");
        this.basicBlockTable((Block)DreamlandBlocks.MINERAL_DIRT.block().get(), "mineral_dirt");
        this.grassBlockTable((Block)DreamlandBlocks.FLOWERING_GRASS.block().get(), (Item)DreamlandBlocks.MINERAL_DIRT.item().get(), "flowering_grass");
        this.basicBlockTable((Block)DreamlandBlocks.OPALINE_MARIGOLD.block().get(), "opaline_marigold");
        this.shearableVegetationTable((Block)DreamlandBlocks.PINK_CRAB_GRASS.block().get(), "pink_crab_grass");
        this.shearableVegetationTable((Block)DreamlandBlocks.FLOWERING_UNDERGROWTH.block().get(), "flowering_undergrowth");
        this.shearableVegetationTable((Block)DreamlandBlocks.PLUM_BIRCH_LEAVES.block().get(), "plum_birch_leaves");
        this.basicBlockTable((Block)DreamlandBlocks.PLUM_BIRCH_SHRUB.block().get(), "plum_birch_shrub");
        this.basicBlockTable((Block)DreamlandBlocks.PLUM_BIRCH_SAPLING.block().get(), "plum_birch_sapling");
        this.basicBlockTable((Block)DreamlandBlocks.OPAL_DIFFUSER_BLOCK.block().get(), "opal_diffuser");
        this.basicBlockTable((Block)DreamlandBlocks.OPAL_BLOCK.block().get(), "opal_block");
        this.basicBlockTable((Block)DreamlandBlocks.PRECIOUS_OPAL_BLOCK.block().get(), "precious_opal_block");
        this.basicBlockTable((Block)DreamlandBlocks.OPAL_TILE.block().get(), "opal_tile");
        this.basicBlockTable((Block)DreamlandBlocks.OPAL_SLAB.block().get(), "opal_slab");
        this.basicBlockTable((Block)DreamlandBlocks.OPAL_STAIRS.block().get(), "opal_stairs");
        this.basicBlockTable((Block)DreamlandBlocks.OPAL_WALL.block().get(), "opal_wall");
        this.basicBlockTable((Block)DreamlandBlocks.PRECIOUS_OPAL_TILE.block().get(), "precious_opal_tile");
        this.basicBlockTable((Block)DreamlandBlocks.PRECIOUS_OPAL_SLAB.block().get(), "precious_opal_slab");
        this.basicBlockTable((Block)DreamlandBlocks.PRECIOUS_OPAL_STAIRS.block().get(), "precious_opal_stairs");
        this.basicBlockTable((Block)DreamlandBlocks.PRECIOUS_OPAL_WALL.block().get(), "precious_opal_wall");
        this.basicBlockTable((Block)DreamlandBlocks.JEWELED_DEEPSLATE.block().get(), "jeweled_deepslate");
        this.silkTouchTable((Block)DreamlandBlocks.OPAL_CLUSTER.block().get(), (Item)DreamlandItems.OPAL.get(), "opal_cluster", 1, 3);
        this.delicateBlockTable((Block)DreamlandBlocks.PRECIOUS_OPAL_LAMP.block().get(), "precious_opal_lamp");
        this.basicBlockTable((Block)DreamlandBlocks.WHITE_MOLD.block().get(), "white_mold");
        this.basicBlockTable((Block)DreamlandBlocks.WHITE_MOLD_CARPET.block().get(), "white_mold_carpet");
        this.basicBlockTable((Block)DreamlandBlocks.POROUS_STONE.block().get(), "porous_stone");
        this.basicBlockTable((Block)DreamlandBlocks.OVERGROWN_POROUS_STONE.block().get(), "overgrown_porous_stone");
        this.basicBlockTable((Block)DreamlandBlocks.PETRIFIED_VEGETATION.block().get(), "strand_stone");
        this.basicBlockTable((Block)DreamlandBlocks.PURE_STONE.block().get(), "toxic_stone");
        this.basicBlockTable((Block)DreamlandBlocks.BLACK_MOLD.block().get(), "black_mold");
        this.basicBlockTable((Block)DreamlandBlocks.BLACK_MOLD_CARPET.block().get(), "black_mold");
        this.basicBlockTable((Block)DreamlandBlocks.TOXIC_VEGETATION.block().get(), "toxic_vegetation");
        this.basicBlockTable((Block)DreamlandBlocks.DECAYED_VEGETATION.block().get(), "decayed_vegetation");
        this.basicBlockTable((Block)DreamlandBlocks.GLOWING_MOLD_WOOD.block().get(), "glowing_mold_wood");
        this.basicBlockTable((Block)DreamlandBlocks.SPORE_NODE.block().get(), "spore_node");
        this.grassBlockTable((Block)DreamlandBlocks.TOXIC_GRASS.block().get(), (Item)DreamlandBlocks.TOXIC_DIRT.item().get(), "toxic_grass");
        this.basicBlockTable((Block)DreamlandBlocks.TOXIC_DIRT.block().get(), "toxic_dirt");
        this.basicBlockTable((Block)DreamlandBlocks.PURIFIED_DUST.block().get(), "purified_dust");
        this.oreTable((Block)DreamlandBlocks.NECRATHENE_ORE.block().get(), (Item)DreamlandItems.RAW_NECRATHENE.get(), "necrathene_ore");
        this.oreTable((Block)DreamlandBlocks.PURITY_ORE.block().get(), (Item)DreamlandItems.CRYSTALIZED_PURITY.get(), "purity_ore");
        this.shearableVegetationTable((Block)DreamlandBlocks.SPORE_PUFF.block().get(), "spore_puff");
        this.shearableVegetationTable((Block)DreamlandBlocks.LARGE_SPORE_PUFF.block().get(), "large_spore_puff");
        this.shearableVegetationTable((Block)DreamlandBlocks.SPONGE_PUFF.block().get(), "sponge_puff");
        this.shearableVegetationTable((Block)DreamlandBlocks.SHELF_VEGETATION.block().get(), "shelf_vegetation");
        this.shearableVegetationTable((Block)DreamlandBlocks.GLOW_FRONDS.block().get(), "glow_fronds");
        this.createWoodSetTable(DreamlandWoodSets.TAR_BARK);
        this.createWoodSetTable(DreamlandWoodSets.PLUM_BIRCH);
        this.createWoodSetTable(DreamlandWoodSets.MOLD_WOOD);
    }

    private void createWoodSetTable(WoodSet set) {
        String name = set.getSetName();
        this.basicBlockTable((Block)set.button().block().get(), name + "_button");
        this.basicBlockTable((Block)set.fence().block().get(), name + "_fence");
        this.basicBlockTable((Block)set.fenceGate().block().get(), name + "_fence_gate");
        this.basicBlockTable((Block)set.ladder().block().get(), name + "_ladder");
        this.basicBlockTable((Block)set.log().block().get(), name + "_log");
        this.basicBlockTable((Block)set.plank().block().get(), name + "_planks");
        this.basicBlockTable((Block)set.pressurePlate().block().get(), name + "_pressure_plate");
        this.basicBlockTable((Block)set.slab().block().get(), name + "_slab");
        this.basicBlockTable((Block)set.stair().block().get(), name + "_stair");
        this.basicBlockTable((Block)set.strippedLog().block().get(), "stripped_" + name + "_log");
        this.basicBlockTable((Block)set.trapDoor().block().get(), name + "_trap_door");
        this.basicBlockTable((Block)set.wood().block().get(), name + "_wood");
        this.basicBlockTable((Block)set.strippedWood().block().get(), "stripped_" + name + "_wood");
    }

    private void basicBlockTable(Block block, String name) {
        this.lootTables.put(block, this.createSimpleBlockTable(name, block));
    }

    private void basicBlockTable(Block block1, Block block2, String name) {
        this.lootTables.put(block1, this.createSimpleBlockTable(name, block2));
    }

    private void basicBlockTable(Block block, Item item, String name) {
        this.lootTables.put(block, this.createSimpleItemTable(name, item));
    }

    private void delicateBlockTable(Block block, String name) {
        this.lootTables.put(block, this.createDelicateBlockTable(name, block));
    }

    private void oreTable(Block block, Item item, String name) {
        this.lootTables.put(block, this.createSilkTouchTable(name, block, item, 1.0f, 1.0f));
    }

    private void gemTable(Block block, Item item, String name) {
        this.lootTables.put(block, this.createSilkTouchTable(name, block, item, 4.0f, 9.0f));
    }

    private void silkTouchTable(Block block, Item item, String name, int min, int max) {
        this.lootTables.put(block, this.createSilkTouchTable(name, block, item, min, max));
    }

    private void grassBlockTable(Block block, Item item, String name) {
        this.lootTables.put(block, this.createGrassBlockTable(name, block, item));
    }

    private void shearableVegetationTable(Block block, String name) {
        this.lootTables.put(block, this.createShearableVegetationBlockTable(name, block));
    }
}

