/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.data;

import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandItems;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.github.dragoni7.dreamland.util.DreamlandLoc;
import com.github.dragoni7.dreamland.util.WoodSet;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class DreamlandItemModels
extends ItemModelProvider {
    public DreamlandItemModels(DataGenerator generator, String modid, ExistingFileHelper existingFileHelper) {
        super(generator, modid, existingFileHelper);
    }

    protected void registerModels() {
        this.blockItemModel(DreamlandBlocks.KUNZITE_STONE.item(), "block/kunzite");
        this.blockItemModel(DreamlandBlocks.COBBLED_KUNZITE_STONE.item(), "block/cobbled_kunzite_stone");
        this.blockItemModel(DreamlandBlocks.KUNZITE_TILE.item(), "block/kunzite_tile");
        this.blockItemModel(DreamlandBlocks.CHISELED_KUNZITE.item(), "block/chiseled_kunzite");
        this.blockItemModel(DreamlandBlocks.KUNZITE_BRICKS.item(), "block/kunzite_bricks");
        this.blockItemModel(DreamlandBlocks.KUNZITE_BRICK_SLAB.item(), "block/kunzite_brick_slab");
        this.blockItemModel(DreamlandBlocks.KUNZITE_BRICK_STAIRS.item(), "block/kunzite_brick_stairs");
        this.wallInventory("kunzite_brick_wall", DreamlandLoc.createLoc("block/kunzite_bricks"));
        this.blockItemModel(DreamlandBlocks.COBBLED_KUNZITE_SLAB.item(), "block/cobbled_kunzite_slab");
        this.blockItemModel(DreamlandBlocks.COBBLED_KUNZITE_STAIRS.item(), "block/cobbled_kunzite_stairs");
        this.wallInventory("cobbled_kunzite_wall", DreamlandLoc.createLoc("block/cobbled_kunzite_stone"));
        this.blockItemModel(DreamlandBlocks.KUNZITE_POINT_BLOCK.item(), "block/kunzite_point_block");
        this.blockItemModel(DreamlandBlocks.KUNZITE_COPPER_ORE.item(), "block/kunzite_copper_ore");
        this.blockItemModel(DreamlandBlocks.KUNZITE_IRON_ORE.item(), "block/kunzite_iron_ore");
        this.blockItemModel(DreamlandBlocks.KUNZITE_LAPIS_ORE.item(), "block/kunzite_lapis_ore");
        this.blockItemModel(DreamlandBlocks.KUNZITE_REDSTONE_ORE.item(), "block/kunzite_redstone_ore");
        this.blockItemModel(DreamlandBlocks.KUNZITE_EMERALD_ORE.item(), "block/kunzite_emerald_ore");
        this.blockItemModel(DreamlandBlocks.KUNZITE_DIAMOND_ORE.item(), "block/kunzite_diamond_ore");
        this.blockItemModel(DreamlandBlocks.GOLD_BEARING_QUARTZITE.item(), "block/gold_bearing_quartzite");
        this.blockItemModel(DreamlandBlocks.BUDDING_GOLD.item(), "block/budding_gold");
        this.blockItemModel(DreamlandBlocks.GOLDEN_MOSS_BLOCK.item(), "block/golden_moss_block");
        this.blockItemModel(DreamlandBlocks.GOLDEN_MOSS_CARPET.item(), "block/golden_moss_carpet");
        this.blockItemModel(DreamlandBlocks.HIVE_BLOCK.item(), "block/hive_block1");
        this.blockItemModel(DreamlandBlocks.HIVE_JELLY_CLUSTER.item(), "block/jelly_cluster_item");
        this.blockItemModel(DreamlandBlocks.HIVE_MEMBRANE.item(), "block/hive_membrane_connected");
        this.blockItemModel(DreamlandBlocks.HIVE_WEAVER.item(), "block/hive_weaver");
        this.blockItemModel(DreamlandBlocks.HIVE_IRON.item(), "block/hive_iron");
        this.blockItemModel(DreamlandBlocks.HIVE_COPPER.item(), "block/hive_copper");
        this.blockItemModel(DreamlandBlocks.HIVE_GOLD.item(), "block/hive_gold");
        this.blockItemModel(DreamlandBlocks.HIVE_REDSTONE.item(), "block/hive_redstone");
        this.blockItemModel(DreamlandBlocks.HIVE_LAPIS.item(), "block/hive_lapis");
        this.blockItemModel(DreamlandBlocks.HIVE_DIAMOND.item(), "block/hive_diamond");
        this.blockItemModel(DreamlandBlocks.HIVE_BLOCK_WITH_JELLY.item(), "block/hive_block_with_jelly");
        this.blockItemModel(DreamlandBlocks.DRIED_TAR.item(), "block/dried_tar");
        this.blockItemModel(DreamlandBlocks.TAR_MUD.item(), "block/tar_mud");
        this.blockItemModel(DreamlandBlocks.PACKED_TAR_MUD.item(), "block/packed_tar_mud");
        this.blockItemModel(DreamlandBlocks.TAR_MUD_BRICKS.item(), "block/tar_mud_bricks");
        this.blockItemModel(DreamlandBlocks.TAR_MUD_BRICK_SLAB.item(), "block/tar_mud_brick_slab");
        this.blockItemModel(DreamlandBlocks.TAR_MUD_BRICK_STAIRS.item(), "block/tar_mud_brick_stairs");
        this.blockItemModel(DreamlandBlocks.FOSSILIZED_EGG.item(), "block/fossilized_egg");
        this.wallInventory("tar_mud_brick_wall", DreamlandLoc.createLoc("block/tar_mud_bricks"));
        this.blockItemModel(DreamlandBlocks.DROUGHT_SOIL.item(), "block/drought_soil");
        this.blockItemModel(DreamlandBlocks.TAR_BARK_LEAVES.item(), "block/tar_bark_leaves1");
        this.blockItemModel(DreamlandBlocks.PLUM_BIRCH_LEAVES.item(), "block/plum_birch_leaves1");
        this.blockItemModel(DreamlandBlocks.MINERAL_DIRT.item(), "block/mineral_dirt");
        this.blockItemModel(DreamlandBlocks.FLOWERING_GRASS.item(), "block/flowering_grass");
        this.blockItemModel(DreamlandBlocks.FLOWERING_UNDERGROWTH.item(), "block/flowering_undergrowth");
        this.blockItemModel(DreamlandBlocks.PLUM_BIRCH_SHRUB.item(), "block/plum_birch_shrub");
        this.blockItemModel(DreamlandBlocks.OPAL_DIFFUSER_BLOCK.item(), "block/opal_diffuser");
        this.blockItemModel(DreamlandBlocks.OPAL_CLUSTER.item(), "block/opal_cluster");
        this.blockItemModel(DreamlandBlocks.OPAL_BLOCK.item(), "block/opal_block");
        this.blockItemModel(DreamlandBlocks.PRECIOUS_OPAL_BLOCK.item(), "block/precious_opal_block");
        this.blockItemModel(DreamlandBlocks.OPAL_TILE.item(), "block/opal_tile");
        this.blockItemModel(DreamlandBlocks.PRECIOUS_OPAL_TILE.item(), "block/precious_opal_tile");
        this.blockItemModel(DreamlandBlocks.OPAL_SLAB.item(), "block/opal_slab");
        this.blockItemModel(DreamlandBlocks.OPAL_STAIRS.item(), "block/opal_stairs");
        this.wallInventory("opal_wall", DreamlandLoc.createLoc("block/opal_tile"));
        this.blockItemModel(DreamlandBlocks.PRECIOUS_OPAL_LAMP.item(), "block/precious_opal_lamp");
        this.blockItemModel(DreamlandBlocks.PRECIOUS_OPAL_SLAB.item(), "block/precious_opal_slab");
        this.blockItemModel(DreamlandBlocks.PRECIOUS_OPAL_STAIRS.item(), "block/precious_opal_stairs");
        this.wallInventory("precious_opal_wall", DreamlandLoc.createLoc("block/precious_opal_tile"));
        this.blockItemModel(DreamlandBlocks.JEWELED_DEEPSLATE.item(), "block/jeweled_deepslate");
        this.blockItemModel(DreamlandBlocks.WHITE_MOLD.item(), "block/white_mold_1");
        this.blockItemModel(DreamlandBlocks.BLACK_MOLD.item(), "block/black_mold_1");
        this.blockItemModel(DreamlandBlocks.PURE_STONE.item(), "block/pure_stone");
        this.blockItemModel(DreamlandBlocks.POROUS_STONE.item(), "block/porous_stone");
        this.blockItemModel(DreamlandBlocks.OVERGROWN_POROUS_STONE.item(), "block/overgrown_porous_stone");
        this.blockItemModel(DreamlandBlocks.PETRIFIED_VEGETATION.item(), "block/petrified_vegetation");
        this.blockItemModel(DreamlandBlocks.TOXIC_DIRT.item(), "block/toxic_dirt");
        this.blockItemModel(DreamlandBlocks.TOXIC_VEGETATION.item(), "block/toxic_vegetation");
        this.blockItemModel(DreamlandBlocks.DECAYED_VEGETATION.item(), "block/decayed_vegetation");
        this.blockItemModel(DreamlandBlocks.GLOWING_MOLD_WOOD.item(), "block/glowing_mold_wood");
        this.blockItemModel(DreamlandBlocks.SPORE_NODE.item(), "block/spore_node_down");
        this.blockItemModel(DreamlandBlocks.NECRATHENE_ORE.item(), "block/necrathene_ore");
        this.blockItemModel(DreamlandBlocks.PURITY_ORE.item(), "block/purity_ore");
        this.singleTextureItemModel(DreamlandBlocks.SPORE_PUFF.item(), "block/spore_puff");
        this.singleTextureItemModel(DreamlandBlocks.LARGE_SPORE_PUFF.item(), "item/large_spore_puff");
        this.singleTextureItemModel(DreamlandBlocks.SPONGE_PUFF.item(), "block/sponge_puff");
        this.singleTextureItemModel(DreamlandBlocks.SHELF_VEGETATION.item(), "item/shelf_vegetation");
        this.singleTextureItemModel(DreamlandBlocks.LARGE_GOLD_CLUSTER.item(), "item/large_spore_puff");
        this.singleTextureItemModel(DreamlandBlocks.GLOW_FRONDS.item(), "block/glow_fronds");
        this.singleTextureItemModel(DreamlandItems.RAW_NECRATHENE, "item/raw_necrathene");
        this.singleTextureItemModel(DreamlandItems.NECRATHENE_INGOT, "item/necrathene_ingot");
        this.singleTextureItemModel(DreamlandItems.CRYSTALIZED_PURITY, "item/crystalized_purity");
        this.singleTextureItemModel(DreamlandItems.BREATHER_HELMET, "item/breather_helmet");
        this.singleTextureItemModel(DreamlandItems.NECRATHENE_BREATHER_HELMET, "item/necrathene_breather_helmet");
        this.singleTextureItemModel(DreamlandItems.NECRATHENE_BOOTS, "item/necrathene_boots");
        this.singleTextureItemModel(DreamlandItems.NECRATHENE_CHESTPLATE, "item/necrathene_chestplate");
        this.singleTextureItemModel(DreamlandItems.NECRATHENE_LEGGINGS, "item/necrathene_leggings");
        this.singleTextureItemModel(DreamlandBlocks.GOLD_FRONDS.item(), "block/gold_fronds");
        this.singleTextureItemModel(DreamlandBlocks.KUNZITE_POINT.item(), "block/kunzite_point_end");
        this.singleTextureItemModel(DreamlandBlocks.GOLD_CLUSTER.item(), "block/gold_cluster");
        this.singleTextureItemModel(DreamlandBlocks.MIDASHROOM.item(), "item/midashroom_item");
        this.singleTextureItemModel(DreamlandBlocks.SMALL_GOLD_CLUSTER.item(), "block/small_gold_cluster");
        this.singleTextureItemModel(DreamlandBlocks.MEDIUM_GOLD_CLUSTER.item(), "block/medium_gold_cluster");
        this.singleTextureItemModel(DreamlandBlocks.LARGE_GOLD_CLUSTER.item(), "block/large_gold_cluster");
        this.singleTextureItemModel(DreamlandBlocks.KUNZITE_BARS.item(), "block/kunzite_bars");
        this.singleTextureItemModel(DreamlandItems.GOLDEN_FLOUR, "item/golden_flour");
        this.singleTextureItemModel(DreamlandItems.GOLDEN_ROLL, "item/golden_roll");
        this.singleTextureItemModel(DreamlandItems.HIVE_JELLY_ITEM, "item/hive_jelly");
        this.singleTextureItemModel(DreamlandItems.JELLY_BOWL_ITEM, "item/bowl_of_jelly");
        this.singleTextureItemModel(DreamlandBlocks.CAVE_SLIME.item(), "block/cave_slime");
        this.singleTextureItemModel(DreamlandBlocks.HIVE_GROWTH.item(), "block/hive_growth_cross");
        this.singleTextureItemModel(DreamlandItems.LARVA_HELMET, "item/larva_symbiote_helmet");
        this.singleTextureItemModel(DreamlandBlocks.TAR_SPROUTS.item(), "block/tar_sprouts");
        this.singleTextureItemModel(DreamlandBlocks.TAR_BARK_SAPLING.item(), "item/tar_bark_sapling");
        this.singleTextureItemModel(DreamlandBlocks.ANCIENT_EGG.item(), "item/ancient_egg");
        this.singleTextureItemModel(DreamlandItems.TAR_BUCKET, "item/tar_bucket");
        this.singleTextureItemModel(DreamlandItems.OOZE_BALL, "item/ooze_ball");
        this.singleTextureItemModel(DreamlandItems.CANDIED_OOZE, "item/candied_ooze");
        this.singleTextureItemModel(DreamlandItems.OOZE_PIE, "item/ooze_pie");
        this.singleTextureItemModel(DreamlandBlocks.OPALINE_MARIGOLD.item(), "block/opaline_marigold");
        this.singleTextureItemModel(DreamlandBlocks.PINK_CRAB_GRASS.item(), "block/pink_crab_grass");
        this.singleTextureItemModel(DreamlandBlocks.PLUM_BIRCH_SAPLING.item(), "item/plum_birch_sapling");
        this.singleTextureItemModel(DreamlandItems.OPAL, "item/opal");
        this.singleTextureItemModel(DreamlandItems.PRECIOUS_OPAL, "item/precious_opal");
        this.spawnEggItemModel(DreamlandItems.SPAWN_EGG_LARVA);
        this.spawnEggItemModel(DreamlandItems.SPAWN_EGG_OOZE);
        this.spawnEggItemModel(DreamlandItems.SPAWN_EGG_BUMBLE_BEAST);
        this.spawnEggItemModel(DreamlandItems.SPAWN_EGG_OPAL_SHELL);
        this.registerWoodSet(DreamlandWoodSets.PLUM_BIRCH);
        this.registerWoodSet(DreamlandWoodSets.TAR_BARK);
        this.registerWoodSet(DreamlandWoodSets.MOLD_WOOD);
    }

    private void registerWoodSet(WoodSet set) {
        String path = "block/" + set.getSetName();
        this.blockItemModel(set.log().item(), path + "_log");
        this.blockItemModel(set.strippedLog().item(), path + "_stripped_log");
        this.blockItemModel(set.wood().item(), path + "_wood");
        this.blockItemModel(set.strippedWood().item(), path + "_stripped_wood");
        this.blockItemModel(set.plank().item(), path + "_planks");
        this.blockItemModel(set.stair().item(), path + "_stairs");
        this.blockItemModel(set.slab().item(), path + "_slab");
        this.blockItemModel(set.fenceGate().item(), path + "_fence_gate");
        this.fenceInventory(set.getSetName() + "_fence", DreamlandLoc.createLoc(path + "_planks"));
        this.singleTextureItemModel(set.ladder().item(), "block/" + set.getSetName() + "_ladder");
        this.singleTextureItemModel(set.door().item(), "item/" + set.getSetName() + "_door");
        this.blockItemModel(set.trapDoor().item(), path + "_trapdoor_bottom");
        this.buttonInventory(set.getSetName() + "_button", DreamlandLoc.createLoc(path + "_planks"));
        this.pressurePlate(set.getSetName() + "_pressure_plate", DreamlandLoc.createLoc(path + "_planks"));
    }

    private void singleTextureItemModel(RegistryObject<Item> item, String path) {
        this.singleTexture(item.getId().m_135815_(), new ResourceLocation("item/handheld"), "layer0", DreamlandLoc.createLoc(path));
    }

    private void blockItemModel(RegistryObject<Item> item, String path) {
        this.withExistingParent(item.getId().m_135815_(), DreamlandLoc.createLoc(path));
    }

    private void spawnEggItemModel(RegistryObject<Item> item) {
        this.withExistingParent(item.getId().m_135815_(), "item/template_spawn_egg");
    }
}

