/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.data;

import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.github.dragoni7.dreamland.util.WoodSet;
import java.util.ArrayList;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class DreamlandBlockStates
extends BlockStateProvider {
    public DreamlandBlockStates(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void registerStatesAndModels() {
        ArrayList<Block> simpleBlocks = new ArrayList<Block>();
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_STONE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.COBBLED_KUNZITE_STONE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_BRICKS.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_TILE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.CHISELED_KUNZITE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_COPPER_ORE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_IRON_ORE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_REDSTONE_ORE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_LAPIS_ORE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_EMERALD_ORE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.KUNZITE_DIAMOND_ORE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.GOLD_BEARING_QUARTZITE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.HIVE_IRON.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.HIVE_COPPER.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.HIVE_REDSTONE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.HIVE_GOLD.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.HIVE_LAPIS.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.HIVE_DIAMOND.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.HIVE_BLOCK_WITH_JELLY.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.DRIED_TAR.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.TAR_MUD.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.PACKED_TAR_MUD.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.TAR_MUD_BRICKS.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.DROUGHT_SOIL.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.MINERAL_DIRT.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.OPAL_BLOCK.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.PRECIOUS_OPAL_BLOCK.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.OPAL_TILE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.PRECIOUS_OPAL_TILE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.PRECIOUS_OPAL_LAMP.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.JEWELED_DEEPSLATE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.POROUS_STONE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.OVERGROWN_POROUS_STONE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.PURE_STONE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.PETRIFIED_VEGETATION.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.TOXIC_DIRT.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.TOXIC_VEGETATION.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.DECAYED_VEGETATION.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.GLOWING_MOLD_WOOD.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.NECRATHENE_ORE.block().get());
        simpleBlocks.add((Block)DreamlandBlocks.PURITY_ORE.block().get());
        for (Block element : simpleBlocks) {
            this.simpleBlock(element);
        }
        ResourceLocation fossilizedEggTopTxt = this.modLoc("block/tar_mud");
        ResourceLocation fossilizedEggSideTxt = this.modLoc("block/fossilized_egg");
        this.axisBlock((RotatedPillarBlock)DreamlandBlocks.FOSSILIZED_EGG.block().get(), fossilizedEggSideTxt, fossilizedEggTopTxt);
        ResourceLocation opalTileTxt = this.modLoc("block/opal_tile");
        this.slabBlock((SlabBlock)DreamlandBlocks.OPAL_SLAB.block().get(), opalTileTxt, opalTileTxt, opalTileTxt, opalTileTxt);
        this.stairsBlock((StairBlock)DreamlandBlocks.OPAL_STAIRS.block().get(), opalTileTxt, opalTileTxt, opalTileTxt);
        this.wallBlock((WallBlock)DreamlandBlocks.OPAL_WALL.block().get(), opalTileTxt);
        ResourceLocation preciousOpalTileTxt = this.modLoc("block/precious_opal_tile");
        this.slabBlock((SlabBlock)DreamlandBlocks.PRECIOUS_OPAL_SLAB.block().get(), preciousOpalTileTxt, preciousOpalTileTxt, preciousOpalTileTxt, preciousOpalTileTxt);
        this.stairsBlock((StairBlock)DreamlandBlocks.PRECIOUS_OPAL_STAIRS.block().get(), preciousOpalTileTxt, preciousOpalTileTxt, preciousOpalTileTxt);
        this.wallBlock((WallBlock)DreamlandBlocks.PRECIOUS_OPAL_WALL.block().get(), preciousOpalTileTxt);
        ResourceLocation tarMudBrickTxt = this.modLoc("block/tar_mud_bricks");
        this.slabBlock((SlabBlock)DreamlandBlocks.TAR_MUD_BRICK_SLAB.block().get(), tarMudBrickTxt, tarMudBrickTxt, tarMudBrickTxt, tarMudBrickTxt);
        this.stairsBlock((StairBlock)DreamlandBlocks.TAR_MUD_BRICK_STAIRS.block().get(), tarMudBrickTxt, tarMudBrickTxt, tarMudBrickTxt);
        this.wallBlock((WallBlock)DreamlandBlocks.TAR_MUD_BRICK_WALL.block().get(), tarMudBrickTxt);
        ResourceLocation kunziteBricksTxt = this.modLoc("block/kunzite_bricks");
        this.slabBlock((SlabBlock)DreamlandBlocks.KUNZITE_BRICK_SLAB.block().get(), kunziteBricksTxt, kunziteBricksTxt, kunziteBricksTxt, kunziteBricksTxt);
        this.stairsBlock((StairBlock)DreamlandBlocks.KUNZITE_BRICK_STAIRS.block().get(), kunziteBricksTxt, kunziteBricksTxt, kunziteBricksTxt);
        this.wallBlock((WallBlock)DreamlandBlocks.KUNZITE_BRICK_WALL.block().get(), kunziteBricksTxt);
        ResourceLocation cobbledKunziteTxt = this.modLoc("block/cobbled_kunzite_stone");
        this.slabBlock((SlabBlock)DreamlandBlocks.COBBLED_KUNZITE_SLAB.block().get(), cobbledKunziteTxt, cobbledKunziteTxt, cobbledKunziteTxt, cobbledKunziteTxt);
        this.stairsBlock((StairBlock)DreamlandBlocks.COBBLED_KUNZITE_STAIRS.block().get(), cobbledKunziteTxt, cobbledKunziteTxt, cobbledKunziteTxt);
        this.wallBlock((WallBlock)DreamlandBlocks.COBBLED_KUNZITE_WALL.block().get(), cobbledKunziteTxt);
        ResourceLocation kunzitePointBlockTop = this.modLoc("block/kunzite_point_block_top");
        ResourceLocation kunzitePointBlockSide = this.modLoc("block/kunzite_point_block");
        this.axisBlock((RotatedPillarBlock)DreamlandBlocks.KUNZITE_POINT_BLOCK.block().get(), kunzitePointBlockSide, kunzitePointBlockTop);
        this.registerWoodSet(DreamlandWoodSets.PLUM_BIRCH);
        this.registerWoodSet(DreamlandWoodSets.TAR_BARK);
        this.registerWoodSet(DreamlandWoodSets.MOLD_WOOD);
    }

    private void registerWoodSet(WoodSet set) {
        String setName = set.getSetName();
        ResourceLocation logTop = this.modLoc("block/" + setName + "_log_top");
        ResourceLocation logSide = this.modLoc("block/" + setName + "_log");
        ResourceLocation strippedLogTop = this.modLoc("block/stripped_" + setName + "_log_top");
        ResourceLocation strippedLogSide = this.modLoc("block/stripped_" + setName + "_log");
        ResourceLocation plankTxt = this.modLoc("block/" + setName + "_planks");
        ResourceLocation trapDoorTxt = this.modLoc("block/" + setName + "_trapdoor");
        ResourceLocation doorTop = this.modLoc("block/" + setName + "_door_top");
        ResourceLocation doorBottom = this.modLoc("block/" + setName + "_door_bottom");
        ModelBuilder bottomLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("door/" + setName + "_bottom_left", "block/door_bottom_left")).texture("bottom", doorBottom)).texture("top", doorTop)).renderType("cutout_mipped");
        ModelBuilder bottomLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("door/" + setName + "_bottom_left_open", "block/door_bottom_left_open")).texture("bottom", doorBottom)).texture("top", doorTop)).renderType("cutout_mipped");
        ModelBuilder bottomRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("door/" + setName + "_bottom_right", "block/door_bottom_right")).texture("bottom", doorBottom)).texture("top", doorTop)).renderType("cutout_mipped");
        ModelBuilder bottomRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("door/" + setName + "_bottom_right_open", "block/door_bottom_right_open")).texture("bottom", doorBottom)).texture("top", doorTop)).renderType("cutout_mipped");
        ModelBuilder topLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("door/" + setName + "_top_left", "block/door_top_left")).texture("bottom", doorBottom)).texture("top", doorTop)).renderType("cutout_mipped");
        ModelBuilder topLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("door/" + setName + "_top_left_open", "block/door_top_left_open")).texture("bottom", doorBottom)).texture("top", doorTop)).renderType("cutout_mipped");
        ModelBuilder topRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("door/" + setName + "_top_right", "block/door_top_right")).texture("bottom", doorBottom)).texture("top", doorTop)).renderType("cutout_mipped");
        ModelBuilder topRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("door/" + setName + "_top_right_open", "block/door_top_right_open")).texture("bottom", doorBottom)).texture("top", doorTop)).renderType("cutout_mipped");
        this.axisBlock((RotatedPillarBlock)set.log().block().get(), logSide, logTop);
        this.axisBlock((RotatedPillarBlock)set.strippedLog().block().get(), strippedLogSide, strippedLogTop);
        this.axisBlock((RotatedPillarBlock)set.wood().block().get(), logSide, logSide);
        this.axisBlock((RotatedPillarBlock)set.strippedWood().block().get(), strippedLogSide, strippedLogSide);
        this.simpleBlock((Block)set.plank().block().get());
        this.slabBlock((SlabBlock)set.slab().block().get(), plankTxt, plankTxt, plankTxt, plankTxt);
        this.stairsBlock((StairBlock)set.stair().block().get(), plankTxt, plankTxt, plankTxt);
        this.fenceBlock((FenceBlock)set.fence().block().get(), plankTxt);
        this.fenceGateBlock((FenceGateBlock)set.fenceGate().block().get(), plankTxt);
        this.doorBlock((DoorBlock)set.door().block().get(), (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
        this.trapdoorBlock((TrapDoorBlock)set.trapDoor().block().get(), trapDoorTxt, true);
        this.buttonBlock((ButtonBlock)set.button().block().get(), plankTxt);
        this.pressurePlateBlock((PressurePlateBlock)set.pressurePlate().block().get(), plankTxt);
    }
}

