/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.data;

import com.github.dragoni7.dreamland.Dreamland;
import com.github.dragoni7.dreamland.common.world.biome.BiomeKeys;
import com.github.dragoni7.dreamland.common.world.feature.DreamlandConfiguredFeatures;
import com.github.dragoni7.dreamland.common.world.feature.DreamlandFeaturePlacements;
import com.github.dragoni7.dreamland.data.AddBiomeTags;
import com.github.dragoni7.dreamland.data.AddBlockTags;
import com.github.dragoni7.dreamland.data.AddFluidTags;
import com.github.dragoni7.dreamland.data.AddItemTags;
import com.github.dragoni7.dreamland.data.DreamlandBlockStates;
import com.github.dragoni7.dreamland.data.DreamlandItemModels;
import com.github.dragoni7.dreamland.data.DreamlandLanguageProvider;
import com.github.dragoni7.dreamland.data.DreamlandLootTables;
import com.github.dragoni7.dreamland.data.DreamlandRecipes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        Path outputFolder = generator.m_123916_();
        RegistryAccess.Writable registries = RegistryAccess.m_206197_();
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)registries);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (event.includeServer()) {
            generator.m_236039_(true, (DataProvider)new DreamlandRecipes(generator));
            generator.m_236039_(true, (DataProvider)new DreamlandLootTables(generator));
            BlockTagsProvider blocks = new BlockTagsProvider(generator, "dreamland", fileHelper);
            generator.m_236039_(true, (DataProvider)new AddBlockTags(generator, fileHelper));
            generator.m_236039_(true, (DataProvider)new AddFluidTags(generator, fileHelper));
            generator.m_236039_(true, (DataProvider)new AddItemTags(generator, blocks, fileHelper));
            generator.m_236039_(true, (DataProvider)new AddBiomeTags(generator, fileHelper));
            for (ResourceKey<ConfiguredFeature<?, ?>> resourceKey : DreamlandConfiguredFeatures.getKeys()) {
                generator.m_236039_(true, DataGenerators.makeBuiltinRegistryProvider("dreamland", outputFolder, gson, (RegistryOps<JsonElement>)ops, (RegistryAccess)registries, Registry.f_122881_, ConfiguredFeature.f_65373_, resourceKey));
            }
            for (ResourceKey<ConfiguredFeature<?, ?>> resourceKey : DreamlandFeaturePlacements.getKeys()) {
                generator.m_236039_(true, DataGenerators.makeBuiltinRegistryProvider("dreamland", outputFolder, gson, (RegistryOps<JsonElement>)ops, (RegistryAccess)registries, Registry.f_194567_, PlacedFeature.f_191772_, resourceKey));
            }
            for (ResourceKey<ConfiguredFeature<?, ?>> resourceKey : BiomeKeys.getAllKeys()) {
                generator.m_236039_(true, DataGenerators.makeBuiltinRegistryProvider("dreamland", outputFolder, gson, (RegistryOps<JsonElement>)ops, (RegistryAccess)registries, Registry.f_122885_, Biome.f_47429_, resourceKey));
            }
        }
        if (event.includeClient()) {
            generator.m_236039_(true, (DataProvider)new DreamlandBlockStates(generator, "dreamland", fileHelper));
            generator.m_236039_(true, (DataProvider)new DreamlandItemModels(generator, "dreamland", fileHelper));
            generator.m_236039_(true, (DataProvider)new DreamlandLanguageProvider(generator, "en_us"));
        }
    }

    @SafeVarargs
    private static <T> DataProvider makeBuiltinRegistryProvider(final String modid, final Path outputFolder, Gson gson, final RegistryOps<JsonElement> ops, final RegistryAccess registries, final ResourceKey<Registry<T>> registryKey, final Codec<T> codec, final ResourceKey<T> ... keys) {
        return new DataProvider(){

            public void m_213708_(CachedOutput cache) throws IOException {
                Registry registry = registries.m_175515_(registryKey);
                for (ResourceKey key : keys) {
                    ResourceLocation id = key.m_135782_();
                    Path path = outputFolder.resolve(String.join((CharSequence)"/", PackType.SERVER_DATA.m_10305_(), id.m_135827_(), registryKey.m_135782_().m_135815_(), id.m_135815_() + ".json"));
                    Object t = registry.m_123013_(key);
                    codec.encodeStart((DynamicOps)ops, t).resultOrPartial(msg -> Dreamland.LOGGER.error("Failed to encode {}: {}", (Object)path, msg)).ifPresent(json -> {
                        try {
                            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)path);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
            }

            public String m_6055_() {
                return modid + " " + registryKey.m_135782_().toString();
            }
        };
    }
}

