/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.core.registry;

import com.github.dragoni7.dreamland.Dreamland;
import com.github.dragoni7.dreamland.common.items.BreatherHelmetArmorItem;
import com.github.dragoni7.dreamland.common.items.CrystalizedPurityItem;
import com.github.dragoni7.dreamland.common.items.HiveJellyItem;
import com.github.dragoni7.dreamland.common.items.LarvaSymbioteArmorItem;
import com.github.dragoni7.dreamland.common.items.NecratheneArmorItem;
import com.github.dragoni7.dreamland.core.registry.DreamlandArmorMaterials;
import com.github.dragoni7.dreamland.core.registry.DreamlandEffects;
import com.github.dragoni7.dreamland.core.registry.DreamlandEntities;
import com.github.dragoni7.dreamland.core.registry.DreamlandFluids;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DreamlandItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"dreamland");
    public static final RegistryObject<Item> HIVE_JELLY_ITEM = DreamlandItems.registerHiveJelly("hive_jelly", new FoodProperties.Builder().m_38760_(1).m_38758_(0.2f).m_38767_());
    public static final RegistryObject<Item> JELLY_BOWL_ITEM = ITEMS.register("bowl_of_jelly", () -> new BowlFoodItem(new Item.Properties().m_41487_(1).m_41491_(Dreamland.DreamlandTab).m_41489_(new FoodProperties.Builder().m_38760_(6).m_38758_(0.6f).m_38767_())));
    public static final RegistryObject<Item> TAR_BUCKET = ITEMS.register("tar_bucket", () -> new BucketItem(DreamlandFluids.TAR_FLUID, new Item.Properties().m_41495_(Items.f_42446_).m_41491_(Dreamland.DreamlandTab).m_41487_(1)));
    public static final RegistryObject<Item> OOZE_BALL = DreamlandItems.registerBasicItem("ooze_ball");
    public static final RegistryObject<Item> CANDIED_OOZE = DreamlandItems.registerFoodItem("candied_ooze", new FoodProperties.Builder().m_38760_(2).m_38758_(0.1f).effect(() -> new MobEffectInstance((MobEffect)DreamlandEffects.TARRED.get(), 40), 1.0f).m_38767_());
    public static final RegistryObject<Item> OOZE_PIE = DreamlandItems.registerFoodItem("ooze_pie", new FoodProperties.Builder().m_38760_(8).m_38758_(0.3f).effect(() -> new MobEffectInstance((MobEffect)DreamlandEffects.TARRED.get(), 40), 1.0f).m_38767_());
    public static final RegistryObject<Item> OPAL = DreamlandItems.registerBasicItem("opal");
    public static final RegistryObject<Item> PRECIOUS_OPAL = DreamlandItems.registerBasicItem("precious_opal");
    public static final RegistryObject<Item> GOLDEN_FLOUR = DreamlandItems.registerBasicItem("golden_flour");
    public static final RegistryObject<Item> GOLDEN_ROLL = DreamlandItems.registerFoodItem("golden_roll", new FoodProperties.Builder().m_38760_(6).m_38758_(0.6f).effect(() -> new MobEffectInstance(MobEffects.f_19617_, 100, 0), 1.0f).m_38767_());
    public static final RegistryObject<Item> RAW_NECRATHENE = DreamlandItems.registerBasicItem("raw_necrathene");
    public static final RegistryObject<Item> NECRATHENE_INGOT = DreamlandItems.registerBasicItem("necrathene_ingot");
    public static final RegistryObject<Item> CRYSTALIZED_PURITY = ITEMS.register("crystalized_purity", () -> new CrystalizedPurityItem(new Item.Properties().m_41491_(Dreamland.DreamlandTab)));
    public static final RegistryObject<Item> LARVA_HELMET = ITEMS.register("larva_symbiote", () -> new LarvaSymbioteArmorItem(DreamlandArmorMaterials.LARVA, EquipmentSlot.HEAD, new Item.Properties().m_41497_(Rarity.RARE).m_41491_(Dreamland.DreamlandTab)));
    public static final RegistryObject<Item> BREATHER_HELMET = ITEMS.register("breather_helmet", () -> new BreatherHelmetArmorItem((ArmorMaterial)ArmorMaterials.LEATHER, EquipmentSlot.HEAD, new Item.Properties().m_41491_(Dreamland.DreamlandTab)));
    public static final RegistryObject<Item> NECRATHENE_BREATHER_HELMET = ITEMS.register("necrathene_breather_helmet", () -> new NecratheneArmorItem(DreamlandArmorMaterials.NECRATHENE, EquipmentSlot.HEAD, new Item.Properties().m_41491_(Dreamland.DreamlandTab)));
    public static final RegistryObject<Item> NECRATHENE_CHESTPLATE = ITEMS.register("necrathene_chestplate", () -> new NecratheneArmorItem(DreamlandArmorMaterials.NECRATHENE, EquipmentSlot.CHEST, new Item.Properties().m_41491_(Dreamland.DreamlandTab)));
    public static final RegistryObject<Item> NECRATHENE_LEGGINGS = ITEMS.register("necrathene_leggings", () -> new NecratheneArmorItem(DreamlandArmorMaterials.NECRATHENE, EquipmentSlot.LEGS, new Item.Properties().m_41491_(Dreamland.DreamlandTab)));
    public static final RegistryObject<Item> NECRATHENE_BOOTS = ITEMS.register("necrathene_boots", () -> new NecratheneArmorItem(DreamlandArmorMaterials.NECRATHENE, EquipmentSlot.FEET, new Item.Properties().m_41491_(Dreamland.DreamlandTab)));
    public static final RegistryObject<Item> SPAWN_EGG_LARVA = DreamlandItems.registerSpawnEgg("spawn_egg_larva", () -> (EntityType)DreamlandEntities.LARVA.get(), 11139324, 2893936);
    public static final RegistryObject<Item> SPAWN_EGG_OOZE = DreamlandItems.registerSpawnEgg("spawn_egg_ooze", () -> (EntityType)DreamlandEntities.OOZE.get(), 2499653, 4801927);
    public static final RegistryObject<Item> SPAWN_EGG_OPAL_SHELL = DreamlandItems.registerSpawnEgg("spawn_egg_opal_shell", () -> (EntityType)DreamlandEntities.OPAL_SHELL.get(), 2971996, 0xAD1D1D);
    public static final RegistryObject<Item> SPAWN_EGG_BUMBLE_BEAST = DreamlandItems.registerSpawnEgg("spawn_egg_bumble_beast", () -> (EntityType)DreamlandEntities.BUMBLE_BEAST.get(), 13089058, 2696713);

    private static RegistryObject<Item> registerSpawnEgg(String name, Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor) {
        return ITEMS.register(name, () -> new ForgeSpawnEggItem(type, backgroundColor, highlightColor, new Item.Properties().m_41491_(Dreamland.DreamlandTab)));
    }

    private static RegistryObject<Item> registerBasicItem(String name) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().m_41491_(Dreamland.DreamlandTab)));
    }

    private static RegistryObject<Item> registerFoodItem(String name, FoodProperties foodProperties) {
        return ITEMS.register(name, () -> new Item(new Item.Properties().m_41491_(Dreamland.DreamlandTab).m_41489_(foodProperties)));
    }

    private static RegistryObject<Item> registerHiveJelly(String name, FoodProperties foodProperty) {
        return ITEMS.register(name, () -> new HiveJellyItem(new Item.Properties().m_41491_(Dreamland.DreamlandTab).m_41489_(foodProperty).m_41487_(16)));
    }
}

