/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.core.registry;

import com.github.dragoni7.dreamland.common.blocks.TarLiquidBlock;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandEffects;
import com.github.dragoni7.dreamland.core.registry.DreamlandItems;
import com.github.dragoni7.dreamland.util.DreamlandLoc;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class DreamlandFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"dreamland");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"dreamland");
    public static final RegistryObject<FluidType> TAR_FLUID_TYPE = FLUID_TYPES.register("tar_fluid", () -> new FluidType(FluidType.Properties.create().supportsBoating(false).canPushEntity(false).canExtinguish(false).fallDistanceModifier(0.5f).canHydrate(false).canDrown(true).canSwim(false).density(3000).viscosity(6000).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11780_).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11783_).sound(SoundActions.FLUID_VAPORIZE, SoundEvents.f_12447_).pathType(BlockPathTypes.LAVA)){

        public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
            Vec3 motion = entity.m_20184_();
            if (motion.f_82480_ > 0.0 && entity.m_21023_((MobEffect)DreamlandEffects.TARRED.get())) {
                entity.m_20256_(motion.m_82542_(0.5, 0.7, 0.5));
            } else if (motion.f_82480_ < 0.0) {
                entity.m_20256_(motion.m_82542_(0.5, 0.9, 0.5));
            } else {
                entity.m_20256_(motion.m_82542_(0.5, 1.0, 0.5));
            }
            return false;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){
                private static final ResourceLocation STILL = DreamlandLoc.createLoc("block/tar_still");
                private static final ResourceLocation FLOW = DreamlandLoc.createLoc("block/tar_flow");
                private static final ResourceLocation OVERLAY = DreamlandLoc.createLoc("block/tar");

                public ResourceLocation getStillTexture() {
                    return STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return FLOW;
                }

                public ResourceLocation getOverlayTexture() {
                    return OVERLAY;
                }
            });
        }
    });
    public static final RegistryObject<FlowingFluid> TAR_FLUID = FLUIDS.register("tar_fluid", () -> new ForgeFlowingFluid.Source(DreamlandFluids.tarFluidProperties()));
    public static final RegistryObject<Fluid> TAR_FLOWING = FLUIDS.register("tar_flowing", () -> new ForgeFlowingFluid.Flowing(DreamlandFluids.tarFluidProperties()));
    public static final RegistryObject<LiquidBlock> TAR_BLOCK = DreamlandBlocks.BLOCKS.register("tar", () -> new TarLiquidBlock(() -> (FlowingFluid)TAR_FLUID.get(), BlockBehaviour.Properties.m_60939_((Material)Material.f_76307_).m_60910_().m_60978_(100.0f).m_222994_()));

    private static ForgeFlowingFluid.Properties tarFluidProperties() {
        return new ForgeFlowingFluid.Properties(TAR_FLUID_TYPE, TAR_FLUID, TAR_FLOWING).block(TAR_BLOCK).bucket(DreamlandItems.TAR_BUCKET);
    }
}

