/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.core.registry;

import com.github.dragoni7.dreamland.core.registry.DreamlandItems;
import com.github.dragoni7.dreamland.core.registry.DreamlandSoundEvents;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum DreamlandArmorMaterials implements ArmorMaterial
{
    LARVA("larva", 33, new int[]{3, 6, 8, 3}, 12, (SoundEvent)DreamlandSoundEvents.LARVA_HIT.get(), 0.5f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamlandItems.HIVE_JELLY_ITEM.get()})),
    NECRATHENE("necrathene", 39, new int[]{4, 6, 8, 3}, 15, SoundEvents.f_11679_, 2.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)DreamlandItems.NECRATHENE_INGOT.get()}));

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private DreamlandArmorMaterials(String name, int durabilityMult, int[] protectionValues, int enchantValue, SoundEvent equipSound, float toughnessValue, float knockbackResistValue, Supplier<Ingredient> repairItem) {
        this.name = name;
        this.durabilityMultiplier = durabilityMult;
        this.slotProtections = protectionValues;
        this.enchantmentValue = enchantValue;
        this.sound = equipSound;
        this.toughness = toughnessValue;
        this.knockbackResistance = knockbackResistValue;
        this.repairIngredient = new LazyLoadedValue(repairItem);
    }

    public int m_7366_(EquipmentSlot slot) {
        return HEALTH_PER_SLOT[slot.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7365_(EquipmentSlot slot) {
        return this.slotProtections[slot.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

