/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.core.event;

import com.github.dragoni7.dreamland.Config;
import com.github.dragoni7.dreamland.common.entities.mobs.BumbleBeastEntity;
import com.github.dragoni7.dreamland.common.entities.mobs.LarvaEntity;
import com.github.dragoni7.dreamland.common.entities.mobs.OozeEntity;
import com.github.dragoni7.dreamland.common.entities.mobs.OpalShellEntity;
import com.github.dragoni7.dreamland.common.world.biome.BiomeKeys;
import com.github.dragoni7.dreamland.core.registry.DreamlandEffects;
import com.github.dragoni7.dreamland.core.registry.DreamlandEntities;
import com.github.dragoni7.dreamland.core.registry.DreamlandFluids;
import com.github.dragoni7.dreamland.core.registry.DreamlandItems;
import com.github.dragoni7.dreamland.data.DreamlandItemTags;
import com.github.dragoni7.dreamland.network.Networking;
import com.github.dragoni7.dreamland.network.PacketApplyTarred;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;

public class DreamlandEventHandler {
    public static void init(IEventBus modBus, IEventBus forgeBus) {
        modBus.addListener(DreamlandEventHandler::addAttributes);
        forgeBus.addListener(DreamlandEventHandler::updateTarredEffect);
        forgeBus.addListener(DreamlandEventHandler::updateTarredEffectPlayer);
        forgeBus.addListener(DreamlandEventHandler::setLarvaTarget);
        forgeBus.addListener(DreamlandEventHandler::entityHitLarvaSymbiote);
        forgeBus.addListener(DreamlandEventHandler::onLarvaAttacked);
        forgeBus.addListener(DreamlandEventHandler::toxicJunglePreventHeal);
        forgeBus.addListener(DreamlandEventHandler::necratheneArmorDamageReduction);
    }

    public static void addAttributes(EntityAttributeCreationEvent event) {
        SpawnPlacements.m_21754_((EntityType)((EntityType)DreamlandEntities.BUMBLE_BEAST.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BumbleBeastEntity::checkBumbleBeastSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)DreamlandEntities.LARVA.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, LarvaEntity::checkLarvaSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)DreamlandEntities.OOZE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OozeEntity::checkOozeSpawnRules);
        SpawnPlacements.m_21754_((EntityType)((EntityType)DreamlandEntities.OPAL_SHELL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OpalShellEntity::checkOpalShellSpawnRules);
        event.put((EntityType)DreamlandEntities.BUMBLE_BEAST.get(), BumbleBeastEntity.customAttributes().m_22265_());
        event.put((EntityType)DreamlandEntities.LARVA.get(), LarvaEntity.customAttributes().m_22265_());
        event.put((EntityType)DreamlandEntities.OOZE.get(), OozeEntity.customAttributes().m_22265_());
        event.put((EntityType)DreamlandEntities.OPAL_SHELL.get(), OpalShellEntity.customAttributes().m_22265_());
    }

    public static void updateTarredEffect(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.isInFluidType((FluidType)DreamlandFluids.TAR_FLUID_TYPE.get())) {
            Vec3 motion = entity.m_20184_();
            if (motion.f_82479_ != 0.0 || motion.f_82481_ != 0.0) {
                if (entity instanceof Player) {
                    return;
                }
                if (entity.m_6084_() && entity.m_9236_().m_5776_()) {
                    Networking.sendToServer(new PacketApplyTarred(entity.m_19879_()));
                }
            }
        }
    }

    public static void updateTarredEffectPlayer(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player.isInFluidType((FluidType)DreamlandFluids.TAR_FLUID_TYPE.get())) {
            Vec3 motion = player.m_20184_();
            if ((motion.f_82479_ != 0.0 || motion.f_82481_ != 0.0) && event.side.isClient()) {
                Networking.sendToServer(new PacketApplyTarred(player.m_19879_()));
            }
        }
    }

    public static void onLarvaAttacked(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity && target instanceof LarvaEntity && !(attacker instanceof LarvaEntity)) {
            ((LivingEntity)attacker).m_7292_(new MobEffectInstance((MobEffect)DreamlandEffects.ANTAGONIZED.get(), ((Integer)Config.ANTAGONIZED_DURATION.get()).intValue()));
        }
    }

    public static void setLarvaTarget(LivingEvent.LivingTickEvent event) {
        int i = 20;
        if (i == 20) {
            List list;
            LivingEntity entity = event.getEntity();
            BlockPos pos = entity.m_20183_();
            Level level = entity.m_9236_();
            if (!level.f_46443_ && entity != null && entity.m_21023_((MobEffect)DreamlandEffects.ANTAGONIZED.get()) && !(list = level.m_45976_(LarvaEntity.class, new AABB(pos).m_82377_(16.0, 10.0, 16.0))).isEmpty()) {
                for (LarvaEntity larva : list) {
                    larva.m_6710_(entity);
                }
            }
            i = 0;
        }
        ++i;
    }

    public static void entityHitLarvaSymbiote(LivingHurtEvent event) {
        LivingEntity target = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        if (target.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)DreamlandItems.LARVA_HELMET.get()) && attacker instanceof LivingEntity && !(attacker instanceof LarvaEntity)) {
            ((LivingEntity)attacker).m_7292_(new MobEffectInstance((MobEffect)DreamlandEffects.ANTAGONIZED.get(), ((Integer)Config.ANTAGONIZED_DURATION.get()).intValue()));
            Level level = target.f_19853_;
            if (!level.m_5776_()) {
                LarvaEntity larva = (LarvaEntity)((EntityType)DreamlandEntities.LARVA.get()).m_20615_(level);
                if (level.m_45976_(LarvaEntity.class, new AABB(target.m_20183_()).m_82377_(16.0, 10.0, 16.0)).size() <= 3) {
                    larva.m_146884_(target.m_20182_());
                    level.m_7967_((Entity)larva);
                }
            }
        }
    }

    public static void necratheneArmorDamageReduction(LivingHurtEvent event) {
        int foodLevel;
        LivingEntity entity = event.getEntity();
        if (entity.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)DreamlandItems.NECRATHENE_BREATHER_HELMET.get()) && entity.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)DreamlandItems.NECRATHENE_CHESTPLATE.get()) && entity.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)DreamlandItems.NECRATHENE_LEGGINGS.get()) && entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)DreamlandItems.NECRATHENE_BOOTS.get()) && entity.m_21223_() <= event.getAmount() && entity instanceof Player && (foodLevel = ((Player)entity).m_36324_().m_38702_()) > 0) {
            ((Player)entity).m_36399_(20.0f);
            event.setCanceled(true);
        }
    }

    public static void toxicJunglePreventHeal(LivingHealEvent event) {
        ItemStack helmet;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && !(helmet = entity.m_6844_(EquipmentSlot.HEAD).m_41777_()).m_204117_(DreamlandItemTags.PREVENTS_DECAY)) {
            BlockPos pos = entity.m_20183_();
            if (entity.m_9236_().m_204166_(pos).m_203565_(BiomeKeys.TOXIC_JUNGLE) && pos.m_123342_() > 0) {
                entity.m_7292_(new MobEffectInstance((MobEffect)DreamlandEffects.DECAY.get(), 100));
                event.setCanceled(true);
            }
        }
    }
}

