/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.core.event;

import com.github.dragoni7.dreamland.client.particles.GoldGlitterParticle;
import com.github.dragoni7.dreamland.client.particles.MidashroomSporesParticle;
import com.github.dragoni7.dreamland.client.particles.MoldSporesParticle;
import com.github.dragoni7.dreamland.client.particles.TarBubbleParticle;
import com.github.dragoni7.dreamland.client.particles.WhitePollenParticle;
import com.github.dragoni7.dreamland.client.render.AncientEggRender;
import com.github.dragoni7.dreamland.client.render.BreatherHelmetRenderer;
import com.github.dragoni7.dreamland.client.render.BumbleBeastRender;
import com.github.dragoni7.dreamland.client.render.LarvaRender;
import com.github.dragoni7.dreamland.client.render.LarvaSymbioteRenderer;
import com.github.dragoni7.dreamland.client.render.NecratheneArmorRenderer;
import com.github.dragoni7.dreamland.client.render.OozeRender;
import com.github.dragoni7.dreamland.client.render.OpalShellRender;
import com.github.dragoni7.dreamland.client.render.TarBallRender;
import com.github.dragoni7.dreamland.common.items.BreatherHelmetArmorItem;
import com.github.dragoni7.dreamland.common.items.LarvaSymbioteArmorItem;
import com.github.dragoni7.dreamland.common.items.NecratheneArmorItem;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandEntities;
import com.github.dragoni7.dreamland.core.registry.DreamlandFluids;
import com.github.dragoni7.dreamland.core.registry.DreamlandParticles;
import com.github.dragoni7.dreamland.core.registry.DreamlandTiles;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;

public class DreamlandClientEventHandler {
    public static void init(IEventBus modBus) {
        modBus.addListener(DreamlandClientEventHandler::registerEntityRenders);
        modBus.addListener(DreamlandClientEventHandler::registerArmorRenders);
        modBus.addListener(DreamlandClientEventHandler::registerBlockColors);
        modBus.addListener(DreamlandClientEventHandler::setupClient);
        modBus.addListener(DreamlandClientEventHandler::registerParticles);
    }

    private static void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)DreamlandFluids.TAR_FLUID.get()), (RenderType)RenderType.m_110451_());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)DreamlandFluids.TAR_FLOWING.get()), (RenderType)RenderType.m_110451_());
        });
    }

    private static void registerEntityRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)DreamlandEntities.BUMBLE_BEAST.get(), BumbleBeastRender::new);
        event.registerEntityRenderer((EntityType)DreamlandEntities.LARVA.get(), LarvaRender::new);
        event.registerEntityRenderer((EntityType)DreamlandEntities.THROWN_HIVE_JELLY.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)DreamlandEntities.OOZE.get(), OozeRender::new);
        event.registerEntityRenderer((EntityType)DreamlandEntities.OPAL_SHELL.get(), OpalShellRender::new);
        event.registerEntityRenderer((EntityType)DreamlandEntities.TAR_BALL.get(), TarBallRender::new);
        event.registerBlockEntityRenderer((BlockEntityType)DreamlandTiles.ANCIENT_EGG.get(), AncientEggRender::new);
    }

    private static void registerArmorRenders(EntityRenderersEvent.AddLayers event) {
        GeoArmorRenderer.registerArmorRenderer(LarvaSymbioteArmorItem.class, () -> new LarvaSymbioteRenderer());
        GeoArmorRenderer.registerArmorRenderer(BreatherHelmetArmorItem.class, () -> new BreatherHelmetRenderer());
        GeoArmorRenderer.registerArmorRenderer(NecratheneArmorItem.class, () -> new NecratheneArmorRenderer());
    }

    private static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, world, pos, tintIndex) -> world != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)world, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)DreamlandBlocks.TOXIC_GRASS.block().get()});
    }

    private static void registerParticles(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)DreamlandParticles.TAR_BUBBLE.get(), TarBubbleParticle.Provider::new);
        event.register((ParticleType)DreamlandParticles.WHITE_POLLEN.get(), WhitePollenParticle.Provider::new);
        event.register((ParticleType)DreamlandParticles.GOLD_GLITTER.get(), GoldGlitterParticle.Provider::new);
        event.register((ParticleType)DreamlandParticles.MIDASHROOM_SPORES.get(), MidashroomSporesParticle.Provider::new);
        event.register((ParticleType)DreamlandParticles.MOLD_SPORES.get(), MoldSporesParticle.Provider::new);
    }
}

