/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.util.RollBoolean;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class TarSkeleton
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState BONE = Blocks.f_50453_.m_49966_();

    public TarSkeleton(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos blockpos = context.m_159777_();
        RandomSource random = context.m_225041_();
        FeatureBuilder tarSkeletonBuilder = new FeatureBuilder();
        if (RollBoolean.roll(1, random) != false ? !this.createSpineNorth(worldgenlevel, tarSkeletonBuilder, blockpos, random) : !this.createSpineSouth(worldgenlevel, tarSkeletonBuilder, blockpos, random)) {
            return false;
        }
        tarSkeletonBuilder.build(worldgenlevel);
        return true;
    }

    private boolean createSpineNorth(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, RandomSource random) {
        boolean status = true;
        BlockPos pos = blockpos;
        if (RollBoolean.roll(1, random).booleanValue()) {
            pos = blockpos.m_7495_();
        }
        for (int i = 0; i < 3; ++i) {
            for (int xChange = 0; xChange < 3; ++xChange) {
                status = builder.addInput(worldgenlevel, (BlockState)BONE.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z), pos, true);
                pos = pos.m_122012_();
            }
            pos = pos.m_7494_();
            status = builder.addInput(worldgenlevel, BONE, pos.m_122019_(), true);
        }
        if (status) {
            status = this.createRibsNorth(worldgenlevel, builder, pos);
        }
        return status;
    }

    private boolean createSpineSouth(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, RandomSource random) {
        boolean status = true;
        BlockPos pos = blockpos;
        if (RollBoolean.roll(1, random).booleanValue()) {
            pos = blockpos.m_7495_();
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                status = builder.addInput(worldgenlevel, (BlockState)BONE.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X), pos, true);
                pos = pos.m_122019_();
            }
            pos = pos.m_7494_();
            status = builder.addInput(worldgenlevel, BONE, pos.m_122012_(), true);
        }
        if (status) {
            status = this.createRibsSouth(worldgenlevel, builder, pos);
        }
        return status;
    }

    private boolean createRibsNorth(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos) {
        BlockPos pos = blockpos.m_7918_(0, -1, 1);
        boolean status = true;
        int length = 4;
        for (int i = 0; i < 3; ++i) {
            for (int j = 1; j <= 3; ++j) {
                if (j == 3) {
                    for (int k = 1; k <= length; ++k) {
                        status = builder.addInput(worldgenlevel, BONE, pos.m_7918_(j, -k, 0), true);
                        status = builder.addInput(worldgenlevel, BONE, pos.m_7918_(-j, -k, 0), true);
                    }
                    continue;
                }
                status = builder.addInput(worldgenlevel, BONE, pos.m_7918_(j, 0, 0), true);
                status = builder.addInput(worldgenlevel, BONE, pos.m_7918_(-j, 0, 0), true);
            }
            --length;
            pos = pos.m_7918_(0, -1, 3);
        }
        return status;
    }

    private boolean createRibsSouth(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos) {
        BlockPos pos = blockpos.m_7918_(0, -1, -1);
        boolean status = true;
        int length = 3;
        for (int i = 0; i < 3; ++i) {
            for (int j = 1; j <= 3; ++j) {
                if (j == 3) {
                    for (int k = 1; k <= length; ++k) {
                        status = builder.addInput(worldgenlevel, BONE, pos.m_7918_(j, -k, 0), true);
                        status = builder.addInput(worldgenlevel, BONE, pos.m_7918_(-j, -k, 0), true);
                    }
                    continue;
                }
                status = builder.addInput(worldgenlevel, BONE, pos.m_7918_(j, 0, 0), true);
                status = builder.addInput(worldgenlevel, BONE, pos.m_7918_(-j, 0, 0), true);
            }
            --length;
            pos = pos.m_7918_(0, -1, -3);
        }
        return status;
    }
}

