/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class TarBarkTree
extends Feature<NoneFeatureConfiguration> {
    private static final int MAX_TRUNK_HEIGHT = 6;
    private static final int MIN_TRUNK_HEIGHT = 2;

    public TarBarkTree(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos blockpos = context.m_159777_();
        RandomSource rand = context.m_225041_();
        FeatureBuilder builder = new FeatureBuilder();
        int trunkBaseHeight = 2 + rand.m_188503_(2);
        boolean xzChange = rand.m_188499_();
        if (worldgenlevel.m_46859_(blockpos.m_7495_()) || !((Block)DreamlandBlocks.TAR_BARK_SAPLING.block().get()).m_49966_().m_60710_((LevelReader)worldgenlevel, blockpos)) {
            return false;
        }
        if (!TarBarkTree.createTrunk(worldgenlevel, xzChange, trunkBaseHeight, builder, blockpos)) {
            return false;
        }
        if (!TarBarkTree.createBranches(worldgenlevel, xzChange, rand, trunkBaseHeight, blockpos, builder)) {
            return false;
        }
        if (!TarBarkTree.createLeaves(worldgenlevel, blockpos.m_6630_(8), builder, rand)) {
            return false;
        }
        builder.build(worldgenlevel);
        return true;
    }

    private static boolean createTrunk(WorldGenLevel worldgenlevel, Boolean xzChange, int baseHeight, FeatureBuilder builder, BlockPos blockpos) {
        BlockState log = ((Block)DreamlandWoodSets.TAR_BARK.log().block().get()).m_49966_();
        for (int i = 0; i <= 6; ++i) {
            BlockPos trunkPos = blockpos.m_6630_(i);
            BlockPos trunkOffset = trunkPos.m_122030_(1);
            if (xzChange.booleanValue()) {
                trunkOffset = trunkPos.m_122020_(1);
            }
            if (!builder.addInput(worldgenlevel, log, trunkPos)) {
                return false;
            }
            if (i < baseHeight || builder.addInput(worldgenlevel, log, trunkOffset)) continue;
            return false;
        }
        return builder.addInput(worldgenlevel, log, blockpos.m_6630_(7));
    }

    private static boolean createBranches(WorldGenLevel level, Boolean xzChange, RandomSource rand, int baseHeight, BlockPos pos, FeatureBuilder builder) {
        int i;
        BlockState log = ((Block)DreamlandWoodSets.TAR_BARK.log().block().get()).m_49966_();
        int northBranchHeight = baseHeight + rand.m_216339_(1, 3);
        int westBranchHeight = baseHeight + rand.m_216339_(2, 3);
        int eastBranchHeight = baseHeight + rand.m_216339_(1, 2);
        boolean canBuild = true;
        int zChange = 0;
        int xChange = 1;
        if (xzChange.booleanValue()) {
            zChange = 1;
            xChange = 0;
        }
        for (i = 1; i <= 2; ++i) {
            canBuild = builder.addInput(level, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.NORTH.m_122434_()), pos.m_7918_(0, baseHeight, i + zChange));
            canBuild = builder.addInput(level, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.EAST.m_122434_()), pos.m_7918_(i + xChange, northBranchHeight, 0));
        }
        canBuild = builder.addInput(level, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.UP.m_122434_()), pos.m_7918_(0, baseHeight + 1, 3 + zChange));
        canBuild = TarBarkTree.createLeaves(level, pos.m_7918_(0, baseHeight + 2, 3 + zChange), builder, rand);
        canBuild = builder.addInput(level, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.UP.m_122434_()), pos.m_7918_(3 + xChange, northBranchHeight + 1, 0));
        canBuild = TarBarkTree.createLeaves(level, pos.m_7918_(3 + xChange, northBranchHeight + 2, 0), builder, rand);
        for (i = 1; i <= 2; ++i) {
            canBuild = builder.addInput(level, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.SOUTH.m_122434_()), pos.m_7918_(xChange, eastBranchHeight, -i));
            canBuild = builder.addInput(level, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.WEST.m_122434_()), pos.m_7918_(-i, westBranchHeight, zChange));
        }
        canBuild = builder.addInput(level, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.UP.m_122434_()), pos.m_7918_(xChange, eastBranchHeight + 1, -3));
        canBuild = TarBarkTree.createLeaves(level, pos.m_7918_(xChange, eastBranchHeight + 2, -3), builder, rand);
        canBuild = builder.addInput(level, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.UP.m_122434_()), pos.m_7918_(-3, westBranchHeight + 1, zChange));
        canBuild = TarBarkTree.createLeaves(level, pos.m_7918_(-3, westBranchHeight + 2, zChange), builder, rand);
        return canBuild;
    }

    private static boolean createLeaves(WorldGenLevel level, BlockPos pos, FeatureBuilder builder, RandomSource rand) {
        BlockState leaves = (BlockState)((BlockState)((Block)DreamlandBlocks.TAR_BARK_LEAVES.block().get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1))).m_61124_((Property)LeavesBlock.f_54419_, (Comparable)Boolean.valueOf(true));
        boolean canBuild = true;
        int extraLength = 1 + rand.m_188503_(2);
        canBuild = builder.addInput(level, leaves, pos);
        for (int i = 0; i <= extraLength; ++i) {
            canBuild = builder.addInput(level, leaves, pos.m_122030_(1).m_122013_(1).m_6625_(i));
            canBuild = builder.addInput(level, leaves, pos.m_122025_(1).m_122013_(1).m_6625_(i));
            canBuild = builder.addInput(level, leaves, pos.m_122030_(1).m_122020_(1).m_6625_(i));
            canBuild = builder.addInput(level, leaves, pos.m_122025_(1).m_122020_(1).m_6625_(i));
        }
        return canBuild;
    }
}

