/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.material.Material;

public class SurfaceLake
extends Feature<Configuration> {
    public SurfaceLake(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<Configuration> context) {
        BlockPos blockpos = context.m_159777_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource random = context.m_225041_();
        Configuration surfacelake$configuration = (Configuration)context.m_159778_();
        if (blockpos.m_123342_() <= worldgenlevel.m_141937_() + 4) {
            return false;
        }
        blockpos = blockpos.m_6625_(4);
        boolean[] aboolean = new boolean[2048];
        int i = random.m_188503_(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = random.m_188500_() * 6.0 + 3.0;
            double d1 = random.m_188500_() * 4.0 + 2.0;
            double d2 = random.m_188500_() * 6.0 + 3.0;
            double d3 = random.m_188500_() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = random.m_188500_() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.m_188500_() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        aboolean[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        BlockState insideBlock = surfacelake$configuration.insideBlock().m_213972_(random, blockpos);
        BlockState borderBlock = surfacelake$configuration.barrier().m_213972_(random, blockpos);
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int k = 0; k < 16; ++k) {
                for (int l2 = 0; l2 < 8; ++l2) {
                    boolean flag;
                    boolean bl = flag = !aboolean[(k1 * 16 + k) * 8 + l2] && (k1 < 15 && aboolean[((k1 + 1) * 16 + k) * 8 + l2] || k1 > 0 && aboolean[((k1 - 1) * 16 + k) * 8 + l2] || k < 15 && aboolean[(k1 * 16 + k + 1) * 8 + l2] || k > 0 && aboolean[(k1 * 16 + (k - 1)) * 8 + l2] || l2 < 7 && aboolean[(k1 * 16 + k) * 8 + l2 + 1] || l2 > 0 && aboolean[(k1 * 16 + k) * 8 + (l2 - 1)]);
                    if (!flag) continue;
                    Material material = worldgenlevel.m_8055_(blockpos.m_7918_(k1, l2, k)).m_60767_();
                    if (l2 >= 4 && material.m_76332_()) {
                        return false;
                    }
                    if (l2 >= 4 || material.m_76333_() || worldgenlevel.m_8055_(blockpos.m_7918_(k1, l2, k)) == insideBlock || worldgenlevel.m_8055_(blockpos.m_7918_(k1, l2, k)) == borderBlock) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int i3 = 0; i3 < 8; ++i3) {
                    boolean flag1;
                    BlockPos blockpos1;
                    if (!aboolean[(l1 * 16 + i2) * 8 + i3] || !this.canReplaceBlock(worldgenlevel.m_8055_(blockpos1 = blockpos.m_7918_(l1, i3, i2)))) continue;
                    boolean bl = flag1 = i3 >= 4;
                    if (flag1) continue;
                    worldgenlevel.m_7731_(blockpos1, insideBlock, 2);
                }
            }
        }
        if (!borderBlock.m_60795_()) {
            for (int j2 = 0; j2 < 16; ++j2) {
                for (int j3 = 0; j3 < 16; ++j3) {
                    for (int l3 = 0; l3 < 4; ++l3) {
                        BlockState blockstate;
                        boolean flag2;
                        boolean bl = flag2 = !aboolean[(j2 * 16 + j3) * 8 + l3] && (j2 < 15 && aboolean[((j2 + 1) * 16 + j3) * 8 + l3] || j2 > 0 && aboolean[((j2 - 1) * 16 + j3) * 8 + l3] || j3 < 15 && aboolean[(j2 * 16 + j3 + 1) * 8 + l3] || j3 > 0 && aboolean[(j2 * 16 + (j3 - 1)) * 8 + l3] || l3 < 7 && aboolean[(j2 * 16 + j3) * 8 + l3 + 1] || l3 > 0 && aboolean[(j2 * 16 + j3) * 8 + (l3 - 1)]);
                        if (!flag2 || l3 >= 4 && random.m_188503_(2) == 0 || !(blockstate = worldgenlevel.m_8055_(blockpos.m_7918_(j2, l3, j3))).m_60767_().m_76333_() || blockstate.m_204336_(BlockTags.f_144288_)) continue;
                        BlockPos blockpos3 = blockpos.m_7918_(j2, l3, j3);
                        worldgenlevel.m_7731_(blockpos3, borderBlock, 2);
                        this.m_159739_(worldgenlevel, blockpos3);
                    }
                }
            }
        }
        return true;
    }

    private boolean canReplaceBlock(BlockState state) {
        return !state.m_204336_(BlockTags.f_144287_) || !state.m_60713_((Block)DreamlandBlocks.DRIED_TAR.block().get()) || !state.m_60713_((Block)DreamlandBlocks.DROUGHT_SOIL.block().get());
    }

    public record Configuration(BlockStateProvider insideBlock, BlockStateProvider barrier) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(recorder -> recorder.group((App)BlockStateProvider.f_68747_.fieldOf("insideBlock").forGetter(Configuration::insideBlock), (App)BlockStateProvider.f_68747_.fieldOf("barrier").forGetter(Configuration::barrier)).apply((Applicative)recorder, Configuration::new));
    }
}

