/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.configs.SphereConfig;
import com.github.dragoni7.dreamland.common.world.feature.util.FastNoiseLite;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureMath;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class Sphere
extends Feature<SphereConfig> {
    public Sphere(Codec<SphereConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SphereConfig> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource rand = context.m_225041_();
        FeatureBuilder builder = new FeatureBuilder();
        BlockPos origin = context.m_159777_();
        Boolean status = false;
        FastNoiseLite noise = Sphere.createNoise(worldgenlevel.m_7328_() + rand.m_188505_(), ((SphereConfig)context.m_159778_()).noiseFrequency().m_214084_(rand));
        int height = ((SphereConfig)context.m_159778_()).height().m_214085_(rand);
        int radius = ((SphereConfig)context.m_159778_()).radius().m_214085_(rand);
        for (int x = -radius; x < radius; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = -radius; z < radius; ++z) {
                    BlockPos pos = origin.m_7918_(x, y, z);
                    double distance = FeatureMath.distance(x, y, z, radius, height, radius);
                    float f = noise.GetNoise(x, y, z);
                    if (!(distance < 1.0)) continue;
                    if (f < 0.0f) {
                        status = builder.addInput(worldgenlevel, ((SphereConfig)context.m_159778_()).block1().m_213972_(rand, origin), pos, true);
                        continue;
                    }
                    if (((SphereConfig)context.m_159778_()).block2().m_213972_(rand, origin).m_60713_(Blocks.f_50016_)) continue;
                    status = builder.addInput(worldgenlevel, ((SphereConfig)context.m_159778_()).block2().m_213972_(rand, origin), pos, true);
                }
            }
        }
        if (!status.booleanValue()) {
            return false;
        }
        builder.build(worldgenlevel);
        return status;
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFrequency(frequency);
        return noise;
    }
}

