/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.github.dragoni7.dreamland.util.RollBoolean;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class PlumBirchTree
extends Feature<NoneFeatureConfiguration> {
    private static final int MAX_TRUNK_HEIGHT = 16;
    private static final int MIN_TRUNK_HEIGHT = 9;

    public PlumBirchTree(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource rand = context.m_225041_();
        int height = rand.m_216339_(9, 16);
        BlockPos blockpos = context.m_159777_();
        BlockPos branchPos = blockpos.m_6630_(height - rand.m_216339_(5, 6));
        FeatureBuilder plumBirchTreeBuilder = new FeatureBuilder();
        BlockState log = ((Block)DreamlandWoodSets.PLUM_BIRCH.log().block().get()).m_49966_();
        Boolean branchResult = false;
        if (!worldgenlevel.m_8055_(blockpos.m_7495_()).m_204336_(BlockTags.f_144274_) || worldgenlevel.m_46859_(blockpos.m_7495_()) || !worldgenlevel.m_46859_(blockpos.m_7494_()) || !((Block)DreamlandBlocks.PLUM_BIRCH_SAPLING.block().get()).m_49966_().m_60710_((LevelReader)worldgenlevel, blockpos)) {
            return false;
        }
        if (!PlumBirchTree.createTrunk(worldgenlevel, plumBirchTreeBuilder, blockpos, log, height)) {
            return false;
        }
        if (RollBoolean.roll(4, rand).booleanValue()) {
            switch (rand.m_188503_(4)) {
                case 0: {
                    branchPos = branchPos.m_122012_();
                    branchResult = plumBirchTreeBuilder.addInput(worldgenlevel, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.NORTH.m_122434_()), branchPos);
                    break;
                }
                case 1: {
                    branchPos = branchPos.m_122019_();
                    branchResult = plumBirchTreeBuilder.addInput(worldgenlevel, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.SOUTH.m_122434_()), branchPos);
                    break;
                }
                case 2: {
                    branchPos = branchPos.m_122029_();
                    branchResult = plumBirchTreeBuilder.addInput(worldgenlevel, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.EAST.m_122434_()), branchPos);
                    break;
                }
                case 3: {
                    branchPos = branchPos.m_122024_();
                    branchResult = plumBirchTreeBuilder.addInput(worldgenlevel, (BlockState)log.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.WEST.m_122434_()), branchPos);
                }
            }
            if (!branchResult.booleanValue()) {
                return false;
            }
        }
        if (!PlumBirchTree.createLeaves(worldgenlevel, blockpos, plumBirchTreeBuilder, rand, height)) {
            return false;
        }
        plumBirchTreeBuilder.build(worldgenlevel);
        if (RollBoolean.roll(16, rand).booleanValue() && branchResult.booleanValue()) {
            worldgenlevel.m_7731_(branchPos.m_7495_(), (BlockState)Blocks.f_50717_.m_49966_().m_61124_((Property)BeehiveBlock.f_49563_, (Comparable)Direction.SOUTH), 3);
            worldgenlevel.m_141902_(branchPos.m_7495_(), BlockEntityType.f_58912_).ifPresent(beeHive -> {
                int j = 2 + rand.m_188503_(2);
                for (int k = 0; k < j; ++k) {
                    CompoundTag compoundtag = new CompoundTag();
                    compoundtag.m_128359_("id", Registry.f_122826_.m_7981_((Object)EntityType.f_20550_).toString());
                    beeHive.m_155157_(compoundtag, rand.m_188503_(599), false);
                }
            });
        }
        return true;
    }

    private static boolean createTrunk(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, BlockState log, int height) {
        for (int i = 0; i <= height; ++i) {
            BlockPos trunkPos = blockpos.m_6630_(i);
            if (builder.addInput(worldgenlevel, log, trunkPos)) continue;
            return false;
        }
        return true;
    }

    private static boolean createLeaves(WorldGenLevel level, BlockPos pos, FeatureBuilder builder, RandomSource rand, int height) {
        BlockState leaves = (BlockState)((Block)DreamlandBlocks.PLUM_BIRCH_LEAVES.block().get()).m_49966_().m_61124_((Property)LeavesBlock.f_54418_, (Comparable)Integer.valueOf(1));
        BlockPos leavesPos = pos.m_6630_(height);
        boolean canBuild = true;
        canBuild = builder.addInput(level, leaves, leavesPos);
        canBuild = builder.addInput(level, leaves, leavesPos.m_122012_());
        canBuild = builder.addInput(level, leaves, leavesPos.m_122019_());
        canBuild = builder.addInput(level, leaves, leavesPos.m_122029_());
        canBuild = builder.addInput(level, leaves, leavesPos.m_122024_());
        leavesPos = leavesPos.m_7495_();
        canBuild = builder.addInput(level, leaves, leavesPos.m_122012_());
        canBuild = builder.addInput(level, leaves, leavesPos.m_122019_());
        canBuild = builder.addInput(level, leaves, leavesPos.m_122029_());
        canBuild = builder.addInput(level, leaves, leavesPos.m_122024_());
        if (RollBoolean.roll(2, rand).booleanValue()) {
            canBuild = builder.addInput(level, leaves, leavesPos.m_122012_().m_122029_());
        }
        if (RollBoolean.roll(2, rand).booleanValue()) {
            canBuild = builder.addInput(level, leaves, leavesPos.m_122012_().m_122024_());
        }
        if (RollBoolean.roll(2, rand).booleanValue()) {
            canBuild = builder.addInput(level, leaves, leavesPos.m_122019_().m_122029_());
        }
        if (RollBoolean.roll(2, rand).booleanValue()) {
            canBuild = builder.addInput(level, leaves, leavesPos.m_122019_().m_122024_());
        }
        for (int i = 1; i <= 2; ++i) {
            for (int j = 1; j <= 2; ++j) {
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122013_(j));
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122013_(j).m_122029_());
                if (RollBoolean.roll(2, rand).booleanValue()) {
                    canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122013_(j).m_122029_().m_122029_());
                }
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122013_(j).m_122024_());
                if (RollBoolean.roll(2, rand).booleanValue()) {
                    canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122013_(j).m_122024_().m_122024_());
                }
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122020_(j));
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122020_(j).m_122029_());
                if (RollBoolean.roll(2, rand).booleanValue()) {
                    canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122020_(j).m_122029_().m_122029_());
                }
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122020_(j).m_122024_());
                if (RollBoolean.roll(2, rand).booleanValue()) {
                    canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122020_(j).m_122024_().m_122024_());
                }
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122030_(j));
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122030_(j).m_122012_());
                if (RollBoolean.roll(2, rand).booleanValue()) {
                    canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122030_(j).m_122012_().m_122012_());
                }
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122030_(j).m_122019_());
                if (RollBoolean.roll(2, rand).booleanValue()) {
                    canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122030_(j).m_122019_().m_122019_());
                }
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122025_(j));
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122025_(j).m_122012_());
                if (RollBoolean.roll(2, rand).booleanValue()) {
                    canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122025_(j).m_122012_().m_122012_());
                }
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122025_(j).m_122019_());
                if (!RollBoolean.roll(2, rand).booleanValue()) continue;
                canBuild = builder.addInput(level, leaves, leavesPos.m_6625_(i).m_122025_(j).m_122019_().m_122019_());
            }
        }
        return canBuild;
    }
}

