/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.util.FastNoiseLite;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.util.RollBoolean;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class OpalCluster
extends Feature<NoneFeatureConfiguration> {
    private static final BlockState CALCITE = Blocks.f_152497_.m_49966_();
    private static final BlockState BASE = Blocks.f_152597_.m_49966_();

    public OpalCluster(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource rand = context.m_225041_();
        FastNoiseLite clusterNoise = new FastNoiseLite((int)worldgenlevel.m_7328_());
        clusterNoise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        boolean status = false;
        FeatureBuilder builder = new FeatureBuilder();
        BlockState state = ((Block)DreamlandBlocks.OPAL_CLUSTER.block().get()).m_49966_();
        if (RollBoolean.roll(5, rand).booleanValue()) {
            state = Blocks.f_152491_.m_49966_();
        }
        int xRadius = rand.m_216332_(1, 2);
        int yRadius = rand.m_216332_(2, 4);
        int zRadius = rand.m_216332_(1, 2);
        float noise = clusterNoise.GetNoise(origin.m_122012_().m_123341_(), origin.m_122012_().m_123342_(), origin.m_122012_().m_123343_());
        status = builder.addInput(worldgenlevel, BASE, origin, true);
        status = builder.addInput(worldgenlevel, BASE, origin.m_122012_(), true);
        status = noise > 0.0f ? builder.addInput(worldgenlevel, BASE, origin.m_122012_().m_122029_(), true) : builder.addInput(worldgenlevel, BASE, origin.m_122019_().m_122024_(), true);
        noise = clusterNoise.GetNoise(origin.m_122019_().m_123341_(), origin.m_122019_().m_123342_(), origin.m_122019_().m_123343_());
        status = builder.addInput(worldgenlevel, BASE, origin.m_122019_(), true);
        status = noise > 0.0f ? builder.addInput(worldgenlevel, BASE, origin.m_122019_().m_122029_(), true) : builder.addInput(worldgenlevel, BASE, origin.m_122019_().m_122024_(), true);
        status = builder.addInput(worldgenlevel, BASE, origin.m_122029_(), true);
        status = builder.addInput(worldgenlevel, BASE, origin.m_122024_(), true);
        status = builder.addInput(worldgenlevel, state, origin.m_6630_(yRadius + 1), true);
        origin = origin.m_7494_();
        for (int x = -xRadius; x < xRadius; ++x) {
            for (int y = 0; y < yRadius; ++y) {
                for (int z = -zRadius; z < zRadius; ++z) {
                    BlockState state1;
                    BlockPos pos = origin.m_7918_(x, y, z);
                    double distance = Mth.m_144952_((double)((double)x / (double)xRadius)) + Mth.m_144952_((double)((double)y / (double)yRadius)) + Mth.m_144952_((double)((double)z / (double)zRadius));
                    noise = clusterNoise.GetNoise(x, y, z);
                    if (distance < 1.0 && distance > 0.8 && noise < 0.0f) {
                        state1 = state;
                    } else {
                        if (!(distance < 1.0 + Mth.m_216263_((RandomSource)rand, (double)0.1, (double)0.3))) continue;
                        state1 = CALCITE;
                    }
                    if (worldgenlevel.m_8055_(pos).m_204336_(BlockTags.f_144287_)) continue;
                    status = builder.addInput(worldgenlevel, state1, pos, true);
                }
            }
        }
        if (!status) {
            return false;
        }
        builder.build(worldgenlevel);
        return status;
    }
}

