/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.util.FastNoiseLite;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureMath;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public class MoldWoodTree
extends Feature<NoneFeatureConfiguration> {
    public MoldWoodTree(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        double distance;
        int z;
        int y;
        int x;
        BlockPos origin;
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource rand = context.m_225041_();
        FastNoiseLite trunkNoise = MoldWoodTree.createNoise(worldgenlevel.m_7328_() + rand.m_188505_(), 0.1f);
        FeatureBuilder builder = new FeatureBuilder();
        BlockPos pos = origin = context.m_159777_();
        Boolean status = false;
        int radius = 6;
        int yHeight = rand.m_216332_(26, 46);
        int foliageHeight = 6;
        int foliageRadius = 16;
        WeightedStateProvider trunkBlockProvider = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandWoodSets.MOLD_WOOD.wood().block().get()).m_49966_(), 75).m_146271_((Object)((Block)DreamlandBlocks.GLOWING_MOLD_WOOD.block().get()).m_49966_(), 25));
        WeightedStateProvider foliageBlockProvider = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.BLACK_MOLD.block().get()).m_49966_(), 50).m_146271_((Object)((Block)DreamlandBlocks.WHITE_MOLD.block().get()).m_49966_(), 50));
        BlockState foliageBlock = foliageBlockProvider.m_213972_(rand, origin);
        BlockState trunkBlock = trunkBlockProvider.m_213972_(rand, origin);
        for (x = -radius; x < radius; ++x) {
            for (y = 0; y < yHeight; ++y) {
                for (z = -radius; z < radius; ++z) {
                    distance = Mth.m_144952_((double)((double)x / (double)(radius - 3))) + Mth.m_144952_((double)((double)y / (double)yHeight)) + Mth.m_144952_((double)((double)z / (double)(radius - 3)));
                    float noise = trunkNoise.GetNoise(x, y, z);
                    pos = origin.m_7918_(x, y, z);
                    if (distance < 1.3 + (double)noise) {
                        status = builder.addInput(worldgenlevel, (BlockState)((Block)DreamlandWoodSets.MOLD_WOOD.strippedLog().block().get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)Direction.Axis.Y), pos, true);
                        continue;
                    }
                    if (!(distance < (double)(2.0f + noise))) continue;
                    trunkBlock = trunkBlockProvider.m_213972_(rand, pos);
                    status = builder.addInput(worldgenlevel, trunkBlock, pos, true);
                }
            }
        }
        origin = pos.m_7918_(-5, 0, -5);
        for (x = -foliageRadius; x < foliageRadius; ++x) {
            for (y = 0; y < foliageHeight; ++y) {
                for (z = -foliageRadius; z < foliageRadius; ++z) {
                    pos = origin.m_7918_(x, y, z);
                    distance = FeatureMath.distance(x, y, z, foliageRadius, foliageHeight, foliageRadius);
                    if (distance > 0.8 && distance < 1.0 && y < 1) {
                        int overhang = rand.m_216332_(1, 9);
                        for (int i = 0; i < overhang; ++i) {
                            status = builder.addInput(worldgenlevel, foliageBlock, pos.m_7918_(0, -i, 0), true);
                        }
                        continue;
                    }
                    if (!(distance < 1.0)) continue;
                    status = builder.addInput(worldgenlevel, foliageBlock, pos, true);
                }
            }
        }
        if (!status.booleanValue()) {
            return false;
        }
        builder.build(worldgenlevel);
        return status;
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        noise.SetFrequency(frequency);
        return noise;
    }
}

