/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;

public class MoldGrowth
extends Feature<SimpleBlockConfiguration> {
    private static final int MAX_TRUNK_HEIGHT = 6;
    private static final int MIN_TRUNK_HEIGHT = 2;

    public MoldGrowth(Codec<SimpleBlockConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleBlockConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos origin = context.m_159777_();
        RandomSource rand = context.m_225041_();
        FeatureBuilder builder = new FeatureBuilder();
        BlockState state = ((SimpleBlockConfiguration)context.m_159778_()).f_68069_().m_213972_(rand, origin);
        int trunkBaseHeight = 2 + rand.m_188503_(2);
        boolean xzChange = rand.m_188499_();
        if (!MoldGrowth.createTrunk(state, worldgenlevel, xzChange, trunkBaseHeight, builder, origin)) {
            return false;
        }
        if (!MoldGrowth.createBranches(worldgenlevel, state, xzChange, rand, trunkBaseHeight, origin, builder)) {
            return false;
        }
        builder.build(worldgenlevel);
        return true;
    }

    private static boolean createTrunk(BlockState state, WorldGenLevel worldgenlevel, Boolean xzChange, int baseHeight, FeatureBuilder builder, BlockPos blockpos) {
        for (int i = 0; i <= 6; ++i) {
            BlockPos trunkPos = blockpos.m_6630_(i);
            BlockPos trunkOffset = trunkPos.m_122030_(1);
            if (xzChange.booleanValue()) {
                trunkOffset = trunkPos.m_122020_(1);
            }
            if (!builder.addInput(worldgenlevel, state, trunkPos)) {
                return false;
            }
            if (i < baseHeight || builder.addInput(worldgenlevel, state, trunkOffset)) continue;
            return false;
        }
        return builder.addInput(worldgenlevel, state, blockpos.m_6630_(7));
    }

    private static boolean createBranches(WorldGenLevel level, BlockState state, Boolean xzChange, RandomSource rand, int baseHeight, BlockPos pos, FeatureBuilder builder) {
        int i;
        int northBranchHeight = baseHeight + rand.m_216339_(1, 3);
        int westBranchHeight = baseHeight + rand.m_216339_(2, 3);
        int eastBranchHeight = baseHeight + rand.m_216339_(1, 2);
        boolean canBuild = true;
        int zChange = 0;
        int xChange = 1;
        if (xzChange.booleanValue()) {
            zChange = 1;
            xChange = 0;
        }
        for (i = 1; i <= 1; ++i) {
            canBuild = builder.addInput(level, state, pos.m_7918_(0, baseHeight, i + zChange));
            canBuild = builder.addInput(level, state, pos.m_7918_(i + xChange, northBranchHeight, 0));
        }
        canBuild = builder.addInput(level, state, pos.m_7918_(0, baseHeight + 1, 2 + zChange));
        canBuild = builder.addInput(level, state, pos.m_7918_(2 + xChange, northBranchHeight + 1, 0));
        for (i = 1; i <= 1; ++i) {
            canBuild = builder.addInput(level, state, pos.m_7918_(xChange, eastBranchHeight, -i));
            canBuild = builder.addInput(level, state, pos.m_7918_(-i, westBranchHeight, zChange));
        }
        canBuild = builder.addInput(level, state, pos.m_7918_(xChange, eastBranchHeight + 1, -2));
        canBuild = builder.addInput(level, state, pos.m_7918_(-2, westBranchHeight + 1, zChange));
        return canBuild;
    }
}

