/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.blocks.HiveWeaverBlock;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.util.RollBoolean;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class HiveStrand
extends Feature<NoneFeatureConfiguration> {
    private static final int MAXSIZE = 60;

    public HiveStrand(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        BlockPos blockpos = context.m_159777_();
        RandomSource random = context.m_225041_();
        FeatureBuilder strandBuilder = new FeatureBuilder();
        boolean fill = RollBoolean.roll(9, random);
        switch (random.m_188503_(6)) {
            case 0: {
                return this.growXZPos(worldgenlevel, strandBuilder, blockpos, fill, random);
            }
            case 1: {
                return this.growXZNeg(worldgenlevel, strandBuilder, blockpos, fill, random);
            }
            case 2: {
                return this.growXPos(worldgenlevel, strandBuilder, blockpos, fill, random);
            }
            case 3: {
                return this.growXNeg(worldgenlevel, strandBuilder, blockpos, fill, random);
            }
            case 4: {
                return this.growZPos(worldgenlevel, strandBuilder, blockpos, fill, random);
            }
            case 6: {
                return this.growZNeg(worldgenlevel, strandBuilder, blockpos, fill, random);
            }
        }
        return false;
    }

    private boolean buildStrand(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, RandomSource rand, int i, int j, int k) {
        return this.buildStrand(worldgenlevel, builder, blockpos, rand, null, false, i, j, k);
    }

    private boolean buildStrand(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, RandomSource rand, Direction direction, boolean fill, int i, int j, int k) {
        BlockState strandBlock = ((Block)DreamlandBlocks.HIVE_BLOCK.block().get()).m_49966_();
        BlockState fillBlock = ((Block)DreamlandBlocks.HIVE_MEMBRANE.block().get()).m_49966_();
        BlockState core = (BlockState)((Block)DreamlandBlocks.HIVE_WEAVER.block().get()).m_49966_().m_61124_((Property)HiveWeaverBlock.LEVEL, (Comparable)Integer.valueOf(7));
        int height = j - 2;
        BlockPos fillPos = blockpos.m_7918_(i, height, k);
        boolean status = true;
        int offsetxz = rand.m_216339_(0, 2);
        int offsety = rand.m_216339_(0, 2);
        builder.addInput(worldgenlevel, strandBlock, blockpos.m_7918_(i, j, k));
        status = builder.addInput(worldgenlevel, strandBlock, blockpos.m_7918_(i, j + 1, k));
        builder.addInput(worldgenlevel, strandBlock, blockpos.m_7918_(i, j - 1, k));
        if (fill) {
            if (j == 1 || j == 2) {
                builder.addInput(worldgenlevel, (BlockState)((BlockState)core.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction)).m_61124_((Property)HiveWeaverBlock.LEVEL, (Comparable)Integer.valueOf(6)), blockpos.m_7918_(i, j, k), true);
            }
            while (fillPos.m_123342_() < 60 && fillPos.m_123342_() > worldgenlevel.m_141937_() && (worldgenlevel.m_46859_(fillPos = blockpos.m_7918_(i, height, k)) || fillPos.m_123342_() >= blockpos.m_123342_())) {
                if (direction.equals((Object)Direction.NORTH)) {
                    if (this.placeCore(i, height)) {
                        if (offsetxz != 0 || offsety != 0) {
                            builder.addInput(worldgenlevel, fillBlock, fillPos);
                        }
                        builder.addInput(worldgenlevel, (BlockState)core.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction), fillPos.m_7918_(offsetxz, offsety, 0), true);
                        offsetxz = rand.m_216339_(0, 2);
                        offsety = rand.m_216339_(0, 2);
                    } else {
                        builder.addInput(worldgenlevel, fillBlock, fillPos);
                    }
                } else if (direction.equals((Object)Direction.WEST)) {
                    if (this.placeCore(k, height)) {
                        if (offsetxz != 0 || offsety != 0) {
                            builder.addInput(worldgenlevel, fillBlock, fillPos);
                        }
                        builder.addInput(worldgenlevel, (BlockState)core.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction), fillPos.m_7918_(0, offsety, offsetxz), true);
                        offsetxz = rand.m_216339_(0, 2);
                        offsety = rand.m_216339_(0, 2);
                    } else {
                        builder.addInput(worldgenlevel, fillBlock, fillPos);
                    }
                } else {
                    builder.addInput(worldgenlevel, fillBlock, fillPos);
                }
                --height;
            }
        }
        if (!status) {
            if (fill) {
                height = j - 2;
                fillPos = blockpos.m_7918_(i, height, k);
                builder.addInput(worldgenlevel, (BlockState)((BlockState)core.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction)).m_61124_((Property)HiveWeaverBlock.LEVEL, (Comparable)Integer.valueOf(6)), fillPos, true);
                --height;
                while (fillPos.m_123342_() < 60 && fillPos.m_123342_() > worldgenlevel.m_141937_()) {
                    fillPos = blockpos.m_7918_(i, height, k);
                    if (!worldgenlevel.m_46859_(fillPos) && fillPos.m_123342_() < blockpos.m_123342_()) {
                        builder.addInput(worldgenlevel, (BlockState)((BlockState)core.m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)direction)).m_61124_((Property)HiveWeaverBlock.LEVEL, (Comparable)Integer.valueOf(6)), fillPos.m_6630_(rand.m_216339_(4, 6)), true);
                        break;
                    }
                    builder.addInput(worldgenlevel, strandBlock, fillPos);
                    --height;
                }
            }
            return status;
        }
        return status;
    }

    private boolean placeCore(int i, int y) {
        return y % 6 == 0 && i % 3 == 0;
    }

    private boolean growXZPos(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, boolean fill, RandomSource random) {
        int i = 0;
        int j = 0;
        int k = 0;
        while (j < 60) {
            if (!this.buildStrand(worldgenlevel, builder, blockpos, random, i, j, k)) {
                builder.build(worldgenlevel);
                return true;
            }
            ++i;
            j += random.m_216339_(1, 3);
            ++k;
        }
        return false;
    }

    private boolean growXZNeg(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, boolean fill, RandomSource random) {
        int i = 0;
        int j = 0;
        int k = 0;
        while (j <= 60) {
            if (!this.buildStrand(worldgenlevel, builder, blockpos, random, i, j, k)) {
                builder.build(worldgenlevel);
                return true;
            }
            --i;
            j += random.m_216339_(1, 3);
            --k;
        }
        return false;
    }

    private boolean growXPos(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, boolean fill, RandomSource random) {
        int i = 0;
        int k = 0;
        for (int j = 0; j <= 60; j += random.m_216339_(1, 3)) {
            if (!this.buildStrand(worldgenlevel, builder, blockpos, random, Direction.NORTH, fill, i, j, k)) {
                builder.build(worldgenlevel);
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean growXNeg(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, boolean fill, RandomSource random) {
        int i = 0;
        int k = 0;
        for (int j = 0; j <= 60; j += random.m_216339_(1, 3)) {
            if (!this.buildStrand(worldgenlevel, builder, blockpos, random, Direction.NORTH, fill, i, j, k)) {
                builder.build(worldgenlevel);
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean growZPos(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, boolean fill, RandomSource random) {
        int i = 0;
        int j = 0;
        int k = 0;
        while (j <= 60) {
            if (!this.buildStrand(worldgenlevel, builder, blockpos, random, Direction.WEST, fill, i, j, k)) {
                builder.build(worldgenlevel);
                return true;
            }
            j += random.m_216339_(1, 3);
            ++k;
        }
        return false;
    }

    private boolean growZNeg(WorldGenLevel worldgenlevel, FeatureBuilder builder, BlockPos blockpos, boolean fill, RandomSource random) {
        int i = 0;
        int j = 0;
        int k = 0;
        while (j <= 60) {
            if (!this.buildStrand(worldgenlevel, builder, blockpos, random, Direction.WEST, fill, i, j, k)) {
                builder.build(worldgenlevel);
                return true;
            }
            j += random.m_216339_(1, 3);
            --k;
        }
        return false;
    }
}

