/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.configs.HillConfig;
import com.github.dragoni7.dreamland.common.world.feature.util.FastNoiseLite;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.util.RollBoolean;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class Hill
extends Feature<HillConfig> {
    public Hill(Codec<HillConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<HillConfig> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource rand = context.m_225041_();
        FastNoiseLite hillNoise = Hill.createNoise(worldgenlevel.m_7328_() + rand.m_188505_(), ((HillConfig)context.m_159778_()).noiseFrequency().m_214084_(rand));
        FeatureBuilder builder = new FeatureBuilder();
        BlockPos origin = context.m_159777_();
        Boolean status = false;
        Boolean hasLake = RollBoolean.roll(((HillConfig)context.m_159778_()).lakeFrequency().m_214085_(rand), rand);
        int xRadius = ((HillConfig)context.m_159778_()).xRadius().m_214085_(rand);
        int yHeight = ((HillConfig)context.m_159778_()).yHeight().m_214085_(rand);
        int zRadius = ((HillConfig)context.m_159778_()).zRadius().m_214085_(rand);
        for (int x = -xRadius; x < xRadius; ++x) {
            for (int y = 0; y < yHeight; ++y) {
                for (int z = -zRadius; z < zRadius; ++z) {
                    double distance = Mth.m_144952_((double)((double)x / (double)(xRadius - 3))) + Mth.m_144952_((double)((double)y / (double)yHeight)) + Mth.m_144952_((double)((double)z / (double)(zRadius - 3)));
                    float noise = hillNoise.GetNoise(x, y, z);
                    BlockPos pos = origin.m_7918_(x, y, z);
                    if (hasLake.booleanValue() && y == yHeight - 1 && distance < 1.7 + (double)noise) {
                        status = builder.addInput(worldgenlevel, ((HillConfig)context.m_159778_()).liquidBlock().m_213972_(rand, origin), pos, true);
                        if (!RollBoolean.roll(5, rand).booleanValue()) continue;
                        status = builder.addInput(worldgenlevel, ((HillConfig)context.m_159778_()).liquidBlock().m_213972_(rand, origin), pos.m_7495_(), true);
                        continue;
                    }
                    if (!(distance < (double)(2.0f + noise))) continue;
                    status = builder.addInput(worldgenlevel, ((HillConfig)context.m_159778_()).block().m_213972_(rand, origin), pos, true);
                }
            }
        }
        if (!status.booleanValue()) {
            return false;
        }
        builder.build(worldgenlevel);
        return status;
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.Cellular);
        noise.SetFrequency(frequency);
        return noise;
    }
}

