/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.configs.EllipsoidConfig;
import com.github.dragoni7.dreamland.common.world.feature.util.FastNoiseLite;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureMath;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class Ellipsoid
extends Feature<EllipsoidConfig> {
    private static final int ONE = 1;

    public Ellipsoid(Codec<EllipsoidConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<EllipsoidConfig> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource rand = context.m_225041_();
        FastNoiseLite ellipsoidNoise = Ellipsoid.createNoise(worldgenlevel.m_7328_());
        EllipsoidConfig config = (EllipsoidConfig)context.m_159778_();
        boolean status = false;
        FeatureBuilder ellipsoidBuilder = new FeatureBuilder();
        BlockPos origin = context.m_159777_();
        int xRadius = config.xRadius().m_214085_(rand);
        int yRadius = config.yRadius().m_214085_(rand);
        int zRadius = config.zRadius().m_214085_(rand);
        for (int x = -xRadius; x < xRadius; ++x) {
            for (int y = -yRadius; y < yRadius; ++y) {
                for (int z = -zRadius; z < zRadius; ++z) {
                    BlockState state;
                    BlockPos pos = origin.m_7918_(x, y, z);
                    double distance = FeatureMath.distance(x, y, z, xRadius, yRadius, zRadius);
                    float noise = ellipsoidNoise.GetNoise(x, y, z);
                    if (distance < 0.9 && noise < 0.0f) {
                        state = config.noiseBlock().m_213972_(rand, origin);
                    } else {
                        if (!(distance < 1.0 + Mth.m_216263_((RandomSource)rand, (double)0.1, (double)0.3))) continue;
                        state = config.block().m_213972_(rand, origin);
                    }
                    if (worldgenlevel.m_8055_(pos).m_204336_(BlockTags.f_144287_)) continue;
                    status = ellipsoidBuilder.addInput(worldgenlevel, state, pos, true);
                }
            }
        }
        if (!status) {
            return false;
        }
        ellipsoidBuilder.build(worldgenlevel);
        return status;
    }

    private static FastNoiseLite createNoise(long seed) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFractalOctaves(6);
        noise.SetFrequency(0.001f);
        return noise;
    }
}

