/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature.generation;

import com.github.dragoni7.dreamland.common.world.feature.configs.ConeConfig;
import com.github.dragoni7.dreamland.common.world.feature.util.FastNoiseLite;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureBuilder;
import com.github.dragoni7.dreamland.common.world.feature.util.FeatureMath;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class Cone
extends Feature<ConeConfig> {
    public Cone(Codec<ConeConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ConeConfig> context) {
        WorldGenLevel worldgenlevel = context.m_159774_();
        RandomSource rand = context.m_225041_();
        FeatureBuilder builder = new FeatureBuilder();
        BlockPos origin = context.m_159777_();
        FastNoiseLite noise = Cone.createNoise(worldgenlevel.m_7328_(), ((ConeConfig)context.m_159778_()).noiseFrequency().m_214084_(rand));
        int height = ((ConeConfig)context.m_159778_()).height().m_214085_(rand);
        int baseRadius = ((ConeConfig)context.m_159778_()).radius().m_214085_(rand);
        for (int y = 0; y < height; ++y) {
            for (int x = -baseRadius; x < baseRadius; ++x) {
                for (int z = -baseRadius; z < baseRadius; ++z) {
                    int currentHeight = height - y;
                    double coneRadius = FeatureMath.coneRadius(FeatureMath.coneSlantHeight(baseRadius, currentHeight), currentHeight);
                    BlockPos pos = origin.m_7918_(x, y, z);
                    double distance = origin.m_7918_(0, y, 0).m_203198_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    float f = noise.GetNoise(x, y, z);
                    if (!(distance < coneRadius - (double)((float)(rand.m_216332_(1, 2) + baseRadius / 2) - f))) continue;
                    BlockState block1 = ((ConeConfig)context.m_159778_()).block1().m_213972_(rand, origin);
                    BlockState block2 = ((ConeConfig)context.m_159778_()).block2().m_213972_(rand, origin);
                    if (!(f > 0.0f ? !builder.addInput(worldgenlevel, block1, pos, true) : !builder.addInput(worldgenlevel, block2, pos, true))) continue;
                    return false;
                }
            }
        }
        builder.build(worldgenlevel);
        return true;
    }

    private static FastNoiseLite createNoise(long seed, float frequency) {
        FastNoiseLite noise = new FastNoiseLite((int)seed);
        noise.SetNoiseType(FastNoiseLite.NoiseType.OpenSimplex2S);
        noise.SetFrequency(frequency);
        return noise;
    }
}

