/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.feature;

import com.github.dragoni7.dreamland.common.blocks.KunzitePointBlock;
import com.github.dragoni7.dreamland.common.world.feature.configs.ConeConfig;
import com.github.dragoni7.dreamland.common.world.feature.configs.EllipsoidConfig;
import com.github.dragoni7.dreamland.common.world.feature.configs.GrowthLayerConfig;
import com.github.dragoni7.dreamland.common.world.feature.configs.HillConfig;
import com.github.dragoni7.dreamland.common.world.feature.configs.SphereConfig;
import com.github.dragoni7.dreamland.common.world.feature.generation.SurfaceLake;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandFeatures;
import com.github.dragoni7.dreamland.core.registry.DreamlandFluids;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.github.dragoni7.dreamland.data.DreamlandBlockTags;
import com.github.dragoni7.dreamland.util.DreamlandLoc;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.util.valueproviders.WeightedListInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.LakeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.MultifaceGrowthConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SpringConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.minecraft.world.level.material.FlowingFluid;

public class DreamlandConfiguredFeatures {
    private static final ArrayList<ResourceKey<ConfiguredFeature<?, ?>>> KEYS = new ArrayList();
    public static final RuleTest KUNZITE_ORES_REPLACEABLE = new TagMatchTest(DreamlandBlockTags.KUNZITE_ORES_REPLACEABLE);
    public static final RuleTest HIVE_ORES_REPLACEABLE = new TagMatchTest(DreamlandBlockTags.HIVE_ORES_REPLACEABLE);
    public static final RuleTest FOSSILIZED_EGG_REPLACEABLE = new TagMatchTest(DreamlandBlockTags.FOSSILIZED_EGG_REPLACEABLE);
    public static final RuleTest TOXIC_JUNGLE_GROUND = new TagMatchTest(DreamlandBlockTags.TOXIC_JUNGLE_GROUND_BLOCKS);
    public static final RuleTest GLOWING_MOLD_WOOD_REPLACEABLE = new BlockMatchTest((Block)DreamlandWoodSets.MOLD_WOOD.wood().block().get());
    public static final RuleTest NECRATHENE_REPLACEABLE = new TagMatchTest(DreamlandBlockTags.NECRATHENE_REPLACEABLE);
    public static final RuleTest PURITY_REPLACEABLE = new TagMatchTest(DreamlandBlockTags.PURITY_REPLACEABLE);
    public static final RuleTest PETRIFIED_VEGETATION = new BlockMatchTest((Block)DreamlandBlocks.PETRIFIED_VEGETATION.block().get());
    public static final List<OreConfiguration.TargetBlockState> KUNZITE_COPPER_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)KUNZITE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.KUNZITE_COPPER_ORE.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> KUNZITE_IRON_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)KUNZITE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.KUNZITE_IRON_ORE.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> KUNZITE_REDSTONE_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)KUNZITE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.KUNZITE_REDSTONE_ORE.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> KUNZITE_LAPIS_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)KUNZITE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.KUNZITE_LAPIS_ORE.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> KUNZITE_EMERALD_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)KUNZITE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.KUNZITE_EMERALD_ORE.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> KUNZITE_DIAMOND_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)KUNZITE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.KUNZITE_DIAMOND_ORE.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> FILLED_HIVE_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)HIVE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.HIVE_BLOCK_WITH_JELLY.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> HIVE_IRON_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)HIVE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.HIVE_IRON.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> HIVE_COPPER_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)HIVE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.HIVE_COPPER.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> HIVE_GOLD_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)HIVE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.HIVE_GOLD.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> HIVE_REDSTONE_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)HIVE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.HIVE_REDSTONE.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> HIVE_LAPIS_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)HIVE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.HIVE_LAPIS.block().get()).m_49966_()));
    public static final List<OreConfiguration.TargetBlockState> HIVE_DIAMOND_TARGET_LIST = List.of(OreConfiguration.m_161021_((RuleTest)HIVE_ORES_REPLACEABLE, (BlockState)((Block)DreamlandBlocks.HIVE_DIAMOND.block().get()).m_49966_()));
    public static final Holder<ConfiguredFeature<BlockColumnConfiguration, ?>> CAVE_SLIME = DreamlandConfiguredFeatures.registerConfiguredFeature("cave_slime", Feature.f_190875_, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.m_191218_((IntProvider)new WeightedListInt(SimpleWeightedRandomList.m_146263_().m_146271_((Object)UniformInt.m_146622_((int)0, (int)19), 2).m_146271_((Object)UniformInt.m_146622_((int)0, (int)2), 3).m_146271_((Object)UniformInt.m_146622_((int)0, (int)6), 10).m_146270_()), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.CAVE_SLIME_PLANT.get()))), BlockColumnConfiguration.m_191218_((IntProvider)ConstantInt.m_146483_((int)1), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.CAVE_SLIME.block().get())))), Direction.DOWN, BlockPredicate.f_190393_, true));
    public static final Holder<ConfiguredFeature<BlockStateConfiguration, ?>> HIVE_COMB = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_comb", DreamlandFeatures.HIVE_COMB, new BlockStateConfiguration(((Block)DreamlandBlocks.HIVE_BLOCK_WITH_JELLY.block().get()).m_49966_()));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> HIVE_STRAND = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_strand", DreamlandFeatures.HIVE_STRAND, new NoneFeatureConfiguration());
    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> HIVE_JELLY_CLUSTER = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_jelly_cluster", Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.HIVE_JELLY_CLUSTER.block().get()))));
    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> INFESTED_HIVE_JELLY_CLUSTER = DreamlandConfiguredFeatures.registerConfiguredFeature("infested_hive_jelly_cluster", Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.INFESTED_HIVE_JELLY_CLUSTER.block().get()))));
    public static final Holder<ConfiguredFeature<GrowthLayerConfig, ?>> HIVE_GROWTH = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_growth", DreamlandFeatures.GROWTH_LAYER, new GrowthLayerConfig((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)DreamlandBlocks.HIVE_GROWTH.block().get()).m_49966_()), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)DreamlandBlocks.HIVE_BLOCK.block().get()).m_49966_()), (IntProvider)ConstantInt.m_146483_((int)4), (IntProvider)ConstantInt.m_146483_((int)2)));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> FILLED_HIVE_BLOCK = DreamlandConfiguredFeatures.registerConfiguredFeature("filled_hive_block", Feature.f_65731_, new OreConfiguration(FILLED_HIVE_TARGET_LIST, 10));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> HIVE_IRON = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_iron", Feature.f_65731_, new OreConfiguration(HIVE_IRON_TARGET_LIST, 9));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> HIVE_GOLD = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_gold", Feature.f_65731_, new OreConfiguration(HIVE_GOLD_TARGET_LIST, 4, 0.5f));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> HIVE_REDSTONE = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_redstone", Feature.f_65731_, new OreConfiguration(HIVE_REDSTONE_TARGET_LIST, 8));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> HIVE_LAPIS = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_lapis", Feature.f_65731_, new OreConfiguration(HIVE_LAPIS_TARGET_LIST, 7));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> HIVE_COPPER = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_copper", Feature.f_65731_, new OreConfiguration(HIVE_COPPER_TARGET_LIST, 10));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> HIVE_COPPER_LARGE = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_copper_large", Feature.f_65731_, new OreConfiguration(HIVE_COPPER_TARGET_LIST, 20));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> HIVE_DIAMOND = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_diamond", Feature.f_65731_, new OreConfiguration(HIVE_DIAMOND_TARGET_LIST, 4, 0.5f));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> HIVE_DIAMOND_LARGE = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_diamond_large", Feature.f_65731_, new OreConfiguration(HIVE_DIAMOND_TARGET_LIST, 12, 0.7f));
    public static final Holder<ConfiguredFeature<EllipsoidConfig, ?>> HIVE_CAVE = DreamlandConfiguredFeatures.registerConfiguredFeature("hive_cave", DreamlandFeatures.ELLIPSOID, new EllipsoidConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50627_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50627_), (IntProvider)UniformInt.m_146622_((int)4, (int)16), (IntProvider)UniformInt.m_146622_((int)2, (int)8), (IntProvider)UniformInt.m_146622_((int)2, (int)12)));
    public static final Holder<ConfiguredFeature<SurfaceLake.Configuration, ?>> DROUGHT_BORDERED_DISK = DreamlandConfiguredFeatures.registerConfiguredFeature("bordered_drought_disk", DreamlandFeatures.SURFACE_LAKE, new SurfaceLake.Configuration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)DreamlandBlocks.DROUGHT_SOIL.block().get()).m_49966_()), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)DreamlandBlocks.DRIED_TAR.block().get()).m_49966_())));
    public static final Holder<ConfiguredFeature<DeltaFeatureConfiguration, ?>> TAR_DELTA = DreamlandConfiguredFeatures.registerConfiguredFeature("tar_delta", Feature.f_65748_, new DeltaFeatureConfiguration(((LiquidBlock)DreamlandFluids.TAR_BLOCK.get()).m_49966_(), ((Block)DreamlandBlocks.DRIED_TAR.block().get()).m_49966_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7), (IntProvider)UniformInt.m_146622_((int)1, (int)4)));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> DROUGHT_VEGETATION = DreamlandConfiguredFeatures.registerConfiguredFeature("drought_vegetation", Feature.f_65763_, new RandomPatchConfiguration(48, 6, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50120_.m_49966_(), 10).m_146271_((Object)Blocks.f_50036_.m_49966_(), 40).m_146271_((Object)Blocks.f_50034_.m_49966_(), 50))))));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> TAR_BARK_TREE = DreamlandConfiguredFeatures.registerConfiguredFeature("tar_bark_tree", DreamlandFeatures.TAR_BARK_TREE_FEATURE, new NoneFeatureConfiguration());
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TAR_SPROUTS = DreamlandConfiguredFeatures.registerConfiguredFeature("tar_sprouts", Feature.f_65763_, new RandomPatchConfiguration(48, 4, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.TAR_SPROUTS.block().get()))))));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> TAR_SKELETON = DreamlandConfiguredFeatures.registerConfiguredFeature("tar_skeleton", DreamlandFeatures.TAR_SKELETON, new NoneFeatureConfiguration());
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> TAR_BONE = DreamlandConfiguredFeatures.registerConfiguredFeature("tar_bone", DreamlandFeatures.TAR_BONE, new NoneFeatureConfiguration());
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> TAR_SOIL_ORE = DreamlandConfiguredFeatures.registerConfiguredFeature("tar_soil_ore", Feature.f_65731_, new OreConfiguration(OreFeatures.f_195071_, ((Block)DreamlandBlocks.TAR_MUD.block().get()).m_49966_(), 64));
    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> FOSSILIZED_EGG = DreamlandConfiguredFeatures.registerConfiguredFeature("fossilized_egg", Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.FOSSILIZED_EGG.block().get()))));
    public static final Holder<ConfiguredFeature<HillConfig, ?>> TAR_HILL = DreamlandConfiguredFeatures.registerConfiguredFeature("tar_hill", DreamlandFeatures.NOISE_HILL, new HillConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.DRIED_TAR.block().get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandFluids.TAR_BLOCK.get())), (IntProvider)UniformInt.m_146622_((int)7, (int)10), (IntProvider)UniformInt.m_146622_((int)7, (int)24), (IntProvider)UniformInt.m_146622_((int)7, (int)10), (IntProvider)ConstantInt.m_146483_((int)1), (FloatProvider)ConstantFloat.m_146458_((float)0.1f)));
    public static final Holder<ConfiguredFeature<HillConfig, ?>> DROUGHT_SOIL_HILL = DreamlandConfiguredFeatures.registerConfiguredFeature("drought_soil_hill", DreamlandFeatures.NOISE_HILL, new HillConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.DRIED_TAR.block().get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.DROUGHT_SOIL.block().get())), (IntProvider)UniformInt.m_146622_((int)7, (int)14), (IntProvider)UniformInt.m_146622_((int)7, (int)24), (IntProvider)UniformInt.m_146622_((int)7, (int)14), (IntProvider)ConstantInt.m_146483_((int)1), (FloatProvider)ConstantFloat.m_146458_((float)0.1f)));
    public static final Holder<ConfiguredFeature<LakeFeature.Configuration, ?>> LAKE_TAR = DreamlandConfiguredFeatures.registerConfiguredFeature("lake_tar", Feature.f_65783_, new LakeFeature.Configuration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandFluids.TAR_BLOCK.get())), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_50069_.m_49966_())));
    public static final Holder<ConfiguredFeature<SpringConfiguration, ?>> SPRING_TAR = DreamlandConfiguredFeatures.registerConfiguredFeature("spring_tar", Feature.f_65765_, new SpringConfiguration(((FlowingFluid)DreamlandFluids.TAR_FLUID.get()).m_76145_(), true, 4, 1, (HolderSet)HolderSet.m_205806_(Block::m_204297_, (Object[])new Block[]{Blocks.f_50069_, Blocks.f_50122_, Blocks.f_50228_, Blocks.f_50334_, Blocks.f_152550_, Blocks.f_152496_, Blocks.f_152497_, Blocks.f_50493_})));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> PLUM_BIRCH_TREE = DreamlandConfiguredFeatures.registerConfiguredFeature("plum_birch_tree", DreamlandFeatures.PLUM_BIRCH_TREE_FEATURE, new NoneFeatureConfiguration());
    public static final Holder<ConfiguredFeature<SurfaceLake.Configuration, ?>> PLUM_BIRCH_LAKE = DreamlandConfiguredFeatures.registerConfiguredFeature("plum_birch_lake", DreamlandFeatures.SURFACE_LAKE, new SurfaceLake.Configuration((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)Blocks.f_49990_.m_49966_()), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)DreamlandBlocks.MINERAL_DIRT.block().get()).m_49966_())));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> JEWELED_FOREST_VEGETATION = DreamlandConfiguredFeatures.registerConfiguredFeature("jeweled_forest_vegetation", Feature.f_65763_, new RandomPatchConfiguration(48, 16, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.PINK_CRAB_GRASS.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.PLUM_BIRCH_SHRUB.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.OPALINE_MARIGOLD.block().get()).m_49966_(), 20).m_146271_((Object)Blocks.f_50114_.m_49966_(), 15).m_146271_((Object)Blocks.f_50034_.m_49966_(), 10).m_146271_((Object)Blocks.f_50360_.m_49966_(), 5))))));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> FLOWERING_UNDERGROWTH = DreamlandConfiguredFeatures.registerConfiguredFeature("flowering_undergrowth", Feature.f_65763_, new RandomPatchConfiguration(48, 4, 2, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.FLOWERING_UNDERGROWTH.block().get()))))));
    public static final Holder<ConfiguredFeature<EllipsoidConfig, ?>> CALCITE_ROCK = DreamlandConfiguredFeatures.registerConfiguredFeature("calcite_rock", DreamlandFeatures.ELLIPSOID, new EllipsoidConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152497_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152490_), (IntProvider)UniformInt.m_146622_((int)4, (int)5), (IntProvider)UniformInt.m_146622_((int)5, (int)7), (IntProvider)UniformInt.m_146622_((int)3, (int)5)));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> OPAL_CLUSTER = DreamlandConfiguredFeatures.registerConfiguredFeature("opal_cluster", DreamlandFeatures.OPAL_CLUSTER, new NoneFeatureConfiguration());
    public static final Holder<ConfiguredFeature<ConeConfig, ?>> AMETHYST_ROCK = DreamlandConfiguredFeatures.registerConfiguredFeature("amethyst_rock", DreamlandFeatures.NOISE_CONE, new ConeConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152497_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152490_), (IntProvider)UniformInt.m_146622_((int)5, (int)6), (IntProvider)UniformInt.m_146622_((int)24, (int)25), (FloatProvider)ConstantFloat.m_146458_((float)0.1f)));
    public static final Holder<ConfiguredFeature<BlockColumnConfiguration, ?>> KUNZITE_POINTS_UP = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_points_up", Feature.f_190875_, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.m_191218_((IntProvider)UniformInt.m_146622_((int)0, (int)7), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)DreamlandBlocks.KUNZITE_POINT.block().get()).m_49966_().m_61124_((Property)KunzitePointBlock.FACING, (Comparable)Direction.UP))))), Direction.UP, BlockPredicate.f_190394_, true));
    public static final Holder<ConfiguredFeature<BlockColumnConfiguration, ?>> KUNZITE_POINTS_DOWN = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_points_down", Feature.f_190875_, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.m_191218_((IntProvider)UniformInt.m_146622_((int)0, (int)5), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)DreamlandBlocks.KUNZITE_POINT.block().get()).m_49966_().m_61124_((Property)KunzitePointBlock.FACING, (Comparable)Direction.DOWN))))), Direction.DOWN, BlockPredicate.f_190394_, true));
    public static final Holder<ConfiguredFeature<VegetationPatchConfiguration, ?>> KUNZITE_POINTS_PATCH_UP = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_points_patch_up", Feature.f_159734_, new VegetationPatchConfiguration(DreamlandBlockTags.KUNZITE_ORES_REPLACEABLE, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.KUNZITE_STONE.block().get())), PlacementUtils.m_206506_(KUNZITE_POINTS_UP, (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.m_146483_((int)1), 0.0f, 5, 0.4f, (IntProvider)UniformInt.m_146622_((int)1, (int)3), 0.3f));
    public static final Holder<ConfiguredFeature<VegetationPatchConfiguration, ?>> KUNZITE_POINTS_PATCH_DOWN = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_points_patch_down", Feature.f_159734_, new VegetationPatchConfiguration(DreamlandBlockTags.KUNZITE_ORES_REPLACEABLE, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.KUNZITE_STONE.block().get())), PlacementUtils.m_206506_(KUNZITE_POINTS_DOWN, (PlacementModifier[])new PlacementModifier[0]), CaveSurface.CEILING, (IntProvider)UniformInt.m_146622_((int)1, (int)2), 0.0f, 35, 0.35f, (IntProvider)UniformInt.m_146622_((int)2, (int)4), 0.3f));
    public static final Holder<ConfiguredFeature<BlockColumnConfiguration, ?>> KUNZITE_POINTS_NORTH = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_points_north", Feature.f_190875_, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.m_191218_((IntProvider)UniformInt.m_146622_((int)1, (int)4), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)DreamlandBlocks.KUNZITE_POINT.block().get()).m_49966_().m_61124_((Property)KunzitePointBlock.FACING, (Comparable)Direction.NORTH))))), Direction.NORTH, BlockPredicate.f_190394_, true));
    public static final Holder<ConfiguredFeature<BlockColumnConfiguration, ?>> KUNZITE_POINTS_SOUTH = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_points_south", Feature.f_190875_, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.m_191218_((IntProvider)UniformInt.m_146622_((int)1, (int)4), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)DreamlandBlocks.KUNZITE_POINT.block().get()).m_49966_().m_61124_((Property)KunzitePointBlock.FACING, (Comparable)Direction.SOUTH))))), Direction.SOUTH, BlockPredicate.f_190394_, true));
    public static final Holder<ConfiguredFeature<BlockColumnConfiguration, ?>> KUNZITE_POINTS_EAST = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_points_east", Feature.f_190875_, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.m_191218_((IntProvider)UniformInt.m_146622_((int)1, (int)4), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)DreamlandBlocks.KUNZITE_POINT.block().get()).m_49966_().m_61124_((Property)KunzitePointBlock.FACING, (Comparable)Direction.EAST))))), Direction.EAST, BlockPredicate.f_190394_, true));
    public static final Holder<ConfiguredFeature<BlockColumnConfiguration, ?>> KUNZITE_POINTS_WEST = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_points_west", Feature.f_190875_, new BlockColumnConfiguration(List.of(BlockColumnConfiguration.m_191218_((IntProvider)UniformInt.m_146622_((int)1, (int)4), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)DreamlandBlocks.KUNZITE_POINT.block().get()).m_49966_().m_61124_((Property)KunzitePointBlock.FACING, (Comparable)Direction.WEST))))), Direction.WEST, BlockPredicate.f_190394_, true));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_IRON = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_iron_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_IRON_TARGET_LIST, 9));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_IRON_SMALL = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_iron_small_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_IRON_TARGET_LIST, 4));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_EMERALD = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_emerald_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_EMERALD_TARGET_LIST, 3));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_REDSTONE = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_redstone_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_REDSTONE_TARGET_LIST, 8));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_LAPIS = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_lapis_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_LAPIS_TARGET_LIST, 7));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_COPPER = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_copper_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_COPPER_TARGET_LIST, 10));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_COPPER_LARGE = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_copper_large_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_COPPER_TARGET_LIST, 20));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_DIAMOND = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_diamond_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_DIAMOND_TARGET_LIST, 4, 0.5f));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> KUNZITE_DIAMOND_LARGE = DreamlandConfiguredFeatures.registerConfiguredFeature("kunzite_diamond_large_ore", Feature.f_65731_, new OreConfiguration(KUNZITE_DIAMOND_TARGET_LIST, 12, 0.7f));
    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> GOLDEN_MOSS_VEGETATION = DreamlandConfiguredFeatures.registerConfiguredFeature("golden_moss_vegetation", Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.GOLDEN_MOSS_CARPET.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.GOLD_FRONDS.block().get()).m_49966_(), 25).m_146271_((Object)Blocks.f_50034_.m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.GOLDEN_CAP.block().get()).m_49966_(), 9).m_146271_((Object)((Block)DreamlandBlocks.MIDASHROOM.block().get()).m_49966_(), 1).m_146271_((Object)((Block)DreamlandBlocks.SMALL_GOLDEN_CAP.block().get()).m_49966_(), 15))));
    public static final Holder<ConfiguredFeature<VegetationPatchConfiguration, ?>> GOLDEN_MOSS_PATCH = DreamlandConfiguredFeatures.registerConfiguredFeature("golden_moss_patch", Feature.f_159734_, new VegetationPatchConfiguration(DreamlandBlockTags.KUNZITE_ORES_REPLACEABLE, (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.GOLDEN_MOSS_BLOCK.block().get())), PlacementUtils.m_206506_(GOLDEN_MOSS_VEGETATION, (PlacementModifier[])new PlacementModifier[0]), CaveSurface.FLOOR, (IntProvider)ConstantInt.m_146483_((int)1), 0.2f, 5, 0.8f, (IntProvider)UniformInt.m_146622_((int)4, (int)7), 0.3f));
    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> GOLDEN_CAP = DreamlandConfiguredFeatures.registerConfiguredFeature("golden_cap", Feature.f_65741_, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.GOLDEN_CAP.block().get()).m_49966_(), 95).m_146271_((Object)((Block)DreamlandBlocks.MIDASHROOM.block().get()).m_49966_(), 5))));
    public static final Holder<ConfiguredFeature<GeodeConfiguration, ?>> GOLD_GEODE = DreamlandConfiguredFeatures.registerConfiguredFeature("gold_geode", Feature.f_159728_, new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.GOLD_BEARING_QUARTZITE.block().get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.BUDDING_GOLD.block().get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50472_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152597_), List.of(((Block)DreamlandBlocks.SMALL_GOLD_CLUSTER.block().get()).m_49966_(), ((Block)DreamlandBlocks.MEDIUM_GOLD_CLUSTER.block().get()).m_49966_(), ((Block)DreamlandBlocks.LARGE_GOLD_CLUSTER.block().get()).m_49966_(), ((Block)DreamlandBlocks.GOLD_CLUSTER.block().get()).m_49966_()), BlockTags.f_144287_, BlockTags.f_144289_), new GeodeLayerSettings(1.7, 2.2, 3.2, 5.2), new GeodeCrackSettings(0.95, 2.0, 2), 0.35, 0.083, true, (IntProvider)UniformInt.m_146622_((int)4, (int)6), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)2), -16, 16, 0.05, 1));
    public static final Holder<ConfiguredFeature<ConeConfig, ?>> POROUS_SPIRES = DreamlandConfiguredFeatures.registerConfiguredFeature("porous_spires", DreamlandFeatures.NOISE_CONE, new ConeConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.WHITE_MOLD.block().get())), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.OVERGROWN_POROUS_STONE.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.POROUS_STONE.block().get()).m_49966_(), 75)), (IntProvider)UniformInt.m_146622_((int)5, (int)8), (IntProvider)UniformInt.m_146622_((int)7, (int)10), (FloatProvider)ConstantFloat.m_146458_((float)0.1f)));
    public static final Holder<ConfiguredFeature<SphereConfig, ?>> POROUS_SPHERE = DreamlandConfiguredFeatures.registerConfiguredFeature("porous_sphere", DreamlandFeatures.NOISE_SPHERE, new SphereConfig((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.OVERGROWN_POROUS_STONE.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.POROUS_STONE.block().get()).m_49966_(), 75)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_), (IntProvider)UniformInt.m_146622_((int)16, (int)26), (IntProvider)UniformInt.m_146622_((int)16, (int)26), (FloatProvider)UniformFloat.m_146605_((float)0.07f, (float)0.11f)));
    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> MOLD_PUFF_TREE = DreamlandConfiguredFeatures.registerConfiguredFeature("mold_puff_tree", DreamlandFeatures.MOLD_PUFF_TREE, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.BLACK_MOLD.block().get()).m_49966_(), 50).m_146271_((Object)((Block)DreamlandBlocks.WHITE_MOLD.block().get()).m_49966_(), 50))));
    public static final Holder<ConfiguredFeature<HillConfig, ?>> POROUS_HILL = DreamlandConfiguredFeatures.registerConfiguredFeature("porous_hill", DreamlandFeatures.NOISE_HILL, new HillConfig((BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.PETRIFIED_VEGETATION.block().get())), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50195_), (IntProvider)UniformInt.m_146622_((int)7, (int)8), (IntProvider)UniformInt.m_146622_((int)4, (int)5), (IntProvider)UniformInt.m_146622_((int)7, (int)9), (IntProvider)ConstantInt.m_146483_((int)1), (FloatProvider)ConstantFloat.m_146458_((float)0.1f)));
    public static final Holder<ConfiguredFeature<RandomPatchConfiguration, ?>> TOXIC_JUNGLE_VEGETATION = DreamlandConfiguredFeatures.registerConfiguredFeature("toxic_jungle_vegetation", Feature.f_65763_, new RandomPatchConfiguration(48, 5, 3, PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.SPONGE_PUFF.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.SPORE_PUFF.block().get()).m_49966_(), 15).m_146271_((Object)Blocks.f_50072_.m_49966_(), 10).m_146271_((Object)Blocks.f_50359_.m_49966_(), 15).m_146271_((Object)((Block)DreamlandBlocks.GLOW_FRONDS.block().get()).m_49966_(), 15).m_146271_((Object)((Block)DreamlandBlocks.LARGE_SPORE_PUFF.block().get()).m_49966_(), 20))))));
    public static final Holder<ConfiguredFeature<GrowthLayerConfig, ?>> MOLD_CARPET_STONE = DreamlandConfiguredFeatures.registerConfiguredFeature("mold_carpet_stone", DreamlandFeatures.GROWTH_LAYER, new GrowthLayerConfig((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.BLACK_MOLD_CARPET.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.WHITE_MOLD_CARPET.block().get()).m_49966_(), 75)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.POROUS_STONE.block().get())), (IntProvider)ConstantInt.m_146483_((int)6), (IntProvider)ConstantInt.m_146483_((int)3)));
    public static final Holder<ConfiguredFeature<GrowthLayerConfig, ?>> MOLD_CARPET_DIRT = DreamlandConfiguredFeatures.registerConfiguredFeature("mold_carpet_dirt", DreamlandFeatures.GROWTH_LAYER, new GrowthLayerConfig((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.BLACK_MOLD_CARPET.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.WHITE_MOLD_CARPET.block().get()).m_49966_(), 75)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.TOXIC_GRASS.block().get())), (IntProvider)ConstantInt.m_146483_((int)6), (IntProvider)ConstantInt.m_146483_((int)2)));
    public static final Holder<ConfiguredFeature<GrowthLayerConfig, ?>> MOLD_CARPET_UNDERGROUND = DreamlandConfiguredFeatures.registerConfiguredFeature("mold_carpet_underground", DreamlandFeatures.GROWTH_LAYER, new GrowthLayerConfig((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.BLACK_MOLD_CARPET.block().get()).m_49966_(), 25).m_146271_((Object)((Block)DreamlandBlocks.WHITE_MOLD_CARPET.block().get()).m_49966_(), 75)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.PETRIFIED_VEGETATION.block().get())), (IntProvider)ConstantInt.m_146483_((int)8), (IntProvider)ConstantInt.m_146483_((int)2)));
    public static final Holder<ConfiguredFeature<SimpleBlockConfiguration, ?>> MOLD_GROWTH = DreamlandConfiguredFeatures.registerConfiguredFeature("mold_growth", DreamlandFeatures.MOLD_GROWTH, new SimpleBlockConfiguration((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((Block)DreamlandBlocks.BLACK_MOLD.block().get()).m_49966_(), 50).m_146271_((Object)((Block)DreamlandBlocks.WHITE_MOLD.block().get()).m_49966_(), 50))));
    public static final Holder<ConfiguredFeature<HillConfig, ?>> MOLD_WOOD_STUMP = DreamlandConfiguredFeatures.registerConfiguredFeature("mold_wood_stump", DreamlandFeatures.NOISE_HILL, new HillConfig((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)DreamlandWoodSets.MOLD_WOOD.wood().block().get()).m_49966_()), (BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)DreamlandWoodSets.MOLD_WOOD.strippedLog().block().get()).m_49966_()), (IntProvider)ConstantInt.m_146483_((int)7), (IntProvider)UniformInt.m_146622_((int)6, (int)7), (IntProvider)ConstantInt.m_146483_((int)7), (IntProvider)ConstantInt.m_146483_((int)1), (FloatProvider)ConstantFloat.m_146458_((float)0.1f)));
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> MOLD_WOOD_ROOTS = DreamlandConfiguredFeatures.registerConfiguredFeature("mold_wood_roots", DreamlandFeatures.MOLD_WOOD_ROOTS, new NoneFeatureConfiguration());
    public static final Holder<ConfiguredFeature<NoneFeatureConfiguration, ?>> MOLD_WOOD_TREE = DreamlandConfiguredFeatures.registerConfiguredFeature("mold_wood_tree", DreamlandFeatures.MOLD_WOOD_TREE, new NoneFeatureConfiguration());
    private static final MultifaceBlock GLOW_LICHEN_BLOCK = (MultifaceBlock)Blocks.f_152475_;
    public static final Holder<ConfiguredFeature<MultifaceGrowthConfiguration, ?>> TOXIC_JUNGLE_GLOW_LICHEN = DreamlandConfiguredFeatures.registerConfiguredFeature("toxic_jungle_glow_lichen", Feature.f_225026_, new MultifaceGrowthConfiguration(GLOW_LICHEN_BLOCK, 24, true, true, true, 0.6f, (HolderSet)HolderSet.m_205806_(Block::m_204297_, (Object[])new Block[]{(Block)DreamlandWoodSets.MOLD_WOOD.log().block().get(), (Block)DreamlandWoodSets.MOLD_WOOD.wood().block().get(), (Block)DreamlandBlocks.POROUS_STONE.block().get(), (Block)DreamlandBlocks.OVERGROWN_POROUS_STONE.block().get(), (Block)DreamlandBlocks.PETRIFIED_VEGETATION.block().get(), (Block)DreamlandBlocks.PURE_STONE.block().get()})));
    private static final MultifaceBlock SHELF_VEGETATION_BLOCK = (MultifaceBlock)DreamlandBlocks.SHELF_VEGETATION.block().get();
    public static final Holder<ConfiguredFeature<MultifaceGrowthConfiguration, ?>> SHELF_VEGETATION = DreamlandConfiguredFeatures.registerConfiguredFeature("shelf_vegetation", Feature.f_225026_, new MultifaceGrowthConfiguration(SHELF_VEGETATION_BLOCK, 24, true, true, true, 0.8f, (HolderSet)HolderSet.m_205806_(Block::m_204297_, (Object[])new Block[]{(Block)DreamlandWoodSets.MOLD_WOOD.log().block().get(), (Block)DreamlandWoodSets.MOLD_WOOD.wood().block().get(), (Block)DreamlandBlocks.POROUS_STONE.block().get(), (Block)DreamlandBlocks.OVERGROWN_POROUS_STONE.block().get(), (Block)DreamlandBlocks.PETRIFIED_VEGETATION.block().get()})));
    private static final MultifaceBlock SPORE_NODE_BLOCK = (MultifaceBlock)DreamlandBlocks.SPORE_NODE.block().get();
    public static final Holder<ConfiguredFeature<MultifaceGrowthConfiguration, ?>> SPORE_NODE = DreamlandConfiguredFeatures.registerConfiguredFeature("spore_node", Feature.f_225026_, new MultifaceGrowthConfiguration(SPORE_NODE_BLOCK, 24, true, true, true, 0.9f, (HolderSet)HolderSet.m_205806_(Block::m_204297_, (Object[])new Block[]{(Block)DreamlandWoodSets.MOLD_WOOD.log().block().get(), (Block)DreamlandWoodSets.MOLD_WOOD.wood().block().get(), (Block)DreamlandBlocks.POROUS_STONE.block().get(), (Block)DreamlandBlocks.OVERGROWN_POROUS_STONE.block().get(), (Block)DreamlandBlocks.PETRIFIED_VEGETATION.block().get(), (Block)DreamlandBlocks.TOXIC_DIRT.block().get(), (Block)DreamlandBlocks.WHITE_MOLD.block().get(), (Block)DreamlandBlocks.BLACK_MOLD.block().get()})));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> TOXIC_VEGETATION = DreamlandConfiguredFeatures.registerConfiguredFeature("toxic_vegetation", Feature.f_65731_, new OreConfiguration(TOXIC_JUNGLE_GROUND, ((Block)DreamlandBlocks.TOXIC_VEGETATION.block().get()).m_49966_(), 24));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> DECAYED_VEGETATION = DreamlandConfiguredFeatures.registerConfiguredFeature("decayed_vegetation", Feature.f_65731_, new OreConfiguration(TOXIC_JUNGLE_GROUND, ((Block)DreamlandBlocks.DECAYED_VEGETATION.block().get()).m_49966_(), 16));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> GLOWING_MOLD_WOOD = DreamlandConfiguredFeatures.registerConfiguredFeature("glowing_mold_wood", Feature.f_65731_, new OreConfiguration(GLOWING_MOLD_WOOD_REPLACEABLE, ((Block)DreamlandBlocks.GLOWING_MOLD_WOOD.block().get()).m_49966_(), 24));
    public static final Holder<ConfiguredFeature<DeltaFeatureConfiguration, ?>> TOXIC_JUNGLE_DELTA = DreamlandConfiguredFeatures.registerConfiguredFeature("toxic_jungle_delta", Feature.f_65748_, new DeltaFeatureConfiguration(Blocks.f_49990_.m_49966_(), ((Block)DreamlandBlocks.PURE_STONE.block().get()).m_49966_(), (IntProvider)UniformInt.m_146622_((int)3, (int)7), (IntProvider)UniformInt.m_146622_((int)1, (int)2)));
    public static final Holder<ConfiguredFeature<GrowthLayerConfig, ?>> PURIFIED_DUST_LAYER = DreamlandConfiguredFeatures.registerConfiguredFeature("purified_dust_layer", DreamlandFeatures.GROWTH_LAYER, new GrowthLayerConfig((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((Block)DreamlandBlocks.PURIFIED_DUST.block().get()).m_49966_()), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)DreamlandBlocks.PURE_STONE.block().get())), (IntProvider)ConstantInt.m_146483_((int)4), (IntProvider)ConstantInt.m_146483_((int)3)));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> NECRATHENE_ORE = DreamlandConfiguredFeatures.registerConfiguredFeature("necrathene_ore", Feature.f_65731_, new OreConfiguration(NECRATHENE_REPLACEABLE, ((Block)DreamlandBlocks.NECRATHENE_ORE.block().get()).m_49966_(), 6));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> PURITY_ORE = DreamlandConfiguredFeatures.registerConfiguredFeature("purity_ore", Feature.f_65731_, new OreConfiguration(PURITY_REPLACEABLE, ((Block)DreamlandBlocks.PURITY_ORE.block().get()).m_49966_(), 5));
    public static final Holder<ConfiguredFeature<OreConfiguration, ?>> POROUS_STONE_UNDERGROUND = DreamlandConfiguredFeatures.registerConfiguredFeature("porous_stone_underground", Feature.f_65731_, new OreConfiguration(PETRIFIED_VEGETATION, ((Block)DreamlandBlocks.POROUS_STONE.block().get()).m_49966_(), 32));

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> Holder<ConfiguredFeature<FC, ?>> registerConfiguredFeature(String name, F feature, FC config) {
        DreamlandConfiguredFeatures.createKey(name);
        return BuiltinRegistries.m_206380_((Registry)BuiltinRegistries.f_123861_, (String)DreamlandLoc.createLoc(name).toString(), (Object)new ConfiguredFeature(feature, config));
    }

    private static void createKey(String name) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)DreamlandLoc.createLoc(name));
        KEYS.add(key);
    }

    public static ArrayList<ResourceKey<ConfiguredFeature<?, ?>>> getKeys() {
        return KEYS;
    }
}

