/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.world.biome;

import com.github.dragoni7.dreamland.common.world.biome.DreamlandBiomeFeatures;
import com.github.dragoni7.dreamland.core.registry.DreamlandEntities;
import com.github.dragoni7.dreamland.core.registry.DreamlandParticles;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;

public class DreamlandOverworldBiomes {
    @Nullable
    private static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static Biome biome(Biome.Precipitation precipitation, float temperature, float downfall, BiomeSpecialEffects specialEffects, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(specialEffects).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47592_();
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)builder);
    }

    public static Biome midascaves() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        DreamlandBiomeFeatures.midascavesBiomeFeatures(biomeBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 105, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 10, 1, 4));
        return DreamlandOverworldBiomes.biome(Biome.Precipitation.NONE, 0.7f, 0.0f, new BiomeSpecialEffects.Builder().m_48045_(13082890).m_48043_(13082890).m_48034_(4789140).m_48037_(4789140).m_48019_(4789140).m_48040_(DreamlandOverworldBiomes.calculateSkyColor(0.8f)).m_48027_(AmbientMoodSettings.f_47387_).m_48029_(new AmbientParticleSettings((ParticleOptions)DreamlandParticles.GOLD_GLITTER.get(), 0.001f)).m_48021_(NORMAL_MUSIC).m_48018_(), spawnBuilder, biomeBuilder);
    }

    public static Biome hive() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        DreamlandOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        DreamlandBiomeFeatures.addHiveOres(biomeBuilder);
        DreamlandBiomeFeatures.hiveBiomeFeatures(biomeBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DreamlandEntities.LARVA.get(), 35, 2, 4));
        return DreamlandOverworldBiomes.biome(Biome.Precipitation.NONE, 0.8f, 0.2f, new BiomeSpecialEffects.Builder().m_48034_(12511438).m_48037_(9680288).m_48019_(12638463).m_48040_(DreamlandOverworldBiomes.calculateSkyColor(0.8f)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_(), spawnBuilder, biomeBuilder);
    }

    public static Biome tardeltas() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        DreamlandOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        DreamlandBiomeFeatures.tardeltasBiomeFeatures(biomeBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DreamlandEntities.OOZE.get(), 25, 1, 2));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 10, 1, 4));
        return DreamlandOverworldBiomes.biome(Biome.Precipitation.NONE, 2.0f, 0.0f, new BiomeSpecialEffects.Builder().m_48045_(11334212).m_48043_(11334212).m_48034_(3604469).m_48037_(3604469).m_48019_(12559221).m_48040_(12559221).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(NORMAL_MUSIC).m_48018_(), spawnBuilder, biomeBuilder);
    }

    public static Biome jeweledforest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        DreamlandOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        DreamlandBiomeFeatures.jeweledForestBiomeFeatures(biomeBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)DreamlandEntities.BUMBLE_BEAST.get(), 13, 1, 1));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)DreamlandEntities.OPAL_SHELL.get(), 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 10, 4, 4));
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20555_, 9, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20501_, 95, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20530_, 5, 1, 1));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20524_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 10, 1, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 5, 1, 1));
        return DreamlandOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.6f, 0.6f, new BiomeSpecialEffects.Builder().m_48045_(14370147).m_48034_(4751787).m_48037_(4751787).m_48019_(12875400).m_48040_(12875400).m_48027_(AmbientMoodSettings.f_47387_).m_48029_(new AmbientParticleSettings((ParticleOptions)DreamlandParticles.WHITE_POLLEN.get(), 0.00128f)).m_48021_(NORMAL_MUSIC).m_48018_(), spawnBuilder, biomeBuilder);
    }

    public static Biome toxicjungle() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        DreamlandOverworldBiomes.globalOverworldGeneration(biomeBuilder);
        DreamlandBiomeFeatures.toxicJungleBiomeFeatures(biomeBuilder);
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20479_, 110, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20558_, 110, 4, 4));
        spawnBuilder.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20549_, 10, 8, 8));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 100, 4, 4));
        spawnBuilder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20566_, 10, 1, 4));
        return DreamlandOverworldBiomes.biome(Biome.Precipitation.RAIN, 0.95f, 0.9f, new BiomeSpecialEffects.Builder().m_48045_(2464688).m_48034_(6280390).m_48037_(6280390).m_48019_(5880459).m_48040_(9541304).m_48027_(AmbientMoodSettings.f_47387_).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_175832_, 0.00128f)).m_48021_(NORMAL_MUSIC).m_48018_(), spawnBuilder, biomeBuilder);
    }
}

