/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.items;

import com.github.dragoni7.dreamland.Dreamland;
import com.github.dragoni7.dreamland.core.registry.DreamlandItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.item.GeoArmorItem;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BreatherHelmetArmorItem
extends GeoArmorItem
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public BreatherHelmetArmorItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builder) {
        super(materialIn, slot, builder.m_41491_(Dreamland.DreamlandTab));
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        List slotData = event.getExtraDataOfType(EquipmentSlot.class);
        List stackData = event.getExtraDataOfType(ItemStack.class);
        LivingEntity livingEntity = (LivingEntity)event.getExtraDataOfType(LivingEntity.class).get(0);
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.breather.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        if (livingEntity instanceof ArmorStand) {
            return PlayState.CONTINUE;
        }
        ArrayList<Item> armorList = new ArrayList<Item>(4);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || livingEntity.m_6844_(slot) == null) continue;
            armorList.add(livingEntity.m_6844_(slot).m_41720_());
        }
        boolean isWearing = armorList.contains(DreamlandItems.BREATHER_HELMET.get());
        return isWearing ? PlayState.CONTINUE : PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "BreatherHelmetArmorItemController", 20.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public SoundEvent m_142602_() {
        return SoundEvents.f_11678_;
    }
}

