/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.entities.projectiles;

import com.github.dragoni7.dreamland.common.entities.mobs.OozeEntity;
import com.github.dragoni7.dreamland.core.registry.DreamlandEffects;
import com.github.dragoni7.dreamland.core.registry.DreamlandEntities;
import com.github.dragoni7.dreamland.core.registry.DreamlandParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class TarBall
extends AbstractHurtingProjectile
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.tar_ball.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public TarBall(EntityType<? extends TarBall> type, Level level) {
        super(type, level);
    }

    public TarBall(Level level, LivingEntity entity, double x, double y, double z) {
        super((EntityType)DreamlandEntities.TAR_BALL.get(), entity, x, y, z, level);
    }

    public TarBall(LivingEntity owner, Level level) {
        super((EntityType)DreamlandEntities.TAR_BALL.get(), level);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.f_19853_.f_46443_) {
            Entity entity = hitResult.m_82443_();
            Entity owner = this.m_37282_();
            if (!(entity instanceof OozeEntity)) {
                if (owner instanceof LivingEntity) {
                    entity.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)((LivingEntity)owner)), 2.0f);
                    this.m_19970_((LivingEntity)owner, entity);
                }
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).m_7292_(new MobEffectInstance((MobEffect)DreamlandEffects.TARRED.get(), 40));
                }
            }
        }
    }

    protected ParticleOptions m_5967_() {
        return (ParticleOptions)DreamlandParticles.TAR_BUBBLE.get();
    }

    protected float m_6884_() {
        return 0.95f;
    }

    protected boolean m_5931_() {
        return false;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "TarBall Controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

