/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.entities.mobs;

import com.github.dragoni7.dreamland.Config;
import com.github.dragoni7.dreamland.core.registry.DreamlandEntities;
import com.github.dragoni7.dreamland.core.registry.DreamlandItems;
import com.github.dragoni7.dreamland.util.RollBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class OpalShellEntity
extends Animal
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Integer> OPAL_AMOUNT = SynchedEntityData.m_135353_(OpalShellEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int counter = 0;

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.opal_shell.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.opal_shell.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "OpalShellController", 0.0f, this::predicate));
    }

    public OpalShellEntity(EntityType<? extends OpalShellEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OPAL_AMOUNT, (Object)0);
    }

    public static AttributeSupplier.Builder customAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, (double)0.3f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42410_}), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("OpalAmount", this.getOpalAmount());
        tag.m_128405_("counter", this.counter);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setOpalAmount(tag.m_128451_("OpalAmount"));
        if (tag.m_128441_("counter")) {
            this.counter = tag.m_128451_("counter");
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        int currentAmount = this.getOpalAmount();
        if (currentAmount < 4) {
            if (this.counter == 2400) {
                this.counter = 0;
                this.setOpalAmount(++currentAmount);
            } else if (this.counter < 2400) {
                ++this.counter;
            }
        }
    }

    public static boolean checkOpalShellSpawnRules(EntityType<? extends Animal> entityType, ServerLevelAccessor serverLevel, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        return serverLevel.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && serverLevel.m_45524_(pos, 0) > 8;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        return RollBoolean.roll((Integer)Config.OPAL_SHELL_EXTRA_ROLL.get(), this.f_19796_);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_11834_, 0.15f, 0.6f);
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42410_);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        int currentAmount = this.getOpalAmount();
        if (currentAmount > 0) {
            ItemStack itemstack = player.m_21120_(hand);
            if (itemstack.m_204117_(Tags.Items.SHEARS) && !this.m_6162_()) {
                player.m_216990_(SoundEvents.f_12062_);
                this.setOpalAmount(--currentAmount);
                this.counter = 0;
                Vec3 vec3 = this.m_20182_();
                double d0 = Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.2f, (float)0.2f);
                double d1 = Mth.m_216283_((RandomSource)this.f_19796_, (float)0.3f, (float)0.5f);
                double d2 = Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.2f, (float)0.2f);
                ItemStack opal = new ItemStack((ItemLike)DreamlandItems.OPAL.get());
                if (RollBoolean.roll(8, this.f_19796_).booleanValue()) {
                    opal = new ItemStack((ItemLike)DreamlandItems.PRECIOUS_OPAL.get());
                }
                ItemEntity itemEntity = new ItemEntity(this.f_19853_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), opal, d0, d1, d2);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175830_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
                this.f_19853_.m_7967_((Entity)itemEntity);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return super.m_6071_(player, hand);
        }
        return super.m_6071_(player, hand);
    }

    public int getOpalAmount() {
        return (Integer)this.f_19804_.m_135370_(OPAL_AMOUNT);
    }

    public void setOpalAmount(int amount) {
        this.f_19804_.m_135381_(OPAL_AMOUNT, (Object)amount);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public OpalShellEntity getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return (OpalShellEntity)((EntityType)DreamlandEntities.OPAL_SHELL.get()).m_20615_((Level)level);
    }

    protected float m_6431_(Pose pose, EntityDimensions dimension) {
        return this.m_6162_() ? dimension.f_20378_ * 0.95f : 0.5f;
    }
}

