/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.entities.mobs;

import com.github.dragoni7.dreamland.Config;
import com.github.dragoni7.dreamland.common.entities.projectiles.TarBall;
import com.github.dragoni7.dreamland.core.registry.DreamlandFluids;
import com.github.dragoni7.dreamland.util.RollBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class OozeEntity
extends Monster
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private static final EntityDataAccessor<Boolean> DATA_OOZE_IS_CHARGING = SynchedEntityData.m_135353_(OozeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.ooze.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public OozeEntity(EntityType<? extends OozeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder customAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22278_, 10.0);
    }

    public boolean isOozeCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_OOZE_IS_CHARGING);
    }

    public void setOozeCharging(boolean charging) {
        this.f_19804_.m_135381_(DATA_OOZE_IS_CHARGING, (Object)charging);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_OOZE_IS_CHARGING, (Object)false);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "OozeController", 0.0f, this::predicate));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new OozeShootTarGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 3.0f;
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public static boolean checkOozeSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevel, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        return serverLevel.m_46791_() != Difficulty.PEACEFUL && serverLevel.m_8055_(pos.m_7495_()).m_60713_((Block)DreamlandFluids.TAR_BLOCK.get());
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        RandomSource rand = this.m_217043_();
        if (spawnReason == MobSpawnType.SPAWNER) {
            return true;
        }
        return RollBoolean.roll((Integer)Config.OOZE_EXTRA_ROLL.get(), rand);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12388_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12386_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12385_;
    }

    static class OozeShootTarGoal
    extends Goal {
        private final OozeEntity ooze;
        public int chargeTime;

        public OozeShootTarGoal(OozeEntity ooze) {
            this.ooze = ooze;
        }

        public void m_8056_() {
            this.chargeTime = 0;
        }

        public void m_8041_() {
            this.ooze.setOozeCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            return this.ooze.m_5448_() != null;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.ooze.m_5448_();
            if (livingentity != null) {
                this.ooze.m_21563_().m_148051_((Entity)livingentity);
                if (livingentity.m_20280_((Entity)this.ooze) < 2048.0 && this.ooze.m_142582_((Entity)livingentity)) {
                    Level level = this.ooze.f_19853_;
                    ++this.chargeTime;
                    if (this.chargeTime == 55) {
                        level.m_5898_((Player)null, 1018, this.ooze.m_20183_(), 0);
                    }
                    if (this.chargeTime == 60) {
                        Vec3 vec3 = this.ooze.m_20252_(1.0f);
                        double d2 = livingentity.m_20185_() - (this.ooze.m_20185_() + vec3.f_82479_);
                        double d3 = livingentity.m_20227_(0.5) - (0.5 + this.ooze.m_20227_(0.5));
                        double d4 = livingentity.m_20189_() - (this.ooze.m_20189_() + vec3.f_82481_);
                        TarBall tarball = new TarBall(level, (LivingEntity)this.ooze, d2, d3, d4);
                        tarball.m_6034_(this.ooze.m_20185_() + vec3.f_82479_, this.ooze.m_20227_(0.5) + 0.5, this.ooze.m_20189_() + vec3.f_82481_);
                        level.m_7967_((Entity)tarball);
                        this.chargeTime = -160;
                    }
                } else if (this.chargeTime > 0) {
                    --this.chargeTime;
                }
                this.ooze.setOozeCharging(this.chargeTime > 40);
            }
        }
    }
}

