/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.entities.mobs;

import com.github.dragoni7.dreamland.Config;
import com.github.dragoni7.dreamland.core.registry.DreamlandSoundEvents;
import com.github.dragoni7.dreamland.util.RollBoolean;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class LarvaEntity
extends Monster
implements IAnimatable,
NeutralMob {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private UUID persistentAngerTarget;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(LarvaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(LarvaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)3, (int)5);

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.f_20890_ || (double)this.m_21223_() < 0.01 || this.m_21224_()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.larva.death", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (this.f_19797_ < 20) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.larva.spawn", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (event.isMoving() && this.f_19797_ > 20) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.larva.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.f_19797_ > 20) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.larva.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "LarvaController", 0.0f, this::predicate));
    }

    public LarvaEntity(EntityType<? extends LarvaEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public static AttributeSupplier.Builder customAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 1.5).m_22268_(Attributes.f_22288_, 2.0).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new LarvaAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21346_.m_25352_(1, (Goal)new LarvaHurtByOtherGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new LarvaBecomeAngryTargetGoal(this));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected PathNavigation m_6037_(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public void m_7380_(CompoundTag tag) {
        this.m_21678_(tag);
    }

    public void m_7378_(CompoundTag tag) {
        this.m_147285_(this.f_19853_, tag);
    }

    protected void m_8024_() {
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, false);
        }
    }

    public static boolean checkLarvaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverLevel, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        return serverLevel.m_46791_() != Difficulty.PEACEFUL;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        RandomSource rand = this.m_217043_();
        if (spawnReason == MobSpawnType.SPAWNER) {
            return true;
        }
        return RollBoolean.roll((Integer)Config.LARVA_EXTRA_ROLL.get(), rand);
    }

    protected void playStepSound() {
        this.m_5496_(SoundEvents.f_12435_, 1.0f, 1.5f);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DreamlandSoundEvents.LARVA_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)DreamlandSoundEvents.LARVA_HIT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DreamlandSoundEvents.LARVA_DIE.get();
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 0.5f;
    }

    public boolean m_6673_(DamageSource source) {
        return source == DamageSource.f_19310_ || source == DamageSource.f_19322_ || super.m_6673_(source);
    }

    public boolean m_142535_(float p_148750_, float p_148751_, DamageSource p_148752_) {
        return false;
    }

    protected void m_7840_(double p_27754_, boolean p_27755_, BlockState p_27756_, BlockPos p_27757_) {
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_21673_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_21673_);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID id) {
        this.persistentAngerTarget = id;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    class LarvaAttackGoal
    extends MeleeAttackGoal {
        public LarvaAttackGoal(LarvaEntity larvaEntity) {
            super((PathfinderMob)larvaEntity, 1.4, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_() && LarvaEntity.this.m_21660_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.f_25540_.m_20160_() && LarvaEntity.this.m_21660_();
        }

        protected double m_6639_(LivingEntity entity) {
            return 4.0f + entity.m_20205_();
        }
    }

    class LarvaHurtByOtherGoal
    extends HurtByTargetGoal {
        LarvaHurtByOtherGoal(LarvaEntity larva) {
            super((PathfinderMob)larva, new Class[0]);
        }

        public boolean m_8045_() {
            return LarvaEntity.this.m_21660_() && super.m_8045_();
        }
    }

    static class LarvaBecomeAngryTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        LarvaBecomeAngryTargetGoal(LarvaEntity larvaEntity) {
            super((Mob)larvaEntity, LivingEntity.class, 10, false, false, arg_0 -> ((LarvaEntity)larvaEntity).m_21674_(arg_0));
        }

        public boolean m_8036_() {
            return this.larvaCanTarget() && super.m_8036_();
        }

        public boolean m_8045_() {
            boolean flag = this.larvaCanTarget();
            if (flag && this.f_26135_.m_5448_() != null) {
                return super.m_8045_();
            }
            this.f_26137_ = null;
            return false;
        }

        private boolean larvaCanTarget() {
            LarvaEntity larvaEntity = (LarvaEntity)this.f_26135_;
            return larvaEntity.m_21660_();
        }
    }
}

