/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.entities.mobs;

import com.github.dragoni7.dreamland.Config;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.util.RollBoolean;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BumbleBeastEntity
extends Animal
implements IAnimatable,
NeutralMob {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private UUID persistentAngerTarget;
    private static final Item EXCHANGE_ITEM = Items.f_42788_;
    private static final EntityDataAccessor<Boolean> HAS_HONEY = SynchedEntityData.m_135353_(BumbleBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(BumbleBeastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int counter = 0;
    private int honeyAmount = 0;

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bumble_beast.walk", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.bumble_beast.idle", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "BumbleBeastController", 0.0f, this::predicate));
    }

    public BumbleBeastEntity(EntityType<? extends BumbleBeastEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.f_21342_ = new MoveControl((Mob)this);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 16.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(HAS_HONEY, (Object)false);
    }

    public static AttributeSupplier.Builder customAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22288_, 3.0).m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22278_, 4.0).m_22268_(Attributes.f_22284_, 3.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BumbleBeastAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21346_.m_25352_(1, (Goal)new BumbleBeastHurtByOtherGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new BumbleBeastBecomeAngryTargetGoal(this));
        this.f_21346_.m_25352_(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void m_7380_(CompoundTag tag) {
        this.m_21678_(tag);
        tag.m_128379_("HasHoney", this.hasHoney());
    }

    public void m_7378_(CompoundTag tag) {
        this.m_147285_(this.f_19853_, tag);
        this.setHasHoney(tag.m_128471_("HasHoney"));
    }

    protected void m_8024_() {
        if (!this.f_19853_.f_46443_) {
            this.m_21666_((ServerLevel)this.f_19853_, false);
        }
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.honeyAmount < 3) {
            if (this.counter == 4800) {
                this.setHasHoney(true);
                ++this.honeyAmount;
                this.counter = 0;
            } else if (this.counter < 4800) {
                ++this.counter;
            }
        }
    }

    public static boolean checkBumbleBeastSpawnRules(EntityType<? extends PathfinderMob> entityType, ServerLevelAccessor serverLevel, MobSpawnType spawnType, BlockPos pos, RandomSource rand) {
        return serverLevel.m_46791_() != Difficulty.PEACEFUL;
    }

    public boolean m_5545_(LevelAccessor level, MobSpawnType spawnReason) {
        RandomSource rand = this.m_217043_();
        if (spawnReason == MobSpawnType.SPAWNER) {
            return true;
        }
        return RollBoolean.roll((Integer)Config.BUMBLE_BEAST_EXTRA_ROLL.get(), rand);
    }

    protected void playStepSound() {
        this.m_5496_(SoundEvents.f_12435_, 1.0f, 0.6f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11698_;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11741_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11740_;
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected float m_6431_(Pose pose, EntityDimensions entityDimensions) {
        return 1.25f;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_19360_() || super.m_6673_(source);
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.hasHoney()) {
            if (itemstack.m_150930_(Items.f_42590_) && !this.m_6162_()) {
                player.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
                ItemStack itemstack1 = ItemUtils.m_41813_((ItemStack)itemstack, (Player)player, (ItemStack)Items.f_42787_.m_7968_());
                player.m_21008_(hand, itemstack1);
                this.counter = 0;
                --this.honeyAmount;
                if (this.honeyAmount == 0) {
                    this.setHasHoney(false);
                }
                if (RollBoolean.roll(6, this.f_19796_).booleanValue()) {
                    this.m_6710_((LivingEntity)player);
                }
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return super.m_6071_(player, hand);
        }
        if (itemstack.m_150930_(EXCHANGE_ITEM)) {
            ItemStack returnStack = itemstack.m_41777_();
            returnStack.m_41764_(itemstack.m_41613_() - 1);
            player.m_21008_(hand, returnStack);
            Vec3 vec3 = this.m_20182_();
            double d0 = Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.2f, (float)0.2f);
            double d1 = Mth.m_216283_((RandomSource)this.f_19796_, (float)0.3f, (float)0.7f);
            double d2 = Mth.m_216283_((RandomSource)this.f_19796_, (float)-0.2f, (float)0.2f);
            ItemEntity itemEntity = new ItemEntity(this.f_19853_, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), new ItemStack((ItemLike)DreamlandBlocks.BUMBLE_BLOCK.item().get()), d0, d1, d2);
            this.m_5496_(SoundEvents.f_11788_, 1.0f, 0.5f);
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123780_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            this.f_19853_.m_7967_((Entity)itemEntity);
        }
        return super.m_6071_(player, hand);
    }

    public boolean hasHoney() {
        return (Boolean)this.f_19804_.m_135370_(HAS_HONEY);
    }

    public void setHasHoney(boolean value) {
        this.f_19804_.m_135381_(HAS_HONEY, (Object)value);
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int time) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)time);
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID id) {
        this.persistentAngerTarget = id;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    class BumbleBeastAttackGoal
    extends MeleeAttackGoal {
        public BumbleBeastAttackGoal(BumbleBeastEntity entity) {
            super((PathfinderMob)entity, 1.4, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_() && BumbleBeastEntity.this.m_21660_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && !this.f_25540_.m_20160_() && BumbleBeastEntity.this.m_21660_();
        }

        protected double m_6639_(LivingEntity entity) {
            return 11.0f + entity.m_20205_();
        }
    }

    class BumbleBeastHurtByOtherGoal
    extends HurtByTargetGoal {
        BumbleBeastHurtByOtherGoal(BumbleBeastEntity entity) {
            super((PathfinderMob)entity, new Class[0]);
        }

        public boolean m_8045_() {
            return BumbleBeastEntity.this.m_21660_() && super.m_8045_();
        }
    }

    static class BumbleBeastBecomeAngryTargetGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        BumbleBeastBecomeAngryTargetGoal(BumbleBeastEntity entity) {
            super((Mob)entity, LivingEntity.class, 10, false, false, arg_0 -> ((BumbleBeastEntity)entity).m_21674_(arg_0));
        }

        public boolean m_8036_() {
            return this.canTarget() && super.m_8036_();
        }

        public boolean m_8045_() {
            boolean flag = this.canTarget();
            if (flag && this.f_26135_.m_5448_() != null) {
                return super.m_8045_();
            }
            this.f_26137_ = null;
            return false;
        }

        private boolean canTarget() {
            BumbleBeastEntity entity = (BumbleBeastEntity)this.f_26135_;
            return entity.m_21660_();
        }
    }
}

