/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.blocks.tiles;

import com.github.dragoni7.dreamland.core.registry.DreamlandTiles;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class OpalDiffuserTile
extends BlockEntity {
    private ItemStackHandler itemHandler = this.createHandler();
    private LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    private boolean isDiffusing = false;
    private int duration;
    private int counter;
    private int color;

    public OpalDiffuserTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)DreamlandTiles.OPAL_DIFFUSER.get(), pos, state);
    }

    public void tickServer() {
        ItemStack stack = this.itemHandler.getStackInSlot(0).m_41777_();
        if (stack.m_41720_() == Items.f_42589_) {
            this.color = PotionUtils.m_43575_((ItemStack)stack);
            List effects = PotionUtils.m_43547_((ItemStack)stack);
            BlockPos pos = this.m_58899_();
            if (!this.isDiffusing) {
                Item.m_41393_((Item)stack.m_41720_());
                for (MobEffectInstance effect : effects) {
                    if (effect.m_19557_() <= this.duration) continue;
                    this.duration = effect.m_19557_();
                }
                this.setDiffusing(true);
                this.counter = 0;
            } else if (this.counter <= this.duration) {
                List entities;
                if (this.counter % 40 == 0 && !(entities = this.f_58857_.m_45976_(LivingEntity.class, new AABB(pos).m_82400_(5.0))).isEmpty() && !effects.isEmpty()) {
                    for (LivingEntity entity : entities) {
                        for (MobEffectInstance effect : effects) {
                            MobEffectInstance effectToApply = new MobEffectInstance(effect);
                            Boolean hasEffect = entity.m_21023_(effectToApply.m_19544_());
                            if (hasEffect.booleanValue()) continue;
                            entity.m_7292_(effectToApply);
                        }
                    }
                }
                ++this.counter;
            } else {
                this.itemHandler.extractItem(0, 1, false);
                this.setDiffusing(false);
                this.counter = 0;
                this.duration = 0;
                this.m_6596_();
            }
        }
    }

    private void setDiffusing(boolean value) {
        if (!value) {
            this.color = 0;
        }
        this.isDiffusing = value;
        BlockState blockstate = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61428_, (Comparable)Boolean.valueOf(value)), 3);
        this.f_58857_.m_7260_(this.f_58858_, blockstate, blockstate, 2);
    }

    public int getColor() {
        return this.color;
    }

    public void m_7651_() {
        super.m_7651_();
        this.handler.invalidate();
    }

    public void m_142466_(CompoundTag tag) {
        if (tag.m_128441_("inv")) {
            this.itemHandler.deserializeNBT(tag.m_128469_("inv"));
        }
        this.isDiffusing = tag.m_128471_("isDiffusing");
        this.duration = tag.m_128451_("duration");
        this.counter = tag.m_128451_("counter");
        this.color = tag.m_128451_("color");
        super.m_142466_(tag);
    }

    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        tag.m_128379_("isDiffusing", this.isDiffusing);
        tag.m_128405_("duration", this.duration);
        tag.m_128405_("counter", this.counter);
        tag.m_128405_("color", this.color);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        tag.m_128405_("color", this.color);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                OpalDiffuserTile.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() == Items.f_42589_;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.m_41720_() != Items.f_42589_) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }
}

