/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.blocks;

import com.github.dragoni7.dreamland.Config;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandEffects;
import com.github.dragoni7.dreamland.core.registry.DreamlandParticles;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.github.dragoni7.dreamland.data.DreamlandBlockTags;
import com.github.dragoni7.dreamland.data.DreamlandItemTags;
import com.github.dragoni7.dreamland.network.Networking;
import com.github.dragoni7.dreamland.network.PacketUpateSporeNode;
import com.github.dragoni7.dreamland.util.RollBoolean;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SporeNodeBlock
extends MultifaceBlock {
    public static final BooleanProperty IS_SPORING = BlockStateProperties.f_61428_;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);
    private static final VoxelShape UP_AABB = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape DOWN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    private static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> SHAPE_BY_DIRECTION = (Map)Util.m_137469_((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH_AABB);
        map.put(Direction.EAST, EAST_AABB);
        map.put(Direction.SOUTH, SOUTH_AABB);
        map.put(Direction.WEST, WEST_AABB);
        map.put(Direction.UP, UP_AABB);
        map.put(Direction.DOWN, DOWN_AABB);
    });
    private final ImmutableMap<BlockState, VoxelShape> shapesCache = this.m_152458_(SporeNodeBlock::calculateMultifaceShape);

    public SporeNodeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)IS_SPORING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (!((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && state.m_61143_((Property)IS_SPORING) == Boolean.valueOf(true)) {
            if (((Boolean)state.m_61143_((Property)SporeNodeBlock.m_153933_((Direction)Direction.DOWN))).booleanValue() && level.m_8055_(pos.m_7494_()).m_60795_()) {
                for (int i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, 1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, 1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, 1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, 1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 0.0, 1.0, 0.0);
                }
            } else if (((Boolean)state.m_61143_((Property)SporeNodeBlock.m_153933_((Direction)Direction.UP))).booleanValue() && level.m_8055_(pos.m_7495_()).m_60795_()) {
                for (int i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() - 0.25, (double)pos.m_123343_() + rand.m_188500_(), 1.0, -1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() - 0.25, (double)pos.m_123343_() + rand.m_188500_(), 1.0, -1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() - 0.25, (double)pos.m_123343_() + rand.m_188500_(), -1.0, -1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() - 0.25, (double)pos.m_123343_() + rand.m_188500_(), -1.0, -1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() - 0.25, (double)pos.m_123343_() + rand.m_188500_(), 0.0, -1.0, 0.0);
                }
            } else if (((Boolean)state.m_61143_((Property)SporeNodeBlock.m_153933_((Direction)Direction.NORTH))).booleanValue() && level.m_8055_(pos.m_122019_()).m_60795_()) {
                for (int i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, 1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, -1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, 1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, -1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 0.0, 0.0, 1.0);
                }
            } else if (((Boolean)state.m_61143_((Property)SporeNodeBlock.m_153933_((Direction)Direction.SOUTH))).booleanValue() && level.m_8055_(pos.m_122012_()).m_60795_()) {
                for (int i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, 1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, -1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, 1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, -1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 0.0, 0.0, -1.0);
                }
            } else if (((Boolean)state.m_61143_((Property)SporeNodeBlock.m_153933_((Direction)Direction.WEST))).booleanValue() && level.m_8055_(pos.m_122029_()).m_60795_()) {
                for (int i = 0; i < 3; ++i) {
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, 1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, 1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, -1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, -1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), 1.0, 0.0, 0.0);
                }
            } else if (((Boolean)state.m_61143_((Property)SporeNodeBlock.m_153933_((Direction)Direction.EAST))).booleanValue() && level.m_8055_(pos.m_122024_()).m_60795_()) {
                for (int i = 0; i < 4; ++i) {
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, 1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, 1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, -1.0, 1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, -1.0, -1.0);
                    level.m_7106_((ParticleOptions)DreamlandParticles.MOLD_SPORES.get(), (double)pos.m_123341_() + rand.m_188500_(), (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + rand.m_188500_(), -1.0, 0.0, 0.0);
                }
            } else {
                return;
            }
            level.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12032_, SoundSource.BLOCKS, 0.5f, 0.025f, false);
            Networking.sendToServer(new PacketUpateSporeNode(pos));
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.m_61143_((Property)IS_SPORING) == Boolean.valueOf(false)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)IS_SPORING, (Comparable)Boolean.valueOf(true)));
            List list = level.m_45976_(LivingEntity.class, new AABB(pos).m_82377_(1.0, 1.0, 1.0));
            if (!list.isEmpty()) {
                for (LivingEntity entity : list) {
                    ItemStack helmet = entity.m_6844_(EquipmentSlot.HEAD).m_41777_();
                    if (helmet.m_204117_(DreamlandItemTags.PREVENTS_DECAY)) continue;
                    entity.m_7292_(new MobEffectInstance((MobEffect)DreamlandEffects.DECAY.get(), 200));
                }
            }
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    if (x == 0 || z == 0 || !RollBoolean.roll(6, random).booleanValue()) continue;
                    BlockPos currentPos = pos.m_7918_(x, -1, z);
                    BlockState target = level.m_8055_(currentPos);
                    if (!((Boolean)Config.SPORE_NODE_SPREAD.get()).booleanValue()) continue;
                    if (target.m_204336_(BlockTags.f_13106_)) {
                        level.m_46961_(currentPos, false);
                        level.m_7731_(currentPos, ((Block)DreamlandWoodSets.MOLD_WOOD.log().block().get()).m_49966_(), 3);
                        continue;
                    }
                    if (!target.m_204336_(DreamlandBlockTags.MOLD_SPREADABLES) || target.m_204336_(DreamlandBlockTags.TOXIC_JUNGLE_GROUND_BLOCKS) || target.m_60713_((Block)DreamlandWoodSets.MOLD_WOOD.log().block().get()) || target.m_60713_((Block)DreamlandWoodSets.MOLD_WOOD.wood().block().get())) continue;
                    level.m_46961_(currentPos, false);
                    level.m_7731_(currentPos, ((Block)DreamlandBlocks.WHITE_MOLD.block().get()).m_49966_(), 3);
                }
            }
        }
    }

    public void updateSporing(ServerLevel level, BlockPos pos, BlockState state) {
        this.m_49966_();
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)IS_SPORING, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.shapesCache.get((Object)state);
    }

    private static VoxelShape calculateMultifaceShape(BlockState p_153959_) {
        VoxelShape voxelshape = Shapes.m_83040_();
        for (Direction direction : f_153806_) {
            if (!SporeNodeBlock.m_153900_((BlockState)p_153959_, (Direction)direction)) continue;
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)SHAPE_BY_DIRECTION.get(direction));
        }
        return voxelshape.m_83281_() ? Shapes.m_83144_() : voxelshape;
    }

    public BlockState m_7417_(BlockState state1, Direction direction, BlockState state2, LevelAccessor level, BlockPos pos1, BlockPos pos2) {
        if (((Boolean)state1.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos1, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state1, direction, state2, level, pos1, pos2);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter blockGetter, BlockPos pos) {
        return state.m_60819_().m_76178_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED}).m_61104_(new Property[]{IS_SPORING});
    }

    public MultifaceSpreader m_213612_() {
        return this.spreader;
    }
}

