/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.blocks;

import com.github.dragoni7.dreamland.common.blocks.tiles.OpalDiffuserTile;
import com.mojang.math.Vector3f;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class OpalDiffuserBlock
extends Block
implements EntityBlock {
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)8.0, (double)11.0)});
    public static final BooleanProperty IS_DIFFUSING = BlockStateProperties.f_61428_;

    public OpalDiffuserBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)IS_DIFFUSING, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61428_)).booleanValue()) {
            BlockEntity tile = level.m_7702_(pos);
            int color = 0;
            if (tile instanceof OpalDiffuserTile) {
                color = ((OpalDiffuserTile)tile).getColor();
            }
            if (color > 0) {
                float b = color % 256;
                float g = ((float)color - b) / 256.0f % 256.0f;
                float r = ((float)color - b) / (float)Mth.m_144944_((int)256) - g / 256.0f;
                level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(r / 255.0f, g / 255.0f, b / 255.0f), 1.0f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.75 + rand.m_188500_(), (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new OpalDiffuserTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.m_5776_()) {
            return null;
        }
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof OpalDiffuserTile) {
                OpalDiffuserTile tile = (OpalDiffuserTile)t;
                tile.tickServer();
            }
        };
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (!world.f_46443_ && state.m_61143_((Property)BlockStateProperties.f_61428_) == Boolean.valueOf(false)) {
            ItemStack item;
            BlockEntity tileEntity = world.m_7702_(pos);
            if (tileEntity instanceof OpalDiffuserTile && (item = player.m_21120_(hand)).m_150930_(Items.f_42589_)) {
                tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(h -> player.m_21008_(hand, ItemHandlerHelper.insertItem((IItemHandler)h, (ItemStack)item, (boolean)false)));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IS_DIFFUSING});
    }
}

