/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.blocks;

import com.github.dragoni7.dreamland.Config;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandParticles;
import com.github.dragoni7.dreamland.data.DreamlandItemTags;
import com.github.dragoni7.dreamland.util.RollBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MidashroomBlock
extends Block {
    public static final BooleanProperty IS_FERTILIZING = BlockStateProperties.f_61428_;
    protected static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)27.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.25, (double)0.0, (double)16.0, (double)0.25, (double)16.0), Block.m_49796_((double)0.0, (double)27.0, (double)0.0, (double)16.0, (double)32.0, (double)16.0)});

    public MidashroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)IS_FERTILIZING, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (state.m_61143_((Property)IS_FERTILIZING) == Boolean.valueOf(true)) {
            for (int x = 0; x <= 2; ++x) {
                for (int z = 0; z <= 2; ++z) {
                    MidashroomBlock.spawnActiveParticles(level, pos.m_7637_((double)x, 0.2, (double)z));
                    MidashroomBlock.spawnActiveParticles(level, pos.m_7637_((double)(-x), 0.2, (double)z));
                    MidashroomBlock.spawnActiveParticles(level, pos.m_7637_((double)x, 0.2, (double)(-z)));
                    MidashroomBlock.spawnActiveParticles(level, pos.m_7637_((double)(-x), 0.2, (double)(-z)));
                }
            }
        }
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (state.m_61143_((Property)IS_FERTILIZING) == Boolean.valueOf(true)) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    BonemealableBlock bonemealable;
                    BlockPos currentPos = pos.m_7918_(x, 0, z);
                    BlockState target = level.m_8055_(currentPos);
                    if (!(target.m_60734_() instanceof BonemealableBlock) || !(bonemealable = (BonemealableBlock)target.m_60734_()).m_7370_((BlockGetter)level, currentPos, target, false) || !bonemealable.m_214167_((Level)level, random, currentPos, target)) continue;
                    if (RollBoolean.roll((Integer)Config.MIDASHROOM_GOLD_CONVERSION_CHANCE.get(), random).booleanValue()) {
                        level.m_46961_(currentPos, true);
                        switch (random.m_216332_(0, 3)) {
                            case 0: {
                                level.m_7731_(currentPos, ((Block)DreamlandBlocks.GOLD_CLUSTER.block().get()).m_49966_(), 12);
                            }
                            case 1: {
                                level.m_7731_(currentPos, ((Block)DreamlandBlocks.GOLDEN_MOSS_BLOCK.block().get()).m_49966_(), 12);
                            }
                            case 2: {
                                level.m_7731_(currentPos, Blocks.f_152600_.m_49966_(), 12);
                            }
                            case 3: {
                                level.m_7731_(currentPos, ((Block)DreamlandBlocks.GOLD_FRONDS.block().get()).m_49966_(), 12);
                            }
                        }
                        continue;
                    }
                    bonemealable.m_214148_(level, random, currentPos, target);
                }
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)IS_FERTILIZING, (Comparable)Boolean.valueOf(false)));
        }
    }

    private static void spawnActiveParticles(Level level, BlockPos pos) {
        ParticleOptions particleoptions = (ParticleOptions)DreamlandParticles.MIDASHROOM_SPORES.get();
        RandomSource random = level.m_213780_();
        int amount = random.m_188503_(3);
        for (int i = 0; i < 1 + amount; ++i) {
            double d0 = random.m_188583_() * 0.04;
            double d1 = random.m_188583_() * 0.04;
            double d2 = random.m_188583_() * 0.04;
            level.m_7106_(particleoptions, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + 1.0 + random.m_188500_(), (double)pos.m_123343_() + random.m_188500_(), d0, d1, d2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (!world.f_46443_ && state.m_61143_((Property)IS_FERTILIZING) == Boolean.valueOf(false)) {
            ItemStack item = player.m_21120_(hand).m_41777_();
            if (item.m_204117_(DreamlandItemTags.MIDASHROOM_CONSUMABLES)) {
                item.m_41774_(1);
                player.m_21008_(hand, item);
                world.m_46597_(pos, (BlockState)state.m_61124_((Property)IS_FERTILIZING, (Comparable)Boolean.valueOf(true)));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IS_FERTILIZING});
    }
}

