/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.blocks;

import com.github.dragoni7.dreamland.common.blocks.HiveMembraneBlock;
import com.github.dragoni7.dreamland.common.blocks.LarvaAngerableBlock;
import com.github.dragoni7.dreamland.common.items.HiveJellyItem;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class HiveWeaverBlock
extends LarvaAngerableBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61409_;
    public static final int MAX_LEVEL = 7;

    public HiveWeaverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack item = player.m_21120_(hand);
        if (!item.m_41619_() && item.m_41720_() instanceof HiveJellyItem && this.getLevel(state) < 7) {
            int i = this.getLevel(state) + 1;
            if (!level.f_46443_) {
                item.m_41764_(item.m_41613_() - 1);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(i)));
                this.buildMembrane(state, level, pos);
                level.m_5594_((Player)null, pos, SoundEvents.f_144178_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (level.f_46443_ && i < 7) {
                HiveWeaverBlock.spawnSuccessParticles(state, level, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private void buildMembrane(BlockState state, Level level, BlockPos pos) {
        int radius = this.getLevel(state) + 1;
        Direction direction = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockState membrane = ((Block)DreamlandBlocks.HIVE_MEMBRANE.block().get()).m_49966_();
        Boolean xSearch = direction == Direction.NORTH || direction == Direction.SOUTH;
        for (int i = -radius; i <= radius; ++i) {
            for (int y = -radius; y <= radius; ++y) {
                boolean canPlace;
                BlockPos membranePos = xSearch != false ? pos.m_7918_(i, y, 0) : pos.m_7918_(0, y, i);
                boolean bl = canPlace = pos.m_203198_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) <= (double)radius;
                if (!canPlace || !level.m_46859_(membranePos)) continue;
                level.m_7731_(membranePos, membrane, 3);
            }
        }
    }

    public IntegerProperty getLevelProperty() {
        return LEVEL;
    }

    protected int getLevel(BlockState state) {
        return (Integer)state.m_61143_((Property)this.getLevelProperty());
    }

    private static void spawnSuccessParticles(BlockState state, Level level, BlockPos pos) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        RandomSource random = level.m_213780_();
        for (int i = 0; i < 4; ++i) {
            double d0 = random.m_188583_() * 0.02;
            double d1 = random.m_188583_() * 0.02;
            double d2 = random.m_188583_() * 0.02;
            level.m_7106_((ParticleOptions)particleoptions, (double)pos.m_123341_() + random.m_188500_(), (double)pos.m_123342_() + 0.5 + random.m_188500_(), (double)pos.m_123343_() + 1.2, d0, d1, d2);
        }
    }

    @Override
    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack itemStack) {
        super.m_6240_(level, player, pos, state, blockEntity, itemStack);
        BlockState disconnect = (BlockState)((Block)DreamlandBlocks.HIVE_MEMBRANE.block().get()).m_49966_().m_61124_((Property)HiveMembraneBlock.CONNECTED, (Comparable)Boolean.valueOf(false));
        ArrayList<BlockPos> membranes = this.searchBlocks(state, pos, level);
        if (membranes != null) {
            for (BlockPos membranePos : membranes) {
                level.m_46597_(membranePos, disconnect);
            }
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{LEVEL});
    }

    private ArrayList<BlockPos> searchBlocks(BlockState state, BlockPos pos, Level level) {
        Direction direction = (Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        BlockPos checkPos = pos;
        int radius = this.getLevel(state) + 1;
        ArrayList<BlockPos> matches = new ArrayList<BlockPos>();
        Boolean xSearch = direction == Direction.NORTH || direction == Direction.SOUTH;
        for (int i = -radius; i <= 7; ++i) {
            for (int y = -radius; y <= 7; ++y) {
                checkPos = xSearch != false ? pos.m_7918_(i, y, 0) : pos.m_7918_(0, y, i);
                if (!level.m_8055_(checkPos).m_60713_((Block)DreamlandBlocks.HIVE_MEMBRANE.block().get())) continue;
                matches.add(checkPos);
            }
        }
        return matches;
    }
}

