/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland.common.blocks;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LayerLightEngine;

public abstract class DreamlandSpreadingGrassBlock
extends Block
implements BonemealableBlock {
    private Supplier<Block> dirt;

    public DreamlandSpreadingGrassBlock(BlockBehaviour.Properties blockProperties, Supplier<Block> spreadableBlock) {
        super(blockProperties);
        this.dirt = spreadableBlock;
    }

    public boolean m_7370_(BlockGetter getter, BlockPos blockpos, BlockState state, boolean b) {
        return getter.m_8055_(blockpos.m_7494_()).m_60795_();
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos blockpos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource rand, BlockPos pos, BlockState state) {
    }

    private static boolean canBeGrass(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60819_().m_76186_() == 8) {
            return false;
        }
        int i = LayerLightEngine.m_75667_((BlockGetter)level, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.m_60739_((BlockGetter)level, blockpos));
        return i < level.m_7469_();
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.m_7494_();
        return DreamlandSpreadingGrassBlock.canBeGrass(state, level, pos) && !level.m_6425_(blockpos).m_205070_(FluidTags.f_13131_);
    }

    public void m_213898_(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource rand) {
        if (!DreamlandSpreadingGrassBlock.canBeGrass(state, (LevelReader)serverLevel, pos)) {
            if (!serverLevel.isAreaLoaded(pos, 1)) {
                return;
            }
            serverLevel.m_46597_(pos, this.dirt.get().m_49966_());
        } else {
            if (!serverLevel.isAreaLoaded(pos, 3)) {
                return;
            }
            if (serverLevel.m_46803_(pos.m_7494_()) >= 9) {
                BlockState blockstate = this.m_49966_();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.m_7918_(rand.m_188503_(3) - 1, rand.m_188503_(5) - 3, rand.m_188503_(3) - 1);
                    if (!serverLevel.m_8055_(blockpos).m_60713_(this.dirt.get()) || !DreamlandSpreadingGrassBlock.canPropagate(blockstate, (LevelReader)serverLevel, blockpos)) continue;
                    serverLevel.m_46597_(blockpos, blockstate);
                }
            }
        }
    }
}

