/*
 * Decompiled with CFR 0.152.
 */
package com.github.dragoni7.dreamland;

import com.github.dragoni7.dreamland.Config;
import com.github.dragoni7.dreamland.common.world.DreamlandRegion;
import com.github.dragoni7.dreamland.common.world.DreamlandSurfaceRules;
import com.github.dragoni7.dreamland.core.event.DreamlandClientEventHandler;
import com.github.dragoni7.dreamland.core.event.DreamlandEventHandler;
import com.github.dragoni7.dreamland.core.registry.DreamlandBlocks;
import com.github.dragoni7.dreamland.core.registry.DreamlandEffects;
import com.github.dragoni7.dreamland.core.registry.DreamlandEntities;
import com.github.dragoni7.dreamland.core.registry.DreamlandFluids;
import com.github.dragoni7.dreamland.core.registry.DreamlandItems;
import com.github.dragoni7.dreamland.core.registry.DreamlandParticles;
import com.github.dragoni7.dreamland.core.registry.DreamlandSoundEvents;
import com.github.dragoni7.dreamland.core.registry.DreamlandSoundTypes;
import com.github.dragoni7.dreamland.core.registry.DreamlandTiles;
import com.github.dragoni7.dreamland.core.registry.DreamlandWoodSets;
import com.github.dragoni7.dreamland.network.Networking;
import com.github.dragoni7.dreamland.util.DreamlandLoc;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib3.GeckoLib;
import terrablender.api.Region;
import terrablender.api.RegionType;
import terrablender.api.Regions;
import terrablender.api.SurfaceRuleManager;

@Mod(value="dreamland")
public class Dreamland {
    public static final String MODID = "dreamland";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final CreativeModeTab DreamlandTab = new CreativeModeTab("dreamland"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)DreamlandItems.LARVA_HELMET.get());
        }
    };

    public Dreamland() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        GeckoLib.initialize();
        forgeBus.register((Object)this);
        DreamlandSoundEvents.SOUND_EVENTS.register(modBus);
        DreamlandSoundTypes.init();
        DreamlandEntities.ENTITY_TYPES.register(modBus);
        DreamlandParticles.PARTICLES.register(modBus);
        DreamlandBlocks.BLOCKS.register(modBus);
        DreamlandTiles.TILES.register(modBus);
        DreamlandFluids.FLUID_TYPES.register(modBus);
        DreamlandFluids.FLUIDS.register(modBus);
        DreamlandItems.ITEMS.register(modBus);
        DreamlandWoodSets.init();
        DreamlandEntities.TILES.register(modBus);
        DreamlandEffects.MOB_EFFECTS.register(modBus);
        DreamlandEventHandler.init(modBus, forgeBus);
        modBus.addListener(this::commonSetup);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            DreamlandClientEventHandler.init(modBus);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)DreamlandFluids.TAR_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.LAVA_TYPE.get(), ((Block)DreamlandBlocks.DRIED_TAR.block().get()).m_49966_()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)DreamlandFluids.TAR_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), ((Block)DreamlandBlocks.TAR_MUD.block().get()).m_49966_()));
        event.enqueueWork(() -> {
            Networking.registerMessages();
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.OVERWORLD, (String)MODID, (SurfaceRules.RuleSource)DreamlandSurfaceRules.OVERWORLD_SURFACE_RULES);
            Regions.register((Region)new DreamlandRegion(DreamlandLoc.createLoc("dreamland_region"), RegionType.OVERWORLD, (Integer)Config.REGION_WEIGHT.get()));
        });
    }
}

