/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.world.entity;

import fuzs.mutantmonsters.init.ModRegistry;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import java.lang.ref.WeakReference;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EndersoulFragment
extends Entity {
    public static final Predicate<Entity> IS_VALID_TARGET = EntitySelector.f_20406_.and(entity -> {
        EntityType type = entity.m_6095_();
        return type != EntityType.f_20461_ && type != EntityType.f_20570_ && type != EntityType.f_20564_ && type != EntityType.f_20565_ && type != EntityType.f_20566_ && type != ModRegistry.ENDERSOUL_CLONE_ENTITY_TYPE.get() && type != ModRegistry.ENDERSOUL_FRAGMENT_ENTITY_TYPE.get() && type != ModRegistry.MUTANT_ENDERMAN_ENTITY_TYPE.get();
    });
    private static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(EndersoulFragment.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final float[][] stickRotations = new float[8][3];
    private int explodeTick = 20 + this.f_19796_.m_188503_(20);
    private WeakReference<MutantEnderman> spawner;
    private Player owner;

    public EndersoulFragment(EntityType<? extends EndersoulFragment> type, Level world) {
        super(type, world);
        for (int i = 0; i < this.stickRotations.length; ++i) {
            for (int j = 0; j < this.stickRotations[i].length; ++j) {
                this.stickRotations[i][j] = this.f_19796_.m_188501_() * 2.0f * (float)Math.PI;
            }
        }
    }

    public EndersoulFragment(Level world, MutantEnderman spawner) {
        this((EntityType<? extends EndersoulFragment>)((EntityType)ModRegistry.ENDERSOUL_FRAGMENT_ENTITY_TYPE.get()), world);
        this.spawner = new WeakReference<MutantEnderman>(spawner);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TAMED, (Object)false);
    }

    public Player getOwner() {
        return this.owner;
    }

    public boolean isTamed() {
        return (Boolean)this.f_19804_.m_135370_(TAMED);
    }

    public void setTamed(boolean tamed) {
        this.f_19804_.m_135381_(TAMED, (Object)tamed);
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_6094_() {
        return this.m_6084_();
    }

    public void m_7822_(byte id) {
        if (id == 3) {
            EntityUtil.spawnEndersoulParticles(this, this.f_19796_, 64, 0.8f);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 vec3d = this.m_20184_();
        if (this.owner == null && vec3d.f_82480_ > (double)-0.05f && !this.m_20068_()) {
            this.m_20334_(vec3d.f_82479_, Math.max((double)-0.05f, vec3d.f_82480_ - (double)0.1f), vec3d.f_82481_);
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.9));
        if (this.owner != null && (!this.owner.m_6084_() || this.owner.m_5833_())) {
            this.owner = null;
        }
        if (!this.f_19853_.f_46443_) {
            if (!this.isTamed() && --this.explodeTick == 0) {
                this.explode();
            }
            if (this.owner != null && this.m_20280_((Entity)this.owner) > 9.0) {
                float scale = 0.05f;
                this.m_5997_((this.owner.m_20185_() - this.m_20185_()) * (double)scale, (this.owner.m_20186_() + (double)(this.owner.m_20192_() / 3.0f) - this.m_20186_()) * (double)scale, (this.owner.m_20189_() - this.m_20189_()) * (double)scale);
            }
        }
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.isTamed()) {
            if (this.owner == null && !player.m_36341_()) {
                this.owner = player;
                this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            if (this.owner == player && player.m_36341_()) {
                this.owner = null;
                this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.5f);
                return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
            }
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            this.setTamed(true);
        }
        this.owner = player;
        this.m_5496_(SoundEvents.f_11897_, 1.0f, 1.5f);
        return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.f_19797_ > 0) {
            this.explode();
        }
        return true;
    }

    private void explode() {
        this.m_5496_((SoundEvent)ModRegistry.ENTITY_ENDERSOUL_FRAGMENT_EXPLODE_SOUND_EVENT.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        this.f_19853_.m_7605_((Entity)this, (byte)3);
        for (Entity entity : this.f_19853_.m_6249_((Entity)this, this.m_20191_().m_82400_(5.0), IS_VALID_TARGET)) {
            boolean hitChance;
            if (!(this.m_20280_(entity) <= 25.0)) continue;
            boolean bl = hitChance = this.f_19796_.m_188503_(3) != 0;
            if (EndersoulFragment.isProtected(entity)) {
                hitChance = this.f_19796_.m_188503_(3) == 0;
            } else {
                double x = entity.m_20185_() - this.m_20185_();
                double z = entity.m_20189_() - this.m_20189_();
                double d = Math.sqrt(x * x + z * z);
                entity.m_20334_((double)0.8f * x / d, (double)(this.f_19796_.m_188501_() * 0.6f - 0.1f), (double)0.8f * z / d);
                EntityUtil.sendPlayerVelocityPacket(entity);
            }
            if (!hitChance) continue;
            entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)(this.spawner != null ? (Entity)this.spawner.get() : this)).m_19380_(), 1.0f);
        }
        this.m_146870_();
    }

    public static boolean isProtected(Entity entity) {
        return entity instanceof LivingEntity && ((LivingEntity)entity).m_21055_((Item)ModRegistry.ENDERSOUL_HAND_ITEM.get());
    }

    public SoundSource m_5720_() {
        return this.isTamed() ? SoundSource.NEUTRAL : SoundSource.HOSTILE;
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128379_("Tamed", this.isTamed());
        compound.m_128405_("ExplodeTick", this.explodeTick);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setTamed(compound.m_128471_("Collected") || compound.m_128471_("Tamed"));
        if (compound.m_128441_("ExplodeTick")) {
            this.explodeTick = compound.m_128451_("ExplodeTick");
        }
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

