/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.handler;

import fuzs.mutantmonsters.core.CommonAbstractions;
import fuzs.mutantmonsters.util.EntityUtil;
import fuzs.mutantmonsters.world.entity.CreeperMinion;
import fuzs.mutantmonsters.world.entity.mutant.MutantCreeper;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import fuzs.mutantmonsters.world.entity.mutant.SpiderPig;
import fuzs.mutantmonsters.world.item.ArmorBlockItem;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class EntityEventsHandler {
    public static void onEntityJoinServerLevel(Entity entity, ServerLevel level) {
        if (entity instanceof PathfinderMob) {
            PathfinderMob creature = (PathfinderMob)entity;
            if (EntityUtil.isFeline((LivingEntity)creature)) {
                CommonAbstractions.INSTANCE.getGoalSelector((Mob)creature).m_25352_(2, (Goal)new AvoidEntityGoal(creature, MutantCreeper.class, 16.0f, 1.33, 1.33));
            }
            if (creature.m_6095_() == EntityType.f_20510_) {
                CommonAbstractions.INSTANCE.getGoalSelector((Mob)creature).m_25352_(2, (Goal)new TemptGoal(creature, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42592_}), false));
            }
            if (creature.m_6095_() == EntityType.f_20492_) {
                CommonAbstractions.INSTANCE.getGoalSelector((Mob)creature).m_25352_(0, (Goal)new AvoidEntityGoal(creature, MutantZombie.class, 12.0f, 0.8, 0.8));
            }
            if (creature.m_6095_() == EntityType.f_20494_) {
                CommonAbstractions.INSTANCE.getGoalSelector((Mob)creature).m_25352_(1, (Goal)new AvoidEntityGoal(creature, MutantZombie.class, 12.0f, 0.5, 0.5));
            }
        }
    }

    public static InteractionResult onEntityInteract(Player player, Level world, InteractionHand hand, Entity entity, @Nullable EntityHitResult hitResult) {
        ItemStack stackInHand;
        Pig pig;
        if (entity instanceof Pig && !(pig = (Pig)entity).m_21023_(MobEffects.f_19590_) && (stackInHand = player.m_21120_(hand)).m_41720_() == Items.f_42592_) {
            if (!player.m_7500_()) {
                stackInHand.m_41774_(1);
            }
            pig.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 600, 13));
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static Optional<Unit> onLivingHurt(LivingEntity entity, DamageSource source, float amount) {
        float damage;
        if (entity instanceof Player && entity.m_6844_(EquipmentSlot.HEAD).m_41720_() instanceof ArmorBlockItem && !((damage = amount) <= 0.0f)) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            ItemStack itemstack = entity.m_6844_(EquipmentSlot.HEAD);
            if (!source.m_19384_() || !itemstack.m_41720_().m_41475_()) {
                itemstack.m_41622_((int)damage, entity, livingEntity -> livingEntity.m_21166_(EquipmentSlot.HEAD));
            }
        }
        return Optional.empty();
    }

    public static Optional<Unit> onLivingDrops(LivingEntity entity, DamageSource source, Collection<ItemEntity> drops, int lootingLevel, boolean recentlyHit) {
        ItemStack itemStack;
        Entity trueSource = source.m_7639_();
        if (SpiderPig.isPigOrSpider(entity) && trueSource instanceof SpiderPig) {
            return Optional.of(Unit.INSTANCE);
        }
        if ((trueSource instanceof MutantCreeper && ((MutantCreeper)trueSource).isCharged() || trueSource instanceof CreeperMinion && ((CreeperMinion)trueSource).isCharged()) && source.m_19372_() && !(itemStack = EntityUtil.getSkullDrop(entity.m_6095_())).m_41619_()) {
            drops.add(new ItemEntity(trueSource.f_19853_, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), itemStack));
        }
        return Optional.empty();
    }
}

