/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import fuzs.mutantmonsters.client.MutantMonstersClient;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantArrowModel;
import fuzs.mutantmonsters.client.model.MutantSkeletonModel;
import fuzs.mutantmonsters.client.renderer.entity.MutantArrowRenderer;
import fuzs.mutantmonsters.world.entity.mutant.MutantSkeleton;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class MutantSkeletonRenderer
extends MobRenderer<MutantSkeleton, MutantSkeletonModel> {
    public static final ResourceLocation TEXTURE = MutantMonstersClient.entityTexture("mutant_skeleton");
    private static final ResourceLocation CROSSBOW_TEXTURE = MutantMonstersClient.entityTexture("mutant_crossbow");

    public MutantSkeletonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new MutantSkeletonModel(context.m_174023_(ClientModRegistry.MUTANT_SKELETON), context.m_174023_(ClientModRegistry.MUTANT_CROSSBOW)), 0.6f);
        this.m_115326_(new CrossbowLayer((RenderLayerParent<MutantSkeleton, MutantSkeletonModel>)this, context.m_174027_()));
    }

    protected float getFlipDegrees(MutantSkeleton entityLivingBaseIn) {
        return 0.0f;
    }

    public ResourceLocation getTextureLocation(MutantSkeleton entity) {
        return TEXTURE;
    }

    static class CrossbowLayer
    extends RenderLayer<MutantSkeleton, MutantSkeletonModel> {
        private final MutantArrowModel model;

        public CrossbowLayer(RenderLayerParent<MutantSkeleton, MutantSkeletonModel> entityRendererIn, EntityModelSet entityModelSet) {
            super(entityRendererIn);
            this.model = new MutantArrowModel(entityModelSet.m_171103_(ClientModRegistry.MUTANT_ARROW));
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MutantSkeleton entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            matrixStackIn.m_85836_();
            boolean leftHanded = entity.m_21526_();
            ((MutantSkeletonModel)this.m_117386_()).translateHand(leftHanded, matrixStackIn);
            if (leftHanded) {
                matrixStackIn.m_85841_(-1.0f, 1.0f, -1.0f);
            }
            ((MutantSkeletonModel)this.m_117386_()).getCrossbow().m_7695_(matrixStackIn, bufferIn.m_6299_(((MutantSkeletonModel)this.m_117386_()).getCrossbow().m_103119_(CROSSBOW_TEXTURE)), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.m_85849_();
            if (entity.getAnimation() == MutantSkeleton.SHOOT_ANIMATION && entity.getAnimationTick() > 10 && entity.getAnimationTick() < 26 || entity.getAnimation() == MutantSkeleton.MULTI_SHOT_ANIMATION && entity.getAnimationTick() > 16 && entity.getAnimationTick() < 24) {
                matrixStackIn.m_85836_();
                ((MutantSkeletonModel)this.m_117386_()).translateHand(leftHanded, matrixStackIn);
                matrixStackIn.m_85837_(leftHanded ? 0.2 : -0.2, 0.4, -1.8);
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                matrixStackIn.m_85841_(1.2f, 1.2f, 1.2f);
                VertexConsumer vertexBuilder = bufferIn.m_6299_(this.model.m_103119_(MutantArrowRenderer.TEXTURE));
                this.model.m_7695_(matrixStackIn, vertexBuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                matrixStackIn.m_85849_();
            }
        }
    }
}

