/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.capabilities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.component.PlayerOriginComponent;
import io.github.apace100.origins.util.ChoseOriginCriterion;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.component.IPowerContainer;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.power.factory.PowerFactory;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.IOriginCallbackPower;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2COpenWaitingForPowersScreen;
import io.github.edwinmindcraft.origins.common.network.S2CSynchronizeOrigin;
import io.github.edwinmindcraft.origins.common.registry.OriginRegisters;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OriginContainer
implements IOriginContainer,
ICapabilitySerializable<Tag> {
    public static final ResourceLocation ID = Origins.identifier("origins");
    private final Player player;
    private final Map<ResourceKey<OriginLayer>, ResourceKey<Origin>> layers;
    private final AtomicBoolean synchronization;
    private final AtomicBoolean hadAllOrigins;
    private boolean cleanupPowers = true;
    @Deprecated
    private final Lazy<OriginComponent> component = Lazy.of(() -> new PlayerOriginComponent(this));
    private final LazyOptional<IOriginContainer> thisOptional = LazyOptional.of(() -> this);
    private final AtomicInteger syncCooldown = new AtomicInteger(0);

    public OriginContainer(Player player) {
        this.player = player;
        this.layers = new ConcurrentHashMap<ResourceKey<OriginLayer>, ResourceKey<Origin>>();
        this.synchronization = new AtomicBoolean();
        this.hadAllOrigins = new AtomicBoolean();
    }

    @Override
    public void setOrigin(@NotNull ResourceKey<OriginLayer> layer, @NotNull ResourceKey<Origin> origin) {
        this.setOriginInternal(layer, origin, true);
    }

    public void setOriginInternal(@NotNull ResourceKey<OriginLayer> layer, @NotNull ResourceKey<Origin> origin, boolean handlePowers) {
        Optional layerHolder = OriginsAPI.getLayersRegistry().m_203636_(layer);
        Optional originHolder = OriginsAPI.getOriginsRegistry().m_203636_(origin);
        if (layerHolder.isEmpty() || !((Holder)layerHolder.get()).m_203633_()) {
            Origins.LOGGER.error("Tried to assign missing layer {} to player {}", layer, (Object)this.player.m_6302_());
            return;
        }
        if (originHolder.isEmpty() || !((Holder)originHolder.get()).m_203633_()) {
            Origins.LOGGER.error("Tried to assign missing origin {} to player {}", origin, (Object)this.player.m_6302_());
            return;
        }
        ResourceKey<Origin> previous = this.layers.put(layer, origin);
        if (!Objects.equals(origin, previous) || !handlePowers) {
            if (handlePowers) {
                Player player;
                IPowerContainer.get((Entity)this.player).ifPresent(container -> {
                    this.grantPowers((IPowerContainer)container, origin, (Holder<Origin>)((Holder)originHolder.get()));
                    if (previous != null) {
                        container.removeAllPowersFromSource(OriginsAPI.getPowerSource(previous));
                    }
                });
                if (this.hasAllOrigins()) {
                    this.hadAllOrigins.set(true);
                }
                if ((player = this.player) instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    ChoseOriginCriterion.INSTANCE.trigger(sp, origin);
                }
            }
            this.synchronize();
        }
    }

    private void grantPowers(IPowerContainer container, @NotNull ResourceKey<Origin> origin, Holder<Origin> holder) {
        ResourceLocation powerSource = OriginsAPI.getPowerSource(origin);
        Registry powers = ApoliAPI.getPowers((MinecraftServer)this.player.m_20194_());
        for (HolderSet<ConfiguredPower<?, ?>> holderSet : ((Origin)holder.m_203334_()).getPowers()) {
            for (Holder power : holderSet) {
                if (!power.m_203633_()) continue;
                ((Optional)power.m_203439_().map(Optional::of, arg_0 -> ((Registry)powers).m_7854_(arg_0))).ifPresent(powerKey -> {
                    if (!container.hasPower(powerKey, powerSource)) {
                        container.addPower(powerKey, powerSource);
                    }
                });
            }
        }
    }

    @Override
    @NotNull
    public ResourceKey<Origin> getOrigin(@NotNull ResourceKey<OriginLayer> layer) {
        return this.layers.getOrDefault(layer, (ResourceKey<Origin>)OriginRegisters.EMPTY.getKey());
    }

    @Override
    public boolean hasOrigin(@NotNull ResourceKey<OriginLayer> layer) {
        return !Objects.equals(this.getOrigin(layer), OriginRegisters.EMPTY.getKey());
    }

    @Override
    public boolean hadAllOrigins() {
        return this.hadAllOrigins.get();
    }

    @Override
    @NotNull
    public Map<ResourceKey<OriginLayer>, ResourceKey<Origin>> getOrigins() {
        return ImmutableMap.copyOf(this.layers);
    }

    @Override
    public void synchronize() {
        this.synchronization.compareAndSet(false, true);
    }

    @Override
    public boolean shouldSync() {
        return this.synchronization.get();
    }

    @Override
    @NotNull
    public Player getOwner() {
        return this.player;
    }

    @Override
    public void tick() {
        if (this.cleanupPowers) {
            this.cleanupPowers = false;
            IPowerContainer.get((Entity)this.player).ifPresent(this::applyCleanup);
        }
        if (this.shouldSync() && !this.player.f_19853_.m_5776_() && this.syncCooldown.decrementAndGet() <= 0) {
            OriginsCommon.CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> this.player), (Object)this.getSynchronizationPacket());
            this.syncCooldown.set(20);
            ApoliAPI.synchronizePowerContainer((Entity)this.player);
        }
    }

    private void applyCleanup(@NotNull IPowerContainer container) {
        Registry<Origin> originsRegistry = OriginsAPI.getOriginsRegistry();
        Registry<OriginLayer> layersRegistry = OriginsAPI.getLayersRegistry();
        Iterator<Map.Entry<ResourceKey<OriginLayer>, ResourceKey<Origin>>> iterator = this.layers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceKey<OriginLayer>, ResourceKey<Origin>> entry = iterator.next();
            ResourceKey<OriginLayer> layer = entry.getKey();
            ResourceKey<Origin> origin = entry.getValue();
            ResourceLocation powerSource = OriginsAPI.getPowerSource(origin);
            if (!layersRegistry.m_142003_(layer)) {
                iterator.remove();
                container.removeAllPowersFromSource(powerSource);
                Origins.LOGGER.debug("CLEANUP: Removed missing layer {} on player {}", layer, (Object)this.player.m_6302_());
                continue;
            }
            if (!originsRegistry.m_142003_(origin)) {
                Origins.LOGGER.debug("CLEANUP: Removed missing origin {} on player {}", origin, (Object)this.player.m_6302_());
                container.removeAllPowersFromSource(powerSource);
                entry.setValue((ResourceKey<Origin>)OriginRegisters.EMPTY.getKey());
                continue;
            }
            ImmutableSet currentPowers = ImmutableSet.copyOf((Collection)container.getPowersFromSource(powerSource));
            Registry registry = ApoliAPI.getPowers((MinecraftServer)this.player.m_20194_());
            Set newPowers = (Set)((Origin)originsRegistry.m_123013_(origin)).getValidPowers().flatMap(holder -> {
                if (!holder.m_203633_()) {
                    return Stream.empty();
                }
                Optional key = (Optional)holder.m_203439_().map(Optional::of, arg_0 -> ((Registry)registry).m_7854_(arg_0));
                if (key.isEmpty()) {
                    return Stream.empty();
                }
                HashSet<ResourceKey> names = new HashSet<ResourceKey>();
                names.add((ResourceKey)key.get());
                names.addAll(((ConfiguredPower)holder.m_203334_()).getChildrenKeys());
                return names.stream();
            }).collect(ImmutableSet.toImmutableSet());
            Set<ResourceKey> toRemove = currentPowers.stream().filter(x -> !newPowers.contains(x)).collect(Collectors.toSet());
            Set<ResourceKey> toAdd = newPowers.stream().filter(arg_0 -> OriginContainer.lambda$applyCleanup$5((Set)currentPowers, arg_0)).collect(Collectors.toSet());
            if (!toRemove.isEmpty()) {
                toRemove.forEach(power -> container.removePower(power, powerSource));
                Origins.LOGGER.debug("CLEANUP: Revoked {} removed powers for origin {} on player {}", (Object)toRemove.size(), origin, (Object)this.player.m_6302_());
            }
            if (toAdd.isEmpty()) continue;
            toAdd.forEach(power -> container.addPower(power, powerSource));
            Origins.LOGGER.debug("CLEANUP: Granted {} missing powers for origin {} on player {}", (Object)toAdd.size(), origin, (Object)this.player.m_6302_());
        }
    }

    @Override
    @NotNull
    public S2CSynchronizeOrigin getSynchronizationPacket() {
        return new S2CSynchronizeOrigin(this.player.m_19879_(), this.getLayerMap(), this.hadAllOrigins());
    }

    @NotNull
    private Map<ResourceLocation, ResourceLocation> getLayerMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.layers.forEach((layer, origin) -> builder.put((Object)layer.m_135782_(), (Object)origin.m_135782_()));
        return builder.build();
    }

    @Override
    public boolean checkAutoChoosingLayers(boolean includeDefaults) {
        boolean choseOneAutomatically = false;
        for (Holder.Reference<OriginLayer> layer : OriginsAPI.getActiveLayers()) {
            boolean shouldContinue = false;
            if (!this.hasOrigin((ResourceKey<OriginLayer>)layer.m_205785_())) {
                if (includeDefaults && ((OriginLayer)layer.m_203334_()).hasDefaultOrigin() && !((OriginLayer)layer.m_203334_()).defaultOrigin().m_203373_(OriginRegisters.EMPTY.getId())) {
                    this.setOrigin((Holder<OriginLayer>)layer, ((OriginLayer)layer.m_203334_()).defaultOrigin());
                    choseOneAutomatically = true;
                    shouldContinue = true;
                } else {
                    Optional<Holder<Origin>> automaticOrigin = ((OriginLayer)layer.m_203334_()).getAutomaticOrigin(this.player);
                    if (automaticOrigin.isPresent()) {
                        this.setOrigin((Holder<OriginLayer>)layer, automaticOrigin.get());
                        choseOneAutomatically = true;
                        shouldContinue = true;
                    } else if (((OriginLayer)layer.m_203334_()).getOriginOptionCount(this.player) == 0) {
                        shouldContinue = true;
                    }
                }
            } else {
                shouldContinue = true;
            }
            if (shouldContinue) continue;
            break;
        }
        return choseOneAutomatically;
    }

    @Override
    public void onChosen(@NotNull ResourceKey<Origin> origin, boolean isOrb) {
        HashSet set = Sets.newHashSet();
        IPowerContainer.get((Entity)this.player).ifPresent(container -> container.getPowersFromSource(OriginsAPI.getPowerSource(origin)).stream().map(arg_0 -> ((IPowerContainer)container).getPower(arg_0)).filter(Objects::nonNull).forEach(power -> {
            PowerFactory patt11712$temp;
            if (power.m_203633_() && (patt11712$temp = ((ConfiguredPower)power.m_203334_()).getFactory()) instanceof IOriginCallbackPower) {
                IOriginCallbackPower callbackPower = (IOriginCallbackPower)patt11712$temp;
                if (!callbackPower.isReady((ConfiguredPower)power.m_203334_(), (Entity)this.player, isOrb)) {
                    callbackPower.prepare((ConfiguredPower)power.m_203334_(), (Entity)this.player, isOrb);
                    power.m_203543_().ifPresent(k -> set.add(k));
                } else {
                    callbackPower.onChosen((ConfiguredPower)power.m_203334_(), (Entity)this.player, isOrb);
                }
            }
        }));
        if (!set.isEmpty() && !this.player.f_19853_.m_5776_()) {
            OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new S2COpenWaitingForPowersScreen(isOrb, set));
        }
    }

    @Override
    public void onChosen(boolean isOrb) {
        HashSet set = Sets.newHashSet();
        IPowerContainer.get((Entity)this.player).ifPresent(container -> container.getPowers().forEach(x -> {
            PowerFactory patt12798$temp;
            if (x.m_203633_() && (patt12798$temp = ((ConfiguredPower)x.m_203334_()).getFactory()) instanceof IOriginCallbackPower) {
                IOriginCallbackPower callbackPower = (IOriginCallbackPower)patt12798$temp;
                if (!callbackPower.isReady((ConfiguredPower)x.m_203334_(), (Entity)this.player, isOrb)) {
                    callbackPower.prepare((ConfiguredPower)x.m_203334_(), (Entity)this.player, isOrb);
                    x.m_203543_().ifPresent(set::add);
                } else {
                    callbackPower.onChosen((ConfiguredPower)x.m_203334_(), (Entity)this.player, isOrb);
                }
            }
        }));
        if (!set.isEmpty() && !this.player.f_19853_.m_5776_()) {
            OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.player), (Object)new S2COpenWaitingForPowersScreen(isOrb, set));
        }
    }

    @Override
    public void onReload(@NotNull ICalioDynamicRegistryManager registry) {
        this.cleanupPowers = true;
    }

    @Override
    @Deprecated
    @NotNull
    public OriginComponent asLegacyComponent() {
        return (OriginComponent)this.component.get();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return OriginsAPI.ORIGIN_CONTAINER.orEmpty(cap, this.thisOptional);
    }

    public void acceptSynchronization(Map<ResourceLocation, ResourceLocation> map, boolean hadAllOrigins) {
        this.layers.clear();
        Registry<OriginLayer> layers = OriginsAPI.getLayersRegistry(this.player.m_20194_());
        Registry<Origin> origins = OriginsAPI.getOriginsRegistry(this.player.m_20194_());
        for (Map.Entry<ResourceLocation, ResourceLocation> entry : map.entrySet()) {
            ResourceKey layer = ResourceKey.m_135785_(OriginsDynamicRegistries.LAYERS_REGISTRY, (ResourceLocation)entry.getKey());
            ResourceKey origin = ResourceKey.m_135785_(OriginsDynamicRegistries.ORIGINS_REGISTRY, (ResourceLocation)entry.getValue());
            if (!layers.m_142003_(layer) || !origins.m_142003_(origin)) continue;
            this.layers.put((ResourceKey<OriginLayer>)layer, (ResourceKey<Origin>)origin);
        }
        this.hadAllOrigins.set(hadAllOrigins);
    }

    public Tag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        CompoundTag layers = new CompoundTag();
        Registry<Origin> originsRegistry = OriginsAPI.getOriginsRegistry(this.player.m_20194_());
        Registry<OriginLayer> layersRegistry = OriginsAPI.getLayersRegistry(this.player.m_20194_());
        for (Map.Entry<ResourceKey<OriginLayer>, ResourceKey<Origin>> entry : this.getOrigins().entrySet()) {
            if (!layersRegistry.m_142003_(entry.getKey()) || !originsRegistry.m_142003_(entry.getValue())) {
                Origins.LOGGER.warn("Removed missing entry {}: {}", entry.getKey(), entry.getValue());
                continue;
            }
            layers.m_128359_(entry.getKey().m_135782_().toString(), entry.getValue().m_135782_().toString());
        }
        tag.m_128365_("Origins", (Tag)layers);
        tag.m_128379_("HadAllOrigins", this.hasAllOrigins());
        return tag;
    }

    public void deserializeNBT(Tag nbt) {
        this.layers.clear();
        CompoundTag tag = (CompoundTag)nbt;
        CompoundTag layers = tag.m_128469_("Origins");
        Registry<OriginLayer> layersRegistry = OriginsAPI.getLayersRegistry(this.player.m_20194_());
        Registry<Origin> originsRegistry = OriginsAPI.getOriginsRegistry(this.player.m_20194_());
        for (String key : layers.m_128431_()) {
            String origin = layers.m_128461_(key);
            if (origin.isBlank()) continue;
            ResourceLocation orig = ResourceLocation.m_135820_((String)origin);
            if (orig == null) {
                Origins.LOGGER.warn("Invalid origin {} found for layer {} on entity {}", (Object)origin, (Object)key, (Object)this.player.m_6302_());
                continue;
            }
            ResourceKey originKey = ResourceKey.m_135785_(OriginsDynamicRegistries.ORIGINS_REGISTRY, (ResourceLocation)orig);
            Optional origin1 = originsRegistry.m_203636_(originKey);
            if (origin1.isEmpty() || !((Holder)origin1.get()).m_203633_()) {
                Origins.LOGGER.warn("Missing origin {} found for layer {} on entity {}", (Object)origin, (Object)key, (Object)this.player.m_6302_());
                IPowerContainer.get((Entity)this.player).ifPresent(container -> container.removeAllPowersFromSource(OriginsAPI.getPowerSource(orig)));
                continue;
            }
            ResourceLocation rl = ResourceLocation.m_135820_((String)key);
            if (rl == null) {
                Origins.LOGGER.warn("Invalid layer found {} on entity {}", (Object)key, (Object)this.player.m_6302_());
                IPowerContainer.get((Entity)this.player).ifPresent(container -> container.removeAllPowersFromSource(OriginsAPI.getPowerSource((Holder<Origin>)((Holder)origin1.get()))));
                continue;
            }
            ResourceKey layerKey = ResourceKey.m_135785_(OriginsDynamicRegistries.LAYERS_REGISTRY, (ResourceLocation)rl);
            Optional layer = layersRegistry.m_203636_(layerKey);
            if (layer.isEmpty() || !((Holder)layer.get()).m_203633_()) {
                Origins.LOGGER.warn("Missing layer {} on entity {}", (Object)rl, (Object)this.player.m_6302_());
                IPowerContainer.get((Entity)this.player).ifPresent(container -> container.removeAllPowersFromSource(OriginsAPI.getPowerSource((Holder<Origin>)((Holder)origin1.get()))));
                continue;
            }
            this.setOriginInternal((ResourceKey<OriginLayer>)layerKey, (ResourceKey<Origin>)originKey, false);
        }
        this.hadAllOrigins.set(tag.m_128471_("HadAllOrigins"));
    }

    @Override
    public void validateSynchronization() {
        this.synchronization.compareAndSet(true, false);
        this.syncCooldown.set(0);
    }

    private static /* synthetic */ boolean lambda$applyCleanup$5(Set currentPowers, ResourceKey x) {
        return !currentPowers.contains(x);
    }
}

