/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.edwinmindcraft.apoli.api.ApoliAPI;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.HashMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class PowerKeyManager {
    private static final HashMap<ResourceLocation, String> KEY_CACHE = new HashMap();

    public static void clearCache() {
        KEY_CACHE.clear();
    }

    public static String getKeyIdentifier(ResourceLocation powerId) {
        if (KEY_CACHE.containsKey(powerId)) {
            return KEY_CACHE.get(powerId);
        }
        String key = PowerKeyManager.getKeyFromPower(powerId);
        KEY_CACHE.put(powerId, key);
        return key;
    }

    private static String getKeyFromPower(ResourceLocation powerId) {
        if (PowerTypeRegistry.contains((ResourceLocation)powerId)) {
            Registry powers = ApoliAPI.getPowers();
            ConfiguredPower powerType = (ConfiguredPower)powers.m_7745_(powerId);
            if (powerType == null) {
                return "";
            }
            return powerType.getKey(null).map(key -> key.key().equals("none") ? "key.origins.primary_active" : key.key()).or(() -> powerType.getContainedPowerKeys().stream().filter(arg_0 -> ((Registry)powers).m_142003_(arg_0)).map(x -> PowerKeyManager.getKeyFromPower(x.m_135782_())).filter(x -> !x.isBlank()).findFirst()).orElse("");
        }
        return "";
    }
}

