/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.vinery.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import satisfyu.vinery.registry.VineryEffects;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
extends AbstractClientPlayer {
    private int jumpCount = 0;
    private boolean jumpedLastTick = false;

    public ClientPlayerEntityMixin(ClientLevel world, GameProfile profile, @Nullable ProfilePublicKey publicKey) {
        super(world, profile, publicKey);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void tickMovement(CallbackInfo info) {
        if (this.m_21023_((MobEffect)VineryEffects.IMPROVED_JUMP_BOOST.get())) {
            LocalPlayer player = (LocalPlayer)this;
            if (player.m_20096_() || player.m_6147_()) {
                this.jumpCount = 1;
            } else if (!this.jumpedLastTick && this.jumpCount > 0 && player.m_20184_().f_82480_ < 0.0 && player.f_108618_.f_108572_ && !player.m_150110_().f_35935_ && this.canJump(player)) {
                --this.jumpCount;
                player.m_6135_();
            }
            this.jumpedLastTick = player.f_108618_.f_108572_;
        }
    }

    @Redirect(method={"updateAutoJump"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z"))
    public boolean improvedJumpBoost(LocalPlayer livingEntity, MobEffect statusEffect) {
        return livingEntity.m_21023_(MobEffects.f_19603_) || livingEntity.m_21023_((MobEffect)VineryEffects.IMPROVED_JUMP_BOOST.get());
    }

    @Redirect(method={"updateAutoJump"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/player/LocalPlayer;getEffect(Lnet/minecraft/world/effect/MobEffect;)Lnet/minecraft/world/effect/MobEffectInstance;"))
    public MobEffectInstance improvedJumpBoostAmplifier(LocalPlayer livingEntity, MobEffect statusEffect) {
        return livingEntity.m_21023_((MobEffect)VineryEffects.IMPROVED_JUMP_BOOST.get()) ? livingEntity.m_21124_((MobEffect)VineryEffects.IMPROVED_JUMP_BOOST.get()) : livingEntity.m_21124_(MobEffects.f_19603_);
    }

    private boolean wearingUsableElytra(LocalPlayer player) {
        ItemStack chestItemStack = player.m_6844_(EquipmentSlot.CHEST);
        return chestItemStack.m_41720_() == Items.f_42741_ && ElytraItem.m_41140_((ItemStack)chestItemStack);
    }

    private boolean canJump(LocalPlayer player) {
        return !this.wearingUsableElytra(player) && !player.m_21255_() && !player.m_20159_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19620_);
    }
}

