/*
 * Decompiled with CFR 0.152.
 */
package timefall.mcsa.items.armor;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import timefall.mcsa.configs.McsaConfig;

public enum ArmorSets implements ArmorMaterial
{
    ADAMANTIUM("adamantium", "adamantium_impervium", 40, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    CHAMPION_PETRA("championpetra", "champion_petra", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    DRAGONSBANE("dragonsbane", "dragonsbane", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    ELLEGAARD("ellegaard", "ellegaard", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    ENDER_DEFENDER("ender", "ender_defender", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    ENDERMAN_SOREN("enderman", "enderman_soren", 35, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    GABRIEL("gabriel", "gabriel", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    GOLDEN_GOLIATH("golden", "golden_goliath", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    GOLDEN_GOLIATH_CIRCUITRY("goldenu", "golden_goliath_circuitry", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    HARPERS_HEADSET("harper", "harpers_headset", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    IVOR("ivor", "ivor", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    LUKAS("lukas", "lukas", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    MAGNUS("magnus", "magnus", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    NINJA_IVOR_ARMOR("ninja", "ninja_ivor", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    OLIVIA("olivia", "olivia", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    PETRA("petra", "petra", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    PRISMARINE("prismarine", "prismarine_soldier", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42193_})),
    REDSTONE_RIOT("riot", "redstone_riot", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    SHIELD_OF_INFINITY("infinity", "shield_of_infinity", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    SOREN("soren", "soren", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    STAR_SHIELD("star", "star_shield", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    SWORDBREAKER("swordbreaker", "swordbreaker", 37, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_})),
    TIMS_ARMOR("tim", "tim", 25, 25, SoundEvents.f_11673_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42415_}));

    private static final int[] baseDurability;
    private final String textureName;
    private final String setName;
    private final int durabilityMultiplier;
    private final int enchantability;
    private final SoundEvent equipSound;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private ArmorSets(String textureName, String setName, int durabilityMultiplier, int enchantability, SoundEvent soundEvent, Supplier<Ingredient> repairIngredient) {
        this.textureName = textureName;
        this.setName = setName;
        this.durabilityMultiplier = durabilityMultiplier;
        this.enchantability = enchantability;
        this.equipSound = soundEvent;
        this.repairIngredient = new LazyLoadedValue(repairIngredient);
    }

    public String getSetName() {
        return this.setName;
    }

    public Rarity getRarity() {
        switch (this) {
            case ADAMANTIUM: 
            case CHAMPION_PETRA: 
            case DRAGONSBANE: 
            case ELLEGAARD: 
            case ENDER_DEFENDER: 
            case ENDERMAN_SOREN: 
            case GABRIEL: 
            case GOLDEN_GOLIATH: 
            case GOLDEN_GOLIATH_CIRCUITRY: 
            case HARPERS_HEADSET: 
            case IVOR: 
            case LUKAS: 
            case MAGNUS: 
            case NINJA_IVOR_ARMOR: 
            case OLIVIA: 
            case PETRA: 
            case PRISMARINE: 
            case REDSTONE_RIOT: 
            case SHIELD_OF_INFINITY: 
            case SOREN: 
            case STAR_SHIELD: 
            case SWORDBREAKER: 
            case TIMS_ARMOR: {
                return Rarity.RARE;
            }
        }
        return Rarity.UNCOMMON;
    }

    public int m_7366_(EquipmentSlot slot) {
        return baseDurability[slot.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7365_(EquipmentSlot slot) {
        return McsaConfig.config.armorStats.get((Object)((Object)this)).protection.get(slot);
    }

    public int m_6646_() {
        return this.enchantability;
    }

    public SoundEvent m_7344_() {
        return this.equipSound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.textureName;
    }

    public float m_6651_() {
        return McsaConfig.config.armorStats.get((Object)((Object)this)).toughness;
    }

    public float m_6649_() {
        return McsaConfig.config.armorStats.get((Object)((Object)this)).knockbackRes;
    }

    static {
        baseDurability = new int[]{12, 14, 15, 10};
    }
}

