/*
 * Decompiled with CFR 0.152.
 */
package timefall.mcsa.items.armor;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import timefall.mcsa.Mcsa;
import timefall.mcsa.blocks.CarvedWhitePumpkinBlock;
import timefall.mcsa.configs.ArmorStats;
import timefall.mcsa.configs.McsaConfig;
import timefall.mcsa.init.BlocksInit;
import timefall.mcsa.items.armor.ArmorSets;

public class ArmorSetItem
extends ArmorItem {
    private static final Map<ArmorSets, MobEffectInstance> MATERIAL_TO_EFFECT_MAP = new ImmutableMap.Builder().put((Object)ArmorSets.MAGNUS, (Object)new MobEffectInstance(MobEffects.f_19608_, 200, 0)).put((Object)ArmorSets.PRISMARINE, (Object)new MobEffectInstance(MobEffects.f_19608_, 200, 0)).build();
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    protected final Multimap<Attribute, AttributeModifier> attributeModifiers;
    protected final ArmorSets set;

    public ArmorSetItem(ArmorSets set, EquipmentSlot slot) {
        super((ArmorMaterial)set, slot, new Item.Properties().m_41491_(Mcsa.MCSA_TAB));
        this.set = set;
        int protection = set.m_7365_(slot);
        float toughness = set.m_6651_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        UUID uuid = ARMOR_MODIFIERS[slot.m_20749_()];
        builder.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(uuid, "Armor modifier", (double)protection, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22285_, (Object)new AttributeModifier(uuid, "Armor toughness", (double)toughness, AttributeModifier.Operation.ADDITION));
        if (this.f_40378_ > 0.0f) {
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(uuid, "Armor knockback resistance", (double)this.f_40378_, AttributeModifier.Operation.ADDITION));
        }
        ArmorStats armorStats = McsaConfig.config.armorStats.get((Object)set);
        this.attributeModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        return slot == this.f_40377_ ? this.attributeModifiers : super.m_7167_(slot);
    }

    public Rarity m_41460_(ItemStack itemStack) {
        return this.set.getRarity();
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        Player playerEntity;
        if (!world.f_46443_ && entity instanceof Player && this.hasFullSetOfArmorOn(playerEntity = (Player)entity)) {
            this.checkArmorEffects(playerEntity);
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    private void checkArmorEffects(Player playerEntity) {
        for (Map.Entry<ArmorSets, MobEffectInstance> entry : MATERIAL_TO_EFFECT_MAP.entrySet()) {
            ArmorSets mapArmorSets = entry.getKey();
            MobEffectInstance mapStatusEffect = entry.getValue();
            if (!this.hasCorrectArmorOn(mapArmorSets, playerEntity)) continue;
            this.addStatusEffectForArmorSet(playerEntity, mapArmorSets, mapStatusEffect);
        }
    }

    private void addStatusEffectForArmorSet(Player playerEntity, ArmorSets mapArmorSets, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = playerEntity.m_21023_(mapStatusEffect.m_19544_());
        if (this.hasCorrectArmorOn(mapArmorSets, playerEntity) && !hasPlayerEffect) {
            playerEntity.m_7292_(new MobEffectInstance(mapStatusEffect.m_19544_(), mapStatusEffect.m_19557_(), mapStatusEffect.m_19564_(), true, false));
        }
    }

    private boolean hasFullSetOfArmorOn(Player playerEntity) {
        ItemStack bootsStack = playerEntity.m_150109_().m_36052_(0);
        ItemStack leggingsStack = playerEntity.m_150109_().m_36052_(1);
        ItemStack chestplateStack = playerEntity.m_150109_().m_36052_(2);
        ItemStack helmetStack = playerEntity.m_150109_().m_36052_(3);
        return !helmetStack.m_41619_() && !chestplateStack.m_41619_() && !leggingsStack.m_41619_() && !bootsStack.m_41619_();
    }

    private boolean hasCorrectArmorOn(ArmorSets armorSet, Player playerEntity) {
        Item item;
        if (!playerEntity.m_6844_(EquipmentSlot.HEAD).m_150930_(((CarvedWhitePumpkinBlock)((Object)BlocksInit.CARVED_WHITE_PUMPKIN_BLOCK.get())).m_5456_()) && (item = playerEntity.m_150109_().m_36052_(0).m_41720_()) instanceof ArmorSetItem) {
            ArmorSetItem bootsStack = (ArmorSetItem)item;
            Item item2 = playerEntity.m_150109_().m_36052_(1).m_41720_();
            if (item2 instanceof ArmorSetItem) {
                ArmorSetItem leggingsStack = (ArmorSetItem)item2;
                Item item3 = playerEntity.m_150109_().m_36052_(2).m_41720_();
                if (item3 instanceof ArmorSetItem) {
                    ArmorSetItem chestplateStack = (ArmorSetItem)item3;
                    Item item4 = playerEntity.m_150109_().m_36052_(3).m_41720_();
                    if (item4 instanceof ArmorSetItem) {
                        ArmorSetItem helmetStack = (ArmorSetItem)item4;
                        return helmetStack.m_40401_() == armorSet && chestplateStack.m_40401_() == armorSet && leggingsStack.m_40401_() == armorSet && bootsStack.m_40401_() == armorSet;
                    }
                }
            }
        }
        return false;
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        super.m_7373_(itemStack, world, tooltip, tooltipContext);
        String setId = this.set.getSetName();
        String translationKey = String.format("item.mcsa.%s.tooltip_", setId);
        int i = 1;
        while (I18n.m_118936_((String)(translationKey + i))) {
            tooltip.add((Component)Component.m_237115_((String)(translationKey + i)).m_130940_(ChatFormatting.ITALIC));
            ++i;
        }
        if (McsaConfig.config.enableArmorSetBonusTooltips) {
            translationKey = String.format("item.mcsa.%s.effect.tooltip_", setId);
            i = 1;
            if (McsaConfig.config.enableArmorEffectTooltip.get((Object)this.set).booleanValue() && McsaConfig.config.enableArmorEffectOfSet.get((Object)this.set).booleanValue()) {
                while (I18n.m_118936_((String)(translationKey + i))) {
                    MutableComponent mutableComponent = Component.m_237115_((String)(translationKey + i));
                    tooltip.add((Component)mutableComponent.m_130940_(switch (this.set) {
                        case ArmorSets.GOLDEN_GOLIATH -> ChatFormatting.GOLD;
                        case ArmorSets.REDSTONE_RIOT -> ChatFormatting.RED;
                        case ArmorSets.ENDER_DEFENDER -> ChatFormatting.AQUA;
                        case ArmorSets.SWORDBREAKER, ArmorSets.STAR_SHIELD -> ChatFormatting.BLUE;
                        case ArmorSets.SHIELD_OF_INFINITY -> ChatFormatting.LIGHT_PURPLE;
                        case ArmorSets.DRAGONSBANE -> ChatFormatting.DARK_PURPLE;
                        case ArmorSets.ADAMANTIUM -> ChatFormatting.YELLOW;
                        default -> ChatFormatting.GRAY;
                    }));
                    ++i;
                }
            }
        }
    }
}

